/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;
import ordermate.integration.diamondback.DiamondBackUpdate;
import ordermate.integration.reservations.DiamondBackBookingsClient;
import ordermate.integration.salesexport.DiamondBackSalesClient;

class DiamondBackGatewayProcessor
implements GatewayProcessor<DiamondBackUpdate> {
    private DiamondBackBookingsClient bookingsClient;
    private DiamondBackSalesClient salesClient;
    private static final long DELAY = 1000L;

    DiamondBackGatewayProcessor() {
    }

    @Override
    public boolean processIncoming(DiamondBackUpdate toProcess) {
        toProcess.incrementAttempts();
        try {
            if (DiamondBackUpdate.Type.Sales.equals((Object)toProcess.getType())) {
                return this.doSales(toProcess);
            }
            if (DiamondBackUpdate.Type.Bookings.equals((Object)toProcess.getType())) {
                return this.doBooking(toProcess);
            }
            OrderMate.LOG.warn("Unknown DiamondBack Update Type " + (Object)((Object)toProcess.getType()));
            return false;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Something bad happened in DiamondBack Processing:", (Throwable)ex);
            return false;
        }
    }

    private boolean doBooking(DiamondBackUpdate toProcess) {
        if (toProcess.getReservation() != null) {
            Reservation res = (Reservation)PersistenceManager.reacquire(toProcess.getReservation());
            return this.getBookingsClient().reservationUpdated(res);
        }
        return true;
    }

    private boolean doSales(DiamondBackUpdate toProcess) {
        long time = toProcess.getSystemTime() + 1000L - System.currentTimeMillis();
        if (time > 0L) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Account reacquired = (Account)PersistenceManager.reacquire(toProcess.getAccount());
        if (toProcess.getReservation() != null) {
            return this.getSalesClient().reservationTransferred(reacquired, toProcess.getReservation());
        }
        return this.getSalesClient().saleUpdated(reacquired);
    }

    private DiamondBackSalesClient getSalesClient() {
        if (this.salesClient == null) {
            this.salesClient = new DiamondBackSalesClient();
        }
        return this.salesClient;
    }

    private DiamondBackBookingsClient getBookingsClient() {
        if (this.bookingsClient == null) {
            this.bookingsClient = new DiamondBackBookingsClient();
        }
        return this.bookingsClient;
    }
}

