/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.util.StringUtils;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.diamondback.DiamondBackGatewayProcessor;
import ordermate.integration.diamondback.DiamondBackUpdate;
import ordermate.integration.reservations.ReservationIntegrator;

public class DiamondBackIntegrator
extends UnicastRemoteObject
implements ReservationIntegrator,
GatewayNotifier<DiamondBackUpdate> {
    public static final ReservationIntegrationType TYPE = ReservationIntegrationType.DIAMONDBACK;
    private static volatile DiamondBackIntegrator instance;
    private static final String DEFAULT_URL = "https://diamondback.ordermatecentral.com/DiamondBack/diamondback/";
    private boolean twoWay = false;
    private Gateway<DiamondBackUpdate> gateway = new Gateway<DiamondBackUpdate>(new DiamondBackGatewayProcessor(), this, 100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DiamondBackIntegrator getInstance() throws RemoteException {
        if (instance != null) return instance;
        Class<DiamondBackIntegrator> clazz = DiamondBackIntegrator.class;
        synchronized (DiamondBackIntegrator.class) {
            if (instance != null) return instance;
            instance = new DiamondBackIntegrator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected DiamondBackIntegrator() throws RemoteException {
        this.gateway.startService();
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack);
        if (config != null) {
            this.twoWay = Boolean.valueOf(config.getCloudPropertyValue("two_way"));
        }
    }

    public static CloudBackConfig getDiamondBackConfig() {
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack);
        if (config == null) {
            config = new CloudBackConfig(CloudServerType.DiamondBack);
            config.setEnabled(true);
            WebserviceIntegrationConfig webConfig = new WebserviceIntegrationConfig();
            webConfig.setDescription("DiamondBack");
            webConfig.setUrl(DEFAULT_URL);
            webConfig.save();
            config.setWebConfig(webConfig);
            config.save();
        }
        return config;
    }

    @Override
    public void synchronize() throws RemoteException {
    }

    @Override
    public void receiptPrinted(Account printed) throws RemoteException {
        List<Reservation> reservations;
        if (printed instanceof TableAccount && (reservations = ReservationsHelper.getReservationsForTableAccount((TableAccount)printed)) != null && !reservations.isEmpty()) {
            for (Reservation res : reservations) {
                this.notifyDiamondback(new DiamondBackUpdate(res));
            }
        }
    }

    @Override
    public void accountClosed(Account closed) throws RemoteException {
        List<Reservation> reservations;
        if (closed instanceof TableAccount && (reservations = ReservationsHelper.getReservationsForTableAccount((TableAccount)closed)) != null && !reservations.isEmpty()) {
            for (Reservation res : reservations) {
                this.notifyDiamondback(new DiamondBackUpdate(res));
            }
        }
        this.notifyDiamondback(new DiamondBackUpdate(closed));
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return false;
    }

    @Override
    public void reservationUpdated(Reservation reservation) throws RemoteException {
        if (this.twoWay || "ARRIVED".equals(reservation.getReservationState())) {
            if (reservation.getTableAccount() != null) {
                this.notifyDiamondback(new DiamondBackUpdate(reservation.getTableAccount()));
            }
            this.notifyDiamondback(new DiamondBackUpdate(reservation));
        }
    }

    @Override
    public void reservationAccountCreated(Account account, int duration) throws RemoteException {
        List<Reservation> reservations;
        if (account instanceof TableAccount && !(reservations = ReservationsHelper.getReservationsForTableAccount((TableAccount)account)).isEmpty()) {
            for (Reservation res : reservations) {
                this.notifyDiamondback(new DiamondBackUpdate(res));
            }
        }
    }

    @Override
    public void reservationAccountTransferred(Account source, Account target, int duration) throws RemoteException {
        if (source != null && target != null && AccountType.tableType.equals(target.getAccountType()) && !source.hasItems()) {
            ExperimentalFeature targetFirst;
            target.setDuration(duration);
            TableAccount targetAcc = (TableAccount)target;
            Reservation sourceReservation = ReservationsHelper.getReservation((TableAccount)source, "ARRIVED");
            Reservation targetReservation = ReservationsHelper.getReservation(targetAcc, "ARRIVED");
            if (targetReservation == null && source instanceof TableAccount && sourceReservation != null) {
                sourceReservation.setTableAccount(targetAcc);
                sourceReservation.setTables(StringUtils.mergeToStringWithSeparator(targetAcc.getTable().getPhysicalTables(), ",", null));
                sourceReservation.save();
                targetReservation = sourceReservation;
            }
            if ((targetFirst = ExperimentalFeature.find("Diamond Target First")) == null || Boolean.TRUE.equals(targetFirst.getBooleanValue(Boolean.TRUE))) {
                this.notifyDiamondback(new DiamondBackUpdate(targetAcc, targetReservation));
                this.notifyDiamondback(new DiamondBackUpdate(targetReservation));
                this.notifyDiamondback(new DiamondBackUpdate(source, sourceReservation));
            } else {
                this.notifyDiamondback(new DiamondBackUpdate(source, sourceReservation));
                this.notifyDiamondback(new DiamondBackUpdate(targetAcc, targetReservation));
                this.notifyDiamondback(new DiamondBackUpdate(targetReservation));
            }
        }
    }

    @Override
    public void accountLinkedToReservation(Account account, Reservation reservation) throws RemoteException {
        Account theRealAccount = reservation.getTableAccount();
        if (theRealAccount != null) {
            this.notifyDiamondback(new DiamondBackUpdate(theRealAccount));
        }
    }

    @Override
    public void synchronizeReservations() throws RemoteException {
    }

    @Override
    public void reservationTableClosed(Reservation reservation) throws RemoteException {
        this.notifyDiamondback(new DiamondBackUpdate(reservation));
    }

    @Override
    public void clearReservations() throws RemoteException {
    }

    @Override
    public void notifyProcess(DiamondBackUpdate processedValue, boolean processSuccessful) {
    }

    private void notifyDiamondback(DiamondBackUpdate update) {
        if (DiamondBackIntegrator.getDiamondBackConfig().isEnabled()) {
            OrderMate.LOG.info("DB Queue:" + this.gateway.getIncomingQueue().size());
            this.gateway.putIntoQueue(update);
        } else {
            OrderMate.LOG.info("DB Queue not used, disabled");
        }
    }

    @Override
    public ReservationIntegrator.ReservationTwoWay getTwoWayIntegration() throws RemoteException {
        return this.twoWay ? ReservationIntegrator.ReservationTwoWay.Implied : ReservationIntegrator.ReservationTwoWay.Unsupported;
    }
}

