/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import javax.ws.rs.core.Response;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.webservice.RestHelper;

public class DiamondBackSetup {
    private final GuiHandler gui;
    private final RestHelper rest;
    private final String type;
    private final long storeId;
    private final CloudBackConfig config;

    public DiamondBackSetup(GuiHandler gui, String type) {
        this.gui = gui == null ? new DummyGUIHandler() : gui;
        this.rest = new RestHelper();
        this.type = type;
        this.storeId = SystemCurrentInfo.getInstance().getRedbackId();
        this.config = CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack);
    }

    public void doSetup() {
        if (this.storeId < 0L) {
            this.gui.displayErrorDialog("Cannot Setup Integration", "Store ID has not been set, setup cannot continue", "Please contact OrderMate POS for your Store ID");
            return;
        }
        String current = this.getCurrentIntegration();
        if (current != null) {
            this.doRequirements();
        } else {
            this.doSelectIntegrator();
        }
    }

    private String getCurrentIntegration() {
        WebResource resource = this.rest.getResource(this.config.getWebConfig().getUrl() + "common/getStoreIntegration/" + this.storeId + "/" + this.type);
        Response response = (Response)resource.get(Response.class);
        if (response != null && response.getStatus() == 200) {
            String value = String.valueOf(response.getEntity());
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            return value;
        }
        this.gui.displayErrorDialog("Cannot Setup Integration", "The setup cannot continue", "No response received from Cloud Server.");
        return null;
    }

    private void doSelectIntegrator() {
        WebResource resource = this.rest.getResource(this.config.getWebConfig().getUrl() + "common/getIntegrations/" + this.type);
        Response response = (Response)resource.get(Response.class);
        if (response != null && response.getStatus() == 200) {
            List<String> providers = StringUtils.splitToList(String.valueOf(response.getEntity()), ",");
            String provider = (String)this.gui.displayChoiceDialog(this.type + " Provider", "Please select the required provider", providers, providers.get(0));
            if (provider != null) {
                this.setProvider(provider);
            }
        } else {
            this.gui.displayErrorDialog("Cannot Setup Integration", "The setup cannot continue", String.valueOf(response.getEntity()));
        }
    }

    private void setProvider(String provider) {
        WebResource resource = this.rest.getResource(this.config.getWebConfig().getUrl() + "common/getIntegrations/" + this.type);
        Response response = (Response)resource.get(Response.class);
        resource = this.rest.getResource(this.config.getWebConfig().getUrl() + "common/setStoreIntegration/" + this.storeId + "/" + this.type);
        resource = this.rest.addParameter(resource, "provider", provider);
        response = (Response)resource.put(Response.class);
    }

    private void doRequirements() {
        WebResource resource = this.rest.getResource(this.config.getWebConfig().getUrl() + "common/getStoreIntegration/" + this.storeId + "/" + this.type);
        Response response = (Response)resource.get(Response.class);
    }
}

