/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;

public class DiamondBackUpdate {
    private final Type type;
    private Account account;
    private Reservation reservation;
    private int attempt = 0;
    private final long systemTime;

    public DiamondBackUpdate(Reservation reservation) {
        this.reservation = reservation;
        this.type = Type.Bookings;
        this.systemTime = System.currentTimeMillis();
    }

    public DiamondBackUpdate(Account account, Reservation reservation) {
        this.account = account;
        this.reservation = reservation;
        this.type = Type.Sales;
        this.systemTime = System.currentTimeMillis();
    }

    public DiamondBackUpdate(Account account) {
        this.account = account;
        this.type = Type.Sales;
        this.systemTime = System.currentTimeMillis();
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public Type getType() {
        return this.type;
    }

    public Account getAccount() {
        return this.account;
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void incrementAttempts() {
        ++this.attempt;
    }

    public int getAttempts() {
        return this.attempt;
    }

    public static enum Type {
        Sales,
        Bookings;

    }
}

