/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import au.com.diamondback.xmlintegration.report.DiamondSummaryReport;
import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.diamondback.DiamondReportConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.integration.diamondback.DiamondBackDataHelper;
import ordermate.integration.types.PosIntegrationSummaryFactory;

public class DiamondSummaryReportExporter
extends CloudBackClient {
    private static final String REPORT = "report/v1/general/";
    private static final String SUMMARY_REPORT = "/summary_report";
    private DiamondReportConfig diamondReportConfig = DiamondReportConfig.getConfig();
    private final PosIntegrationSummaryFactory factory = new PosIntegrationSummaryFactory();

    public DiamondSummaryReportExporter() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack));
    }

    @Override
    protected String getSSLProtocol() {
        return "TLSv1.2";
    }

    @Override
    protected String getBaseURL() {
        String url = super.getBaseURL();
        return url + REPORT;
    }

    public boolean canExport() {
        if (!this.diamondReportConfig.isEnabled()) {
            OrderMate.LOG.info("Cannot push Diamond Summary Report if DiamondSummaryReport is disabled");
            return false;
        }
        return true;
    }

    public DiamondReportConfig getDiamondReportConfig() {
        return this.diamondReportConfig;
    }

    public boolean performExport(Date date) {
        Date pushDate = date;
        if (pushDate == null) {
            pushDate = TradingDayQueries.getLastClosedTradingDay().getDate();
        }
        TradingDay tradingDay = TradingDayQueries.getTradingDay(pushDate);
        OrderMate.LOG.info("Performing Push DiamondBack Summary Report for " + pushDate);
        if (tradingDay == null) {
            OrderMate.LOG.info("No trading day for date " + pushDate);
            this.diamondReportConfig.setLastPushDate(pushDate);
            this.diamondReportConfig.save();
            return true;
        }
        DiamondBackDataHelper diamondDataHelper = new DiamondBackDataHelper();
        DiamondSummaryReport summaryReport = diamondDataHelper.createDiamondBackSummaryReport(tradingDay);
        boolean exported = this.exportData(summaryReport);
        if (exported) {
            this.diamondReportConfig.setLastPushDate(pushDate);
            this.diamondReportConfig.save();
        }
        return exported;
    }

    public boolean exportData(DiamondSummaryReport summaryReport) {
        if (summaryReport == null) {
            return true;
        }
        OrderMate.LOG.info("Pushing DiamondBack Summary Report");
        WebResource.Builder builder = super.setupResource(SystemCurrentInfo.getInstance().getRedbackId() + SUMMARY_REPORT, new Pair[0]);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/xml"})).type("application/xml")).post(ClientResponse.class, (Object)summaryReport);
        if (response.getStatus() / 100 == 2) {
            String entity = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Upload Booking to Diamondback successful:" + entity);
            return true;
        }
        OrderMate.LOG.error("Cannot upload Booking information to Diamondback.");
        try {
            OrderMate.LOG.error("Response:" + (String)response.getEntity(String.class));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to parse the response.");
        }
        return false;
    }
}

