/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.drivertracking;

import au.com.diamondback.xmlintegration.drivertracking.DiamondAddress;
import au.com.diamondback.xmlintegration.drivertracking.DiamondContact;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDelivery;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDriverResponse;
import au.com.diamondback.xmlintegration.drivertracking.ObjectFactory;
import java.math.BigDecimal;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;
import ordermate.integration.DiamondBackClient;
import ordermate.misc.GeocodeLocation;
import ordermate.misc.GeocodingHelper;
import ordermate.misc.ObjectMarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class DBDriverTrackingClient
extends DiamondBackClient {
    private static final String DB_UPDATE = "/driver/update";

    public boolean assignDelivery(PhoneAccount account, User driver) {
        DiamondDelivery dd = this.convertToDelivery(account, driver);
        StringEntity entity = null;
        try {
            entity = new StringEntity(new ObjectMarshaller().marshal(dd));
            entity.setContentType("application/json");
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to build the entity to post to DiamondBack!", (Throwable)e);
            return false;
        }
        String baseUrl = driver.getDriverTracking().getWebConfig().getUrl();
        HttpPost post = new HttpPost(baseUrl + DB_UPDATE);
        post.setEntity((HttpEntity)entity);
        this.setAuthorization((HttpUriRequest)post, driver.getDriverTracking().getWebConfig().getUsername() + ":" + driver.getDriverTracking().getWebConfig().getPassword());
        DiamondDriverResponse response = this.performRequest(DiamondDriverResponse.class, (HttpUriRequest)post);
        return response != null && response.isSuccess() != null && response.isSuccess() != false;
    }

    public boolean updateDelivery(PhoneAccount account, User driver) {
        return this.assignDelivery(account, driver);
    }

    public boolean cancelDelivery(PhoneAccount account, User driver) {
        return false;
    }

    final DiamondDelivery convertToDelivery(Account deliveryAcc, User driver) {
        DiamondDelivery dd = new ObjectFactory().createDiamondDelivery();
        dd.setAccountId(deliveryAcc.getID() != null ? deliveryAcc.getID() : 0L);
        dd.setStoreId(SystemCurrentInfo.getInstance().getUpdatemateId());
        dd.setProvider(driver.getDriverTracking().getIntegrationType().toString());
        dd.setOwing(deliveryAcc.isOpen() ? deliveryAcc.getDue().toBigDecimal() : BigDecimal.ZERO);
        dd.setValue(deliveryAcc.getTotal().toBigDecimal());
        dd.setComment(deliveryAcc.getComment());
        if (deliveryAcc.getCustomer() != null) {
            GeocodingHelper geodude;
            GeocodeLocation location;
            Customer cust = deliveryAcc.getCustomer();
            DiamondContact contact = new ObjectFactory().createDiamondContact();
            contact.setContactName(cust.getName());
            contact.setEmail(cust.getEmail());
            contact.setPhone(cust.getPhoneNumber());
            dd.setContact(contact);
            DiamondAddress address = new ObjectFactory().createDiamondAddress();
            address.setCity(cust.getSuburb());
            address.setNumber(cust.getHouseNumber());
            address.setPostCode(cust.getPostcode());
            address.setState(cust.getState());
            if (cust.getStreetName() != null && cust.getStreetType() != null) {
                address.setStreet(cust.getStreetName() + " " + cust.getStreetType());
            }
            if ((location = (geodude = new GeocodingHelper()).getGeocodeLocationForAddress(this.buildAddressString(address))) != null) {
                address.setLat(location.getLat());
                address.setLong(location.getLng());
            }
            dd.setDeliverTo(address);
        }
        return dd;
    }

    private String buildAddressString(DiamondAddress address) {
        return this.safelyAppend(address.getNumber()) + " " + this.safelyAppend(address.getStreet()) + " " + this.safelyAppend(address.getCity()) + " " + this.safelyAppend(address.getPostCode()) + " " + this.safelyAppend(address.getState()) + " " + this.safelyAppend(address.getCountry()) + " ";
    }

    private String safelyAppend(String toAppend) {
        return toAppend != null ? toAppend : "";
    }
}

