/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.dynamicnmenu;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlIDREF;
import ordermate.OrderMate;
import ordermate.integration.dynamicnmenu.DynamicReferenceHandler;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;
import ordermate.jaxb.exporter.handlers.online.idstrategy.MasterIDStrategy;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.SimpleHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.stock.RefTrackerHandlerWrapper;
import org.apache.commons.collections.map.MultiKeyMap;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class DynamicMenuIntegrationContext
extends AbstractXMLIntegrationContext<ObjectFactory> {
    private static MultiKeyMap handlerTypeMap;
    private static Set<Class> refType;
    private final Long storeId;

    protected DynamicMenuIntegrationContext(IntegrationIDStrategy strategy, PersistenceDelegate delegate, Long storeId) {
        super(strategy, delegate);
        this.storeId = storeId;
        if (storeId != null && strategy instanceof MasterIDStrategy) {
            ((MasterIDStrategy)this.getIDGenStrategy()).setExistingWhereClause("store_id = " + storeId);
        }
    }

    @Override
    protected <T extends PersistentObject, E> Handler<T, E, ObjectFactory> doHandlerNotFound(Class<? extends T> domainType, Class<E> exportEntityType) {
        this.initHandlers();
        Class handlerClass = (Class)handlerTypeMap.get(domainType, exportEntityType);
        if (handlerClass != null) {
            try {
                Constructor constructor = handlerClass.getConstructor(AbstractXMLIntegrationContext.class);
                constructor.setAccessible(true);
                Handler theHandler = (Handler)constructor.newInstance(this);
                this.register(theHandler);
                return theHandler;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot instantiate a new handler of type " + handlerClass, (Throwable)ex);
            }
        } else {
            if (refType.contains(exportEntityType)) {
                DynamicReferenceHandler refHandler = new DynamicReferenceHandler(domainType, exportEntityType, (AbstractXMLIntegrationContext)this);
                this.register(refHandler);
                return refHandler;
            }
            Class<? extends T> ourType = domainType;
            Class<E> expType = exportEntityType;
            Handler<? extends T, E, ObjectFactory> newHandler = SimpleHandler.createHandler(this.getIDGenStrategy().getIDProperty(ourType), ourType, expType, this);
            this.register((Handler<T, E, ObjectFactory>)newHandler);
            return newHandler;
        }
        OrderMate.LOG.error("No handler for type " + domainType);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initHandlers() {
        if (handlerTypeMap != null && refType != null) return;
        Class<DynamicMenuIntegrationContext> clazz = DynamicMenuIntegrationContext.class;
        synchronized (DynamicMenuIntegrationContext.class) {
            if (handlerTypeMap == null) {
                this.doHandlerTypeMap();
            }
            if (refType != null) return;
            this.doRefHandlers();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doHandlerTypeMap() {
        handlerTypeMap = new MultiKeyMap();
        String directory = "ordermate.jaxb.exporter.handlers.posdatabase";
        Reflections refs = new Reflections(directory, new Scanner[]{new TypeAnnotationsScanner()});
        HashSet classes = new HashSet(refs.getTypesAnnotatedWith(Handles.class));
        for (Class nextClazz : classes) {
            Handles handles = nextClazz.getAnnotation(Handles.class);
            if (handles == null) continue;
            handlerTypeMap.put((Object)handles.domainClass(), (Object)handles.exportClass(), (Object)nextClazz);
        }
    }

    private void doRefHandlers() {
        refType = new HashSet<Class>();
        String dir = "au.com.ordermate.xmlintegration.system.posdatabase";
        Reflections refs = new Reflections(dir, new Scanner[]{new FieldAnnotationsScanner()});
        Set fields = refs.getFieldsAnnotatedWith(XmlIDREF.class);
        for (Field field : fields) {
            refType.add(field.getDeclaringClass());
        }
    }

    @Override
    public <T extends PersistentObject, E> Handler<T, E, ObjectFactory> register(Handler<T, E, ObjectFactory> handler) {
        if (this.storeId != null) {
            Handler wrappedHandler;
            if (handler instanceof AbstractHandler) {
                this.updateHandler((AbstractHandler)handler);
            } else if (handler instanceof RefTrackerHandlerWrapper && (wrappedHandler = ((RefTrackerHandlerWrapper)handler).getWrappedHandler()) instanceof AbstractHandler) {
                this.updateHandler((AbstractHandler)wrappedHandler);
            }
        }
        return super.register(handler);
    }

    private void updateHandler(AbstractHandler handler) {
        handler.setExistingWhereClause("store_id = " + this.storeId);
        if (handler instanceof PropertyHandler) {
            ((PropertyHandler)handler).setOverrideStoreId(this.storeId);
        }
    }
}

