/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.dynamicnmenu;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;

public class DynamicReferenceHandler<T extends PersistentObject, E, OF>
extends AbstractHandler<T, E, OF> {
    Class<E> exportClass;
    Class<T> domainClass;

    protected DynamicReferenceHandler(Class<T> newDomainClass, Class<E> newExportClass, AbstractXMLIntegrationContext integrationContext) {
        super(newDomainClass, newExportClass, integrationContext);
        this.exportClass = newExportClass;
        this.domainClass = newDomainClass;
    }

    @Override
    public E exportDomainObject(PersistentObject domainObj, Object objectFactory) throws ExportException {
        if (domainObj == null) {
            return null;
        }
        Long id = domainObj.getID();
        if (domainObj instanceof ExportableObject) {
            id = this.getIntegrationContext().getIDGenStrategy().getID((ExportableObject)((Object)domainObj));
        }
        E refHolder = null;
        try {
            refHolder = this.exportClass.newInstance();
            this.exportClass.getMethod("setDomainId", Long.class).invoke(refHolder, id);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot instantiate reference holder from class ", (Throwable)e);
        }
        return refHolder;
    }

    @Override
    public PersistentObject importElement(Object element, PersistentObject parent) throws UnmarshalException {
        try {
            Long id = (Long)this.exportClass.getMethod("getDomainId", new Class[0]).invoke(element, new Object[0]);
            if (id != null) {
                Class<T> toFind = this.domainClass;
                PersistentObject found = (PersistentObject)this.getIntegrationContext().getIDGenStrategy().find(toFind, id);
                if (found == null) {
                    // empty if block
                }
                return found;
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get the domain id!", (Throwable)ex);
        }
        return null;
    }
}

