/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.dynamicnmenu;

import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuItem;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSectionRef;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryIngredients;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.integration.dynamicnmenu.DynamicMenuIntegrationExporter;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;

public class MenuIntegrationHelper {
    private static final String ITEM = "item";
    private static final String UNIT = "unit";
    private static final String OPTION = "option";
    private static final String PLUS = "plus";
    private static final String MINUS = "minus";
    private static final String INGREDIENT = "ingredient";
    private final PersistenceDelegate persistence;
    private final IntegrationIDStrategy idStrategy;

    public MenuIntegrationHelper(PersistenceDelegate persistence) {
        this.persistence = persistence;
        this.idStrategy = IntegrationIDStrategyFactory.getStrategy(OnlineIntegrationIDStrategy.MASTER_ID, persistence);
    }

    public Class<? extends PersistentObject> resolveType(String value) {
        Class clazz = null;
        if (OPTION.equals(value)) {
            clazz = InventoryOption.class;
        } else if (PLUS.equals(value)) {
            clazz = InventoryAdd.class;
        } else if (MINUS.equals(value)) {
            clazz = InventoryRemove.class;
        } else if (INGREDIENT.equals(value)) {
            clazz = InventoryIngredients.class;
        } else if (UNIT.equals(value)) {
            clazz = InventoryItemUnit.class;
        } else if (ITEM.equals(value)) {
            clazz = InventoryItem.class;
        }
        return clazz;
    }

    public InventoryItem wrangleItem(String itemXml, InventoryGroup parentGroup, Long storeId) throws Exception {
        ByteArrayInputStream bin;
        InventoryItem item = null;
        DynamicMenuIntegrationExporter<PosMenuItem, InventoryItem> exporter = new DynamicMenuIntegrationExporter<PosMenuItem, InventoryItem>(this.idStrategy, InventoryItem.class, PosMenuItem.class, PersistenceManager.getPersistenceDelegate(), storeId);
        PosMenuItem newItem = (PosMenuItem)exporter.unmarshall(bin = new ByteArrayInputStream(itemXml.getBytes()));
        if (newItem != null) {
            PosMenuSectionRef desiredSection = newItem.getSection();
            InventoryGroup desiredGroup = parentGroup;
            if (desiredSection != null && desiredSection.getDomainId() != null) {
                desiredGroup = this.idStrategy.find(InventoryGroup.class, desiredSection.getDomainId());
                if (desiredGroup == null) {
                    OrderMate.LOG.warn("Cannot find inventoryGroup for ID:" + desiredSection.getDomainId());
                    desiredGroup = parentGroup;
                } else {
                    OrderMate.LOG.warn("Found import group:" + desiredGroup);
                }
            } else {
                OrderMate.LOG.warn("No section specified, using default.");
            }
            item = exporter.attemptToImport(newItem, desiredGroup);
            if (item.getMenuGroup() == null) {
                item.setMenuGroup(desiredGroup);
            }
        } else {
            OrderMate.LOG.warn("No item has been created from the incoming xml");
        }
        return item;
    }

    public String convertItemToXml(InventoryItem item) {
        DynamicMenuIntegrationExporter<PosMenuItem, InventoryItem> itemExporter = new DynamicMenuIntegrationExporter<PosMenuItem, InventoryItem>(IntegrationIDStrategyFactory.getStrategy(OnlineIntegrationIDStrategy.MASTER_ID, this.persistence), InventoryItem.class, PosMenuItem.class, this.persistence, 0L);
        PosMenuItem export = itemExporter.getAsExport(item);
        if (item.getMenuGroupId() != null) {
            PosMenuSectionRef section = new PosMenuSectionRef();
            section.setDomainId(item.getMenuGroupId());
            export.setSection(section);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            itemExporter.marshal((InventoryItem)export, bout);
            bout.flush();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot export item for dynamic menu");
        }
        return new String(bout.toByteArray());
    }
}

