/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos;

import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.integration.eftpos.EftposUtil;
import ordermate.integration.eftpos.PhysicalEftposFactory;
import ordermate.integration.eftpos.adyen.AdyenEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposFactory;
import ordermate.integration.eftpos.ingenico.IngenicoEftpos;
import ordermate.integration.eftpos.linklycloud.LinklyCloudEftpos;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.mx51.SpiceEftpos;
import ordermate.integration.eftpos.online.OnlineEftpos;
import ordermate.integration.eftpos.paypal.PayPalEftpos;
import ordermate.integration.eftpos.smartpay.SmartpayEftpos;
import ordermate.integration.eftpos.tyro.TyroEftpos;
import ordermate.integration.eftpos.tyro.webservice.TyroWebEftpos;

public class DefaultPhysicalEftposFactory
extends PhysicalEftposFactory {
    @Override
    public PhysicalEftpos createPhysicalEftpos(VirtualEftpos eftpos, EftposToolkit toolkit) {
        if (eftpos == null) {
            throw new IllegalArgumentException("Unknown Eftpos type: null");
        }
        PhysicalEftpos adapter = null;
        EftposType type = eftpos.getEftposType();
        if (EftposType.TYRO.equals(type)) {
            adapter = new TyroEftpos();
        } else if (EftposUtil.isIngenicoType(type)) {
            adapter = new IngenicoEftpos(toolkit.getUI());
        } else if (EftposType.TYROWEB.equals(type)) {
            if (toolkit.getGuiHandler() == null) {
                throw new IllegalStateException("Cannot call Tyro Web Eftpos without a guiHandler in the EftposToolkit");
            }
            adapter = new TyroWebEftpos(toolkit);
        } else if (EftposType.ASSEMBLY.equals(type)) {
            if (toolkit.getGuiHandler() == null) {
                throw new IllegalStateException("Cannot call Assembly Eftpos without a guiHandler in the EftposToolkit");
            }
            adapter = AssemblyEftposFactory.getAssemblyEftpos(toolkit, eftpos);
        } else if (EftposType.MX51SPICE.equals(type)) {
            adapter = new SpiceEftpos();
        } else if (EftposType.SMARTPAY.equals(type)) {
            adapter = new SmartpayEftpos();
        } else if (EftposType.ADYEN.equals(type)) {
            adapter = new AdyenEftpos(toolkit.getUI());
        } else if (EftposType.LINKLYCLOUD.equals(type)) {
            adapter = new LinklyCloudEftpos(toolkit.getGuiHandler());
        } else if (EftposType.ONLINE.equals(type)) {
            if (toolkit.getGuiHandler() == null) {
                throw new IllegalStateException("Cannot call Online Eftpos without a guiHandler in the EftposToolkit");
            }
            adapter = new OnlineEftpos(toolkit, eftpos);
        } else if (type != null) {
            adapter = this.getWebPaymentEftpos(type, toolkit);
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Unknown Eftpos type:" + eftpos.getEftposType());
        }
        return adapter;
    }

    @Override
    protected PhysicalEftpos getWebPaymentEftpos(EftposType type, EftposToolkit toolkit) {
        WebPaymentType paymentType;
        WebPaymentIntegration integration = type.getWebPaymentIntegration();
        if (integration != null && WebPaymentType.PayPal.equals((Object)(paymentType = integration.getType()))) {
            return new PayPalEftpos(toolkit);
        }
        throw new IllegalArgumentException("Type or integration type is null: " + integration);
    }
}

