/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos;

import au.com.ordermate.util.Price;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.sales.Customer;

public class EftposResult {
    private final EftposRequest request;
    private final EftposStatus eftposStatus;
    private final FinanceUnit cardType;
    private final Price actualPaid;
    private final Price actualCashout;
    private final Price actualTip;
    private final Price actualSurcharge;
    private final String terminalID;
    private String source;
    private final String explicitError;
    private final Customer accCustomer;
    private final EftposTransaction oldTransaction;
    private boolean showError = true;

    @Deprecated
    public EftposResult(EftposRequest initialRequest, EftposStatus eftStatus, FinanceUnit typeOfCard, Price actuallyPaid, Price actuallyTip, Price actuallySurcharged, Price actuallyCashout, String termID) {
        this.request = initialRequest;
        this.oldTransaction = this.request.getTransaction();
        this.eftposStatus = eftStatus;
        this.cardType = typeOfCard;
        this.actualPaid = actuallyPaid;
        this.actualCashout = actuallyCashout;
        this.actualTip = actuallyTip;
        this.actualSurcharge = actuallySurcharged;
        this.terminalID = termID;
        this.explicitError = null;
        this.accCustomer = null;
    }

    @Deprecated
    public EftposResult(EftposRequest initialRequest, EftposStatus eftStatus, FinanceUnit typeOfCard, Price actuallyPaid, Price actuallyTip, Price actuallySurcharged, Price actuallyCashout, String termID, String explicitErr) {
        this.request = initialRequest;
        this.oldTransaction = this.request.getTransaction();
        this.eftposStatus = eftStatus;
        this.cardType = typeOfCard;
        this.actualPaid = actuallyPaid;
        this.actualCashout = actuallyCashout;
        this.actualTip = actuallyTip;
        this.actualSurcharge = actuallySurcharged;
        this.terminalID = termID;
        this.explicitError = explicitErr;
        this.accCustomer = null;
    }

    EftposResult(EftposRequest initialRequest, EftposStatus eftStatus, FinanceUnit typeOfCard, Price actuallyPaid, Price actuallyTip, Price actuallySurcharged, Price actuallyCashout, String termID, String explicitErr, Customer newCustomer, String source) {
        this.request = initialRequest;
        this.oldTransaction = this.request.getTransaction();
        this.eftposStatus = eftStatus;
        this.cardType = typeOfCard;
        this.actualPaid = actuallyPaid;
        this.actualCashout = actuallyCashout;
        this.actualTip = actuallyTip;
        this.actualSurcharge = actuallySurcharged;
        this.terminalID = termID;
        this.explicitError = explicitErr;
        this.accCustomer = newCustomer;
        this.source = source;
    }

    @Deprecated
    public EftposResult(EftposRequest initialRequest) {
        this(initialRequest, EftposStatus.PENDING, initialRequest.getTransaction().getSubType(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, null);
    }

    public final EftposRequest getRequest() {
        return this.request;
    }

    public final EftposTransaction.TransactionStatus getTransactionStatus() {
        return this.request.getTransaction().getTransactionStatus();
    }

    public final EftposStatus getEftposStatus() {
        return this.eftposStatus;
    }

    public final FinanceUnit getCardType() {
        return this.cardType;
    }

    public boolean isApproved() {
        return EftposStatus.APPROVED.equals(this.eftposStatus) && EftposTransaction.TransactionStatus.PROCESSED.equals((Object)this.getTransactionStatus());
    }

    public Price getActualPaid() {
        return this.actualPaid;
    }

    public Price getActualCashout() {
        return this.actualCashout;
    }

    public Price getActualTip() {
        return this.actualTip;
    }

    public Price getActualSurcharge() {
        return this.actualSurcharge;
    }

    public Price getTotalActualPayment() {
        return this.actualPaid.add(this.actualTip);
    }

    public EftposTransaction getOldEftposTransaction() {
        return this.oldTransaction;
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    public String getExplicitError() {
        return this.explicitError;
    }

    public Customer getCustomer() {
        return this.accCustomer;
    }

    public boolean hasExplicitError() {
        return this.explicitError != null && !this.explicitError.isEmpty();
    }

    public boolean isShowError() {
        return this.showError;
    }

    public void setShowError(boolean value) {
        this.showError = value;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public static EftposResult adjustment(EftposRequest request, EftposStatus status) {
        if (request.getTransaction() != null) {
            EftposTransaction txn = request.getTransaction();
            return new EftposResult(request, status, txn.getSubType(), txn.getPaid(), txn.getTip(), txn.getSurcharge(), txn.getCashOut(), null);
        }
        return new EftposResult(request, status, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
    }

    public String toString() {
        return this.eftposStatus.getLabel();
    }
}

