/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos;

import au.com.ordermate.util.Price;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.sales.Customer;
import ordermate.integration.eftpos.EftposResult;

public class EftposResultBuilder {
    private final EftposRequest request;
    private EftposStatus eftposStatus;
    private FinanceUnit cardType;
    private Price actualPaid;
    private Price actualCashout;
    private Price actualTip;
    private Price actualSurcharge;
    private String terminalID;
    private String explicitError;
    private Customer accCustomer;
    private String source;

    public EftposResultBuilder(EftposRequest request) {
        this.request = request;
    }

    public EftposResult build() {
        this.checkNullFields();
        return new EftposResult(this.request, this.eftposStatus, this.cardType, this.actualPaid, this.actualTip, this.actualSurcharge, this.actualCashout, this.terminalID, this.explicitError, this.accCustomer, this.source);
    }

    public EftposResultBuilder configureForIncompleteResult() {
        return this.setEftposStatus(EftposStatus.PENDING).setFinanceUnit(this.request.getTransaction().getSubType()).setActualPaid(Price.ZERO_DOLLAR);
    }

    private void checkNullFields() {
        if (this.eftposStatus == null) {
            throw new IllegalStateException("must set an EftposStatus to the builder eg: EftposStatus.APPROVED");
        }
        if (this.cardType == null) {
            throw new IllegalStateException("must set an FinanceUnit for the cardType to the builder eg: FinanceUnit.getAllEftposUnits()");
        }
        if (this.actualPaid == null) {
            throw new IllegalStateException("must set an actualPaid for the builder eg: new Price.parse(\"1000.00\")");
        }
        if (this.actualTip == null) {
            this.actualTip = Price.ZERO_DOLLAR;
        }
        if (this.actualCashout == null) {
            this.actualCashout = Price.ZERO_DOLLAR;
        }
        if (this.actualSurcharge == null) {
            this.actualSurcharge = Price.ZERO_DOLLAR;
        }
        if (this.terminalID == null) {
            this.terminalID = "";
        }
    }

    public EftposResultBuilder setEftposStatus(EftposStatus newVal) {
        this.eftposStatus = newVal;
        return this;
    }

    public EftposResultBuilder setFinanceUnit(FinanceUnit newVal) {
        this.cardType = newVal;
        return this;
    }

    public EftposResultBuilder setActualPaid(Price newVal) {
        this.actualPaid = newVal;
        return this;
    }

    public EftposResultBuilder setActualCashout(Price newVal) {
        this.actualCashout = newVal;
        return this;
    }

    public EftposResultBuilder setActualTip(Price newVal) {
        this.actualTip = newVal;
        return this;
    }

    public EftposResultBuilder setActualSurcharge(Price value) {
        this.actualSurcharge = value;
        return this;
    }

    public EftposResultBuilder setTerminalID(String newVal) {
        this.terminalID = newVal;
        return this;
    }

    public EftposResultBuilder source(String value) {
        this.source = value;
        return this;
    }

    public EftposResultBuilder setExplicitError(String newVal) {
        this.explicitError = newVal;
        return this;
    }

    public EftposResultBuilder setCustomer(Customer newVal) {
        this.accCustomer = newVal;
        return this;
    }
}

