/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.adyen;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.adyen.AdyenCardAcquisitionResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageHeader;
import au.com.ordermate.xmlintegration.adyen.AdyenNotificationRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenNotificationRequestItem;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentReceipt;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthAdditionalData;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthAmount;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.integration.adyen.AdyenLoyalty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.adyen.AdyenEftposResult;
import ordermate.integration.eftpos.adyen.AdyenError;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;
import ordermate.integration.eftpos.adyen.AdyenUtils;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;

public class AdyenEftpos
implements PhysicalEftpos {
    private VirtualEftpos vEft;
    private final IntegratedPaymentUI ui;
    private Timer timer;
    private final String CLOSE = "Settle";
    private final String EXTEND = "Extend";
    private final String TOPUP = "Topup";
    private final String VOID = "Void";
    private static final String PARTIAL_NOTE = "Partial Refund";
    private static final String FULLY_REFUND = "Fully Refund";

    public AdyenEftpos(IntegratedPaymentUI ui) {
        this.ui = ui;
        ui.setCancelVisible(true);
        ui.setCancelEnabled(true);
        ui.getCancelSignal().connect(this, "gotCancel");
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.vEft = virtualEftpos;
    }

    @Override
    public void closeOff() {
        this.ui.getCancelSignal().disconnectAll();
        this.ui.closeBlockingInterface();
    }

    private String createTransactionId() {
        Long unixTime = System.currentTimeMillis();
        if (unixTime.toString().length() > 10) {
            return unixTime.toString().substring(unixTime.toString().length() - 10);
        }
        return unixTime.toString();
    }

    public AdyenMessageHeader createHeader(String txnID, String type) {
        return AdyenUtils.createHeader("3.0", "Service", type, "Request", this.vEft.getMerchantId(), txnID, this.vEft.getTerminalId());
    }

    public EftposResult generateError(EftposRequest request) {
        return this.generateError(request, "XXXX-XXXX");
    }

    public EftposResult generateError(EftposRequest request, String errorMsg) {
        return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, AdyenError.getDisplayValue(errorMsg));
    }

    public boolean checkError(AdyenPaymentResponse resp) {
        return resp == null || !resp.getResponse().getResult().equals("Success");
    }

    public AdyenMessage getCardData(EftposRequest request) {
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "CardAcquisition");
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createCardAcquisitionRequest(header, posRefId, request.getTransaction().getPaid()));
        return AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
    }

    public AdyenLoyalty getLoyaltyObject(AdyenMessage msg) {
        if (msg == null) {
            return null;
        }
        AdyenCardAcquisitionResponse r = msg.getSaleToPOIResponse().getCardAcquisitionResponse();
        if (!r.getResponse().getResult().equals("Success")) {
            return null;
        }
        return new AdyenLoyalty(AdyenUtils.getDataPropertyValue("alias", r.getResponse().getAdditionalResponse()), AdyenUtils.getDataPropertyValue("cardBin", r.getResponse().getAdditionalResponse()), AdyenUtils.getDataPropertyValue("cardScheme", r.getResponse().getAdditionalResponse()));
    }

    public void refreshTransactionID() {
        this.vEft.setLastTxnReference(this.createTransactionId());
        this.vEft.save();
    }

    public void deleteTransactionID() {
        this.vEft.setLastTxnReference(null);
        this.vEft.save();
    }

    public EftposResult doPayment(EftposRequest request) {
        AdyenMessage r;
        AdyenSaleToPOIResponse resp;
        this.refreshTransactionID();
        AdyenLoyalty loyaltyObj = null;
        AdyenMessage cardData = null;
        if (this.vEft.isSupportsCardAcq()) {
            cardData = this.getCardData(request);
            loyaltyObj = this.getLoyaltyObject(cardData);
            if (loyaltyObj == null) {
                this.doCancelRequest();
                if (cardData == null || cardData.getSaleToPOIResponse().getCardAcquisitionResponse() == null) {
                    return this.generateError(request);
                }
                return this.generateError(request, cardData.getSaleToPOIResponse().getCardAcquisitionResponse().getResponse().getErrorCondition());
            }
            this.refreshTransactionID();
        }
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "Payment");
        AdyenMessage adyenReq = new AdyenMessage();
        if (request.isMoto()) {
            adyenReq.setSaleToPOIRequest(AdyenUtils.createMOTOPOIRequest(header, posRefId, request.getTransaction().getPaid().add(request.getTransaction().getCashOut()), request.getTransaction().getTip(), request.getTransaction().getCashOut(), loyaltyObj == null ? null : cardData.getSaleToPOIResponse().getCardAcquisitionResponse().getPoiData().getPoiTransactionID().getTimeStamp(), loyaltyObj == null ? null : cardData.getSaleToPOIResponse().getCardAcquisitionResponse().getPoiData().getPoiTransactionID().getTransactionID()));
        } else {
            adyenReq.setSaleToPOIRequest(AdyenUtils.createPaymentPOIRequest(header, posRefId, request.getTransaction().getPaid().add(request.getTransaction().getCashOut()), request.getTransaction().getTip(), request.getTransaction().getCashOut(), loyaltyObj == null ? null : cardData.getSaleToPOIResponse().getCardAcquisitionResponse().getPoiData().getPoiTransactionID().getTimeStamp(), loyaltyObj == null ? null : cardData.getSaleToPOIResponse().getCardAcquisitionResponse().getPoiData().getPoiTransactionID().getTransactionID()));
        }
        if (request.getTransaction().getSurcharge() != null) {
            adyenReq.getSaleToPOIRequest().getPaymentRequest().getSaleData().setSaleToAcquirerData(AdyenUtils.addSaleToAcquirerData(adyenReq.getSaleToPOIRequest().getPaymentRequest().getSaleData(), "&metadata.surchargeAmount=" + request.getTransaction().getSurcharge().getNumCents()));
        }
        if (request.getTransaction().getVirtualEftpos().isEnableTip()) {
            OrderMate.LOG.info("Adding in 'ask for gratuity' to the SaleToAcquirerData");
            adyenReq.getSaleToPOIRequest().getPaymentRequest().getSaleData().setSaleToAcquirerData(AdyenUtils.addSaleToAcquirerData(adyenReq.getSaleToPOIRequest().getPaymentRequest().getSaleData(), "&tenderOption=AskGratuity"));
        }
        if ((resp = (r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()))).getSaleToPOIResponse()) == null || resp.getPaymentResponse() == null) {
            return this.generateError(request);
        }
        if (this.checkError(resp.getPaymentResponse())) {
            return this.generateError(request, resp.getPaymentResponse().getResponse().getErrorCondition());
        }
        request.getTransaction().setTransactionReference(resp.getPaymentResponse().getPOIData().getPoiTransactionID().getTransactionID());
        Price totalAmount = this.calculateAmount(resp);
        Price surchargeAmount = totalAmount.subtract(AdyenUtils.calculateTxnAmount(request.getTransaction()));
        if (surchargeAmount != null && !surchargeAmount.equals(Price.ZERO_DOLLAR)) {
            for (int i = 0; i < resp.getPaymentResponse().getPaymentReceipt().length; ++i) {
                resp.getPaymentResponse().getPaymentReceipt()[i] = AdyenUtils.addReceiptData(resp.getPaymentResponse().getPaymentReceipt()[i], "Surcharge Incl.", surchargeAmount.toString(true), "TOTAL");
            }
        }
        if (this.vEft.isPrintReceipts()) {
            this.tryPrintDocket(resp.getPaymentResponse(), request);
        }
        request.getTransaction().setNote(AdyenUtils.createCardNoteString(resp.getPaymentResponse(), true));
        this.deleteTransactionID();
        return new AdyenEftposResult(request, EftposStatus.APPROVED, AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(resp, "cardType")), totalAmount, new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getTipAmountSafe(), 0.01), surchargeAmount, new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getCashBackAmountSafe(), 0.01), null, null, loyaltyObj);
    }

    private Price calculateAmount(AdyenSaleToPOIResponse resp) {
        Price temp = new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getAuthorizedAmount(), 0.01);
        temp = temp.subtract(new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getTipAmountSafe(), 0.01));
        temp = temp.subtract(new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getCashBackAmountSafe(), 0.01));
        return temp;
    }

    private void startUI() {
        this.ui.displayBlockingInterface();
        this.ui.setHeaderText("Oolio Payment Request In Progress");
        this.ui.setMessage("Follow Prompts On Pinpad", IntegratedPaymentUI.FeedbackStatus.INFO);
        this.ui.setCancelEnabled(true);
    }

    private void startPreAuthUI() {
        this.ui.displayBlockingInterface();
        this.ui.setHeaderText("Oolio Preauth Request In Progress, Please Wait");
        this.ui.setMessage("Oolio Preauth Request In Progress, Please Wait", IntegratedPaymentUI.FeedbackStatus.INFO);
        this.ui.setCancelEnabled(false);
    }

    public void deleteLoyalty(EftposRequest request) {
        try {
            AdyenLoyalty obj = PersistenceManager.getObject(AdyenLoyalty.class, Query.select(AdyenLoyalty.class).equals(AdyenLoyalty.Properties.TRANSACTION, request.getTransaction().getID()).toString());
            if (obj != null) {
                obj.deleteChild();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem deleting loyalty object", (Throwable)ex);
        }
    }

    public EftposResult doReversal(EftposRequest request) {
        this.refreshTransactionID();
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "Reversal");
        AdyenMessage adyenReq = new AdyenMessage();
        if (request.getReversalAmount() != null) {
            adyenReq.setSaleToPOIRequest(AdyenUtils.createPartialReferencedPOIRequest(header, request.getTransaction().getTransactionReference(), request.getReversalAmount()));
        } else {
            adyenReq.setSaleToPOIRequest(AdyenUtils.createReferencedPOIRequest(header, request.getTransaction().getTransactionReference()));
        }
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
        AdyenSaleToPOIResponse resp = r.getSaleToPOIResponse();
        if (resp == null || resp.getReversalResponse() == null) {
            return this.generateError(request);
        }
        if (this.checkError(resp.getReversalResponse())) {
            return this.generateError(request, resp.getReversalResponse().getResponse().getErrorCondition());
        }
        if (this.vEft.isPrintReceipts()) {
            this.tryPrintDocket(resp.getReversalResponse(), request);
        }
        String ref = null;
        if (resp.getReversalResponse().getPOIData() != null) {
            ref = resp.getReversalResponse().getPOIData().getPoiTransactionID().getTransactionID();
            request.getTransaction().setRefundTxnRef(ref);
        }
        this.deleteLoyalty(request);
        if (!request.getTransaction().isPersistent()) {
            request.getTransaction().saveChild();
        }
        EventContext context = new EventContext(request.getTransaction().getTerminal(), request.getTransaction().getUser());
        Account account = request.getTransaction().getAccount();
        EftposTransaction newTxn = request.getTransaction().copyTransaction();
        newTxn.setReversedTransactionId(request.getTransaction().getID());
        if (request.getTransaction().getAccount() != null) {
            newTxn.applyAccount(account);
        }
        FinanceUnit oldUnitType = request.getTransaction().getSubType();
        request.setEftposTransaction(newTxn);
        request.setReversal(false);
        EftposResult result = null;
        Price refundAmount = null;
        if (request.getReversalAmount() != null) {
            newTxn.setNote(PARTIAL_NOTE);
            refundAmount = new Price(request.getReversalAmount(), 0.01);
            result = new EftposResult(request, resp.getReversalResponse().getResponse().getResult().equals("Success") ? EftposStatus.APPROVED : EftposStatus.ERROR, AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(resp, "cardType"), oldUnitType), refundAmount.negate(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, resp.getReversalResponse().getResponse().getResult().equals("Success") ? null : resp.getReversalResponse().getResponse().getErrorCondition());
        } else {
            newTxn.setNote(FULLY_REFUND);
            if (resp.getReversalResponse().getResponse().getResult().equals("Success")) {
                this.ui.setMessage("Refund Processed Successfully", IntegratedPaymentUI.FeedbackStatus.INFO);
            } else {
                this.ui.setMessage("Error processing refund: " + resp.getReversalResponse().getResponse().getErrorCondition(), IntegratedPaymentUI.FeedbackStatus.WARNING);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deleteTransactionID();
            refundAmount = request.getTransaction().getPaid();
            result = new EftposResult(request, resp.getReversalResponse().getResponse().getResult().equals("Success") ? EftposStatus.APPROVED : EftposStatus.ERROR, AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(resp, "cardType"), oldUnitType), refundAmount.negate(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, resp.getReversalResponse().getResponse().getResult().equals("Success") ? null : resp.getReversalResponse().getResponse().getErrorCondition());
        }
        TerminalEventLog.logPaymentRefuned(context, newTxn, account, refundAmount);
        return result;
    }

    public EftposResult doRefund(EftposRequest request) {
        this.refreshTransactionID();
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "Payment");
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createUnreferencedPOIRequest(header, posRefId, request.getTransaction().getPaid().negate()));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
        AdyenSaleToPOIResponse resp = r.getSaleToPOIResponse();
        if (resp == null || resp.getPaymentResponse() == null) {
            return this.generateError(request);
        }
        if (this.checkError(resp.getPaymentResponse())) {
            return this.generateError(request, resp.getPaymentResponse().getResponse().getErrorCondition());
        }
        if (this.vEft.isPrintReceipts()) {
            this.tryPrintDocket(resp.getPaymentResponse(), request);
        }
        if (resp.getPaymentResponse().getPOIData() != null) {
            request.getTransaction().setTransactionReference(resp.getPaymentResponse().getPOIData().getPoiTransactionID().getTransactionID());
        }
        this.deleteTransactionID();
        return new EftposResult(request, resp.getPaymentResponse().getResponse().getResult().equals("Success") ? EftposStatus.APPROVED : EftposStatus.ERROR, AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(resp, "cardType")), new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getAuthorizedAmount(), 0.01).negate(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, resp.getPaymentResponse().getResponse().getResult().equals("Success") ? null : resp.getPaymentResponse().getResponse().getErrorCondition());
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        try {
            if (request.isReversal()) {
                return this.doReversal(request);
            }
            if (Price.ZERO_DOLLAR.greaterThan(request.getTransaction().getPaid())) {
                this.startUI();
                return this.doRefund(request);
            }
            this.startUI();
            return this.doPayment(request);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage());
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "Unknown error occured with Adyen, check logs for details");
        }
    }

    public void gotCancel() {
        boolean cancelSent = this.doCancelRequest();
        if (cancelSent) {
            this.closeOff();
        } else {
            OrderMate.LOG.info("Oolio could not recieve the cancel response");
        }
    }

    private boolean doCancelRequest() {
        AdyenMessageHeader header = this.createHeader(this.createTransactionId(), "Abort");
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createAbortPOIRequest(header, this.vEft.getLastTxnReference(), AdyenIntegrationProcessor.getLastRequestType()));
        return AdyenIntegrationProcessor.getInstance().doTransactionNoReturn(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
    }

    private void tryPrintDocket(AdyenPaymentResponse resp, EftposRequest request) {
        try {
            EftposTransaction txn = null;
            if (request != null) {
                txn = request.getTransaction();
            }
            for (AdyenPaymentReceipt receipt : resp.getPaymentReceipt()) {
                DocketProcessor.printEftposDocket(AdyenUtils.getReceiptData(receipt), Terminal.getLocalHost().getAvailableReceiptPrinters(), txn, false);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
        }
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        if (PreauthType.ALLOCATION.equals((Object)request.getTxn().getType())) {
            return this.performPreauthOpen(request);
        }
        this.startPreAuthUI();
        return this.performPreauthTxn(request);
    }

    public String getEndpointFromPreauthType(PreauthType t) {
        if (t.equals((Object)PreauthType.TOPUP)) {
            return "amountUpdates";
        }
        if (t.equals((Object)PreauthType.CONSUMPTION)) {
            return "captures";
        }
        if (t.equals((Object)PreauthType.VOID)) {
            return "cancels";
        }
        return "";
    }

    public PreauthResult performPreauthTopup(PreauthRequest request) {
        AdyenPreauthMessage adyenReq = new AdyenPreauthMessage();
        AdyenPreauthAdditionalData d = new AdyenPreauthAdditionalData();
        d.setAdjustAuthorisationData(request.getTxn().getReferredTxn().getAdditionalData());
        adyenReq.setAdditionalData(d);
        adyenReq.setMerchantAccount(this.vEft.getMerchantId());
        AdyenPreauthAmount m = new AdyenPreauthAmount();
        m.setCurrency(AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel());
        Price amount = Price.ZERO_DOLLAR;
        if (request.getItemGroup() instanceof BarTabAccount) {
            amount = ((BarTabAccount)request.getItemGroup()).getCreditLimit().add(request.getTxn().getAmount());
        } else {
            Long ID = request.getItemGroup().getAccount().getID();
            List<PreauthTransaction> pTxns = PersistenceManager.getObjectList(PreauthTransaction.class, Query.select(PreauthTransaction.class).active(PreauthTransaction.class).equals(PreauthTransaction.Properties.ACCOUNT, ID).toString());
            for (PreauthTransaction p : pTxns) {
                amount = amount.add(p.getAmount());
            }
            amount = amount.add(request.getTxn().getAmount());
        }
        m.setValue(amount.getNumCents());
        adyenReq.setModificationAmount(m);
        this.refreshTransactionID();
        String posRefId = this.vEft.getLastTxnReference();
        adyenReq.setReference(posRefId);
        adyenReq.setOriginalReference(request.getTxn().getReferredTxn().getCompletionRef());
        AdyenPreauthMessage r = AdyenIntegrationProcessor.getInstance().doPreAuthTopUp(adyenReq, AdyenUtils.getAdyenPaymentIP(this.vEft.isTesting(), AdyenIntegrationConfig.getInstance().getCheckoutPrefix()));
        if (r == null || r.getResponse() == null) {
            return new PreauthResult(request, EftposStatus.ERROR, "Unexpected Error Occurred In Preauth, Check Logs", AdyenUtils.getCardTypeFromBrand(request.getTxn().getCardType()));
        }
        boolean auth = r.getResponse().equals("Authorised");
        if (auth) {
            request.getTxn().getReferredTxn().setAdditionalData(r.getAdditionalData().getAdjustAuthorisationData());
        }
        return new PreauthResult(request, auth ? EftposStatus.APPROVED : EftposStatus.DECLINED, auth ? null : r.getResponse(), AdyenUtils.getCardTypeFromBrand(request.getTxn().getCardType()));
    }

    public PreauthResult performPreauthTxn(PreauthRequest request) {
        if (PreauthType.TOPUP.equals((Object)request.getTxn().getType())) {
            return this.performPreauthTopup(request);
        }
        this.refreshTransactionID();
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "Payment");
        AdyenPreauthMessage adyenReq = AdyenUtils.createRequest(request.getTxn().getAmount().getNumCents(), this.vEft.getMerchantId(), posRefId, request.getTxn().getReason());
        AdyenNotificationRequest r = AdyenIntegrationProcessor.getInstance().doPreAuthTransaction(adyenReq, request.getTxn().getReferredTxn().getCompletionRef(), this.getEndpointFromPreauthType(request.getTxn().getType()), AdyenUtils.getAdyenCheckoutIP(this.vEft.isTesting(), AdyenIntegrationConfig.getInstance().getCheckoutPrefix()));
        if (r == null) {
            return new PreauthResult(request, EftposStatus.ERROR, "Unexpected Error Occurred In Preauth, Check Logs", AdyenUtils.getCardTypeFromBrand(request.getTxn().getCardType()));
        }
        AdyenNotificationRequestItem result = r.getFirstRequest().getNotificationRequestItem();
        return new PreauthResult(request, result.getSuccess().equals("true") ? EftposStatus.APPROVED : EftposStatus.ERROR, result.getSuccess().equals("true") ? null : result.getReason(), AdyenUtils.getCardTypeFromBrand(request.getTxn().getCardType()));
    }

    public PreauthResult performPreauthOpen(PreauthRequest request) {
        this.refreshTransactionID();
        String posRefId = this.vEft.getLastTxnReference();
        AdyenMessageHeader header = this.createHeader(posRefId, "Payment");
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createPreAuthPOIRequest(header, posRefId, request.getTxn().getAmount()));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doPreAuthOpen(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
        AdyenSaleToPOIResponse resp = r.getSaleToPOIResponse();
        request.getTxn().setCompletionRef(AdyenUtils.getDataProperty(resp, "pspReference"));
        String encoded = AdyenUtils.getDataProperty(resp, "adjustAuthorisationData");
        request.getTxn().setAdditionalData(AdyenUtils.decodeUrl(encoded));
        return new PreauthResult(request, resp.getPaymentResponse().getResponse().getResult().equals("Success") ? EftposStatus.APPROVED : EftposStatus.ERROR, resp.getPaymentResponse().getResponse().getResult().equals("Success") ? null : "Error", AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(resp, "cardType")));
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    public boolean getCommunicationOK() {
        AdyenMessageHeader header = AdyenUtils.createHeader("3.0", "Service", "Diagnosis", "Request", this.vEft.getMerchantId(), this.vEft.getTerminalId());
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createDiagnosisPOIRequest(header));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
        if (r == null || r.getSaleToPOIResponse().getDiagnosisResponse() == null) {
            return false;
        }
        return r.getSaleToPOIResponse().getDiagnosisResponse().getPoiStatus().isCommunicationOKFlag();
    }

    @Override
    public String getTerminalIDIfReady() {
        return this.vEft.getTerminalId();
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public boolean supportsBlocking() {
        return false;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printInterruptedTransaction(String txnReference) {
        if (!ExperimentalFeatureHelper.isWMAydenPrintInterruptedTrans()) {
            return;
        }
        try {
            if (this.vEft.getLastTxnReference() != null) {
                AdyenMessageHeader header = this.createHeader(this.createTransactionId(), "TransactionStatus");
                AdyenMessage adyenReq = new AdyenMessage();
                adyenReq.setSaleToPOIRequest(AdyenUtils.createTxnStatusPOIRequest(header));
                AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(this.vEft.isTesting()));
                if (r != null) {
                    AdyenSaleToPOIResponse res = r.getSaleToPOIResponse().getTransactionStatusResponse().getRepeatedMessageResponse().getRepeatedResponseMessageBody();
                    if (res.getPaymentResponse() != null) {
                        this.tryPrintDocket(res.getPaymentResponse(), null);
                    } else if (res.getReversalResponse() != null) {
                        this.tryPrintDocket(res.getReversalResponse(), null);
                    }
                }
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Error Printing Interrupted Transaction", (Object)ex.getMessage());
        }
        finally {
            this.vEft.setLastTxnReference(null);
            this.vEft.save();
        }
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return true;
    }

    @Override
    public List<String> supportedPreAuth() {
        return Arrays.asList("Settle", "Void", "Topup");
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
        if (result instanceof AdyenEftposResult) {
            try {
                AdyenLoyalty loyalty = ((AdyenEftposResult)result).getAdyenLoyalty();
                if (loyalty != null) {
                    loyalty.setTransaction(result.getRequest().getTransaction());
                    if ((Account)result.getRequest().getPayable() != null) {
                        loyalty.setCustomer(((Account)result.getRequest().getPayable()).getCustomer());
                    }
                    loyalty.saveChild();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Oolio loyalty failed to save", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean supportsMOTO() {
        return true;
    }
}

