/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.adyen;

public enum AdyenError {
    ABORTED("Aborted", "Transaction Aborted", null),
    BUSY("Busy", "Transaction Failed", "Error - Busy"),
    CANCEL("Cancel", "Transaction Cancelled", null),
    COMMUNICATION_TIMEOUT("Communication timeout", "Transaction Failed", "Error - Timed out"),
    DEVICE_OUT("DeviceOut", "Transaction Failed", "Error - Device Out"),
    INSERTED_CARD("InsertedCard", "Transaction Failed", "Error - Inserted Card"),
    IN_PROGRESS("InProgress", "Transaction Failed", "Error - In Progress"),
    LOGGED_OUT("LoggedOut", "Transaction Failed", "Error - Logged Out"),
    MESSAGE_FORMAT("MessageFormat", "Transaction Failed", "Error - Message Format"),
    NOT_ALLOWED("NotAllowed", "Transaction Failed", "Error - Not Allowed"),
    NOT_FOUND("NotFound", "Transaction Failed", "Error - Not Found"),
    PAYMENT_RESTRICTION("PaymentRestriction", "Transaction Failed", "Payment Restriction"),
    REFUSAL("Refusal", "Transaction Failed", "Refusal"),
    UNAVAILABLE_DEVICE("UnavailableDevice", "Transaction Failed", "Error - Unavailable Device"),
    UNAVAILABLE_SERVICE("UnavailableService", "Transaction Failed", "Error - Unavailable Service"),
    INVALID_CARD("InvalidCard", "Transaction Failed", "Invalid Card"),
    UNREACHABLE_HOST("UnreachableHost", "Transaction Failed", "Error - Unreachable Host"),
    WRONG_PIN("WrongPIN", "Transaction Failed", "Wrong PIN");

    private String error;
    private String display;
    private String title;

    public static String getDisplayValue(String err) {
        for (AdyenError e : AdyenError.values()) {
            if (!e.error.equals(err)) continue;
            if (e.display == null) {
                return e.title;
            }
            return e.display;
        }
        return "Error with response from Oolio, check terminal settings are correct";
    }

    public static String getTitleValue(String err) {
        for (AdyenError e : AdyenError.values()) {
            if (!e.error.equals(err)) continue;
            return e.title;
        }
        return "Transaction Failed - Error - XXXXXXXX";
    }

    private AdyenError(String error, String title, String display) {
        this.error = error;
        this.display = display;
        this.title = title;
    }
}

