/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.adyen;

import au.com.ordermate.xmlintegration.adyen.AdyenMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenNotificationRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalSettingsMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenTerminalsMessage;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.webresource.WebResourceUser;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.eftpos.adyen.AdyenMarshaller;
import ordermate.integration.eftpos.adyen.AdyenPreauthMarshaller;
import ordermate.integration.greenback.GreenBackIntegration;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.json.JSONObject;

public class AdyenIntegrationProcessor {
    private static final Integer TIMEOUT = 150000;
    private static final String PREAUTH_ENDPOINT = "/preauth/v2/adyen";
    private static final String PREAUTH_OPEN = "/open";
    private static final String PREAUTH_TOPUP = "/topup";
    private static final String PREAUTH_TXN = "/txn/";
    private static final String FETCH_USER = "/fetch_user";
    private static AdyenIntegrationProcessor instance;
    private static String lastRequestType;

    public static AdyenIntegrationProcessor getInstance() {
        if (instance == null) {
            instance = new AdyenIntegrationProcessor();
        }
        return instance;
    }

    public static void setInstance(AdyenIntegrationProcessor newInstance) {
        instance = newInstance;
    }

    private static WebResource.Builder createBuilder(String uri) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        return (WebResource.Builder)((WebResource.Builder)resource.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).header("x-api-key", (Object)AdyenIntegrationConfig.getInstance().getApiCredential());
    }

    private static WebResource.Builder createBuilderWithParam(String uri, Map<String, String> parameterMap) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        for (String key : parameterMap.keySet()) {
            resource = rest.addParameter(resource, key, parameterMap.get(key));
        }
        return (WebResource.Builder)((WebResource.Builder)resource.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).header("x-api-key", (Object)AdyenIntegrationConfig.getInstance().getApiCredential());
    }

    private static WebResource.Builder createTopUpBuilder(String uri) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        return resource.header("x-api-key", (Object)AdyenIntegrationConfig.getInstance().getApiCredential());
    }

    public AdyenMessage doTransaction(AdyenMessage req, String endpoint) {
        try {
            lastRequestType = req.getSaleToPOIRequest().getMessageHeader().getMessageCategory();
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilder(endpoint);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + r);
            return new AdyenMarshaller().unmarshal(r, AdyenMessage.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public AdyenNotificationRequest doPreAuthTransaction(AdyenPreauthMessage req, String PSP, String preAuthCall, String URL2) {
        try {
            CloudBackConfig cbCfg = GreenBackIntegration.getGreenBackConfig();
            String endpoint = cbCfg.getWebConfig().getUrl() + PREAUTH_ENDPOINT + PREAUTH_TXN + PSP + "/" + preAuthCall;
            WebResource.Builder builder = (WebResource.Builder)AdyenIntegrationProcessor.createBuilder(endpoint).header("x-contact-url", (Object)URL2);
            OrderMate.LOG.info("Sending Oolio Request:\n" + new AdyenMarshaller().marshal(req));
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
                OrderMate.LOG.info("Recieved Oolio Response:\n" + (String)response.getEntity(String.class));
                return null;
            }
            AdyenNotificationRequest r = (AdyenNotificationRequest)response.getEntity(AdyenNotificationRequest.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + new AdyenMarshaller().marshal(r));
            return r;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public AdyenMessage doPreAuthOpen(AdyenMessage req, String URL2) {
        try {
            CloudBackConfig cbCfg = GreenBackIntegration.getGreenBackConfig();
            String endpoint = cbCfg.getWebConfig().getUrl() + PREAUTH_ENDPOINT + PREAUTH_OPEN;
            WebResource.Builder builder = (WebResource.Builder)AdyenIntegrationProcessor.createBuilder(endpoint).header("x-contact-url", (Object)URL2);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + r);
            return new AdyenMarshaller().unmarshal(r, AdyenMessage.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public AdyenPreauthMessage doPreAuthTopUp(AdyenPreauthMessage req, String URL2) {
        try {
            CloudBackConfig cbCfg = GreenBackIntegration.getGreenBackConfig();
            String endpoint = cbCfg.getWebConfig().getUrl() + PREAUTH_ENDPOINT + PREAUTH_TOPUP;
            WebResource.Builder builder = (WebResource.Builder)AdyenIntegrationProcessor.createBuilder(endpoint).header("x-contact-url", (Object)(URL2 + "/adjustAuthorisation"));
            String entity = new AdyenPreauthMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + entity);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)entity);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
                OrderMate.LOG.info("Recieved Oolio Response:\n" + (String)response.getEntity(String.class));
                return null;
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + r);
            return new AdyenPreauthMarshaller().unmarshal(r, AdyenPreauthMessage.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public boolean doTransactionNoReturn(AdyenMessage req, String endpoint) {
        try {
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilder(endpoint);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return false;
        }
    }

    public AdyenTerminalSettingsMessage getTerminalSettings(String endpoint) {
        try {
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilder(endpoint);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            AdyenTerminalSettingsMessage r = (AdyenTerminalSettingsMessage)response.getEntity(AdyenTerminalSettingsMessage.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + new AdyenMarshaller().marshal(r));
            return r;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public AdyenTerminalsMessage getAllTerminals(String endpoint) {
        try {
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilder(endpoint);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            AdyenTerminalsMessage r = (AdyenTerminalsMessage)response.getEntity(AdyenTerminalsMessage.class);
            OrderMate.LOG.info("Recieved Oolio Response:\n" + new AdyenMarshaller().marshal(r));
            return r;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    private static void allowMethods(String ... methods) {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.addAll(Arrays.asList(methods));
            String[] newMethods = methodsSet.toArray(new String[0]);
            methodsField.set(null, newMethods);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean patchTerminalSettings(AdyenTerminalSettingsMessage req, String endpoint) {
        try {
            AdyenIntegrationProcessor.allowMethods("PATCH");
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilder(endpoint);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.method("PATCH", ClientResponse.class, (Object)req);
            int status = response.getStatus();
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Receieved Oolio Response:\n" + r);
            if (status / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return false;
        }
    }

    public String getDefaultUserPwdFromGreenBack() {
        try {
            CloudBackConfig cbCfg = GreenBackIntegration.getGreenBackConfig();
            String endpoint = cbCfg.getWebConfig().getUrl() + PREAUTH_ENDPOINT + FETCH_USER;
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
            parameterMap.put("store_id", String.valueOf(redbackId));
            WebResource.Builder builder = AdyenIntegrationProcessor.createBuilderWithParam(endpoint, parameterMap);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("fetch Default User from GreenBack failed :  " + response.getStatus());
                return null;
            }
            String r = (String)response.getEntity(String.class);
            JSONObject json = new JSONObject(r);
            if (json.getString("password").length() <= 8) {
                WebResourceUser.createWebResourceUserForOpay(String.valueOf(json.get("email")), json.getString("password"), redbackId);
            }
            return json.getString("password");
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Generate User in redback Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static String getLastRequestType() {
        return lastRequestType;
    }

    static {
        lastRequestType = "Payment";
    }
}

