/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.adyen;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.adyen.AdyenAbortRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenAmountReq;
import au.com.ordermate.xmlintegration.adyen.AdyenCardAcquisitionRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenCardAcquisitionTransaction;
import au.com.ordermate.xmlintegration.adyen.AdyenDiagnosisRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageHeader;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageReference;
import au.com.ordermate.xmlintegration.adyen.AdyenPOITransaction;
import au.com.ordermate.xmlintegration.adyen.AdyenPOITxnID;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentData;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentReceipt;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentTransaction;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthAmount;
import au.com.ordermate.xmlintegration.adyen.AdyenPreauthMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenReceipt;
import au.com.ordermate.xmlintegration.adyen.AdyenReceiptData;
import au.com.ordermate.xmlintegration.adyen.AdyenReversalRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleData;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleTransactionID;
import au.com.ordermate.xmlintegration.adyen.AdyenTransactionStatusRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;

public class AdyenUtils {
    private static String ADYEN_TERMINAL_TEST_URL = "https://terminal-api-test.adyen.com/sync";
    private static String ADYEN_CHECKOUT_TEST_URL = "https://checkout-test.adyen.com/v68/payments/";
    private static String ADYEN_CHECKOUT_LIVE_URL = "https://[prefix]-checkout-live.adyenpayments.com/checkout/v68/payments/";
    private static String ADYEN_PAYMENT_TEST_URL = "https://pal-test.adyen.com/pal/servlet/Payment/v68";
    private static String ADYEN_PAYMENT_LIVE_URL = "https://[prefix]-pal-live.adyenpayments.com/pal/servlet/Payment/v68";
    private static String ADYEN_PAYMENT_TEST_API_KEY = "AQEshmfxL4jNbBVDw0m/n3Q5qf3VZ4RBBJxtSmpD1tNxMXva5A+xA1wEsrIDCNwQwV1bDb7kfNy1WIxIIkxgBw==-FZR7S2qZSzxFbRxmeLntllUgv6girxZx6lTftqnCSwo=-ChfF3,KJA[43h62u";
    private static String ADYEN_PAYMENT_LIVE_API_KEY = "AQEshmfxLo3IahJCw0m/n3Q5qf3VZ4RBBJxtSmpD1pH4MnXDORMrTDFYLoiEiuIQwV1bDb7kfNy1WIxIIkxgBw==-DAyXVw88qTi4n7GnRKyEP3iYkq59tt5JUwY4fkMd3e0=-;fF3sneUG:A__b2R";
    private static String TIME_FORMAT = "yyy-MM-dd'T'HH:mm:ss";
    public static boolean USE_API_TESTING_CREDENTIALS = false;

    public static String getAdyenTerminalIP(boolean test) {
        return test ? ADYEN_TERMINAL_TEST_URL : AdyenIntegrationConfig.getInstance().getLiveEndpoint();
    }

    public static String getAdyenCheckoutIP(boolean test, String prefix) {
        return test ? ADYEN_CHECKOUT_TEST_URL : ADYEN_CHECKOUT_LIVE_URL.replace("[prefix]", prefix);
    }

    public static String getAdyenPaymentIP(boolean test, String prefix) {
        return test ? ADYEN_PAYMENT_TEST_URL : ADYEN_PAYMENT_LIVE_URL.replace("[prefix]", prefix);
    }

    public static String getAPIKey() {
        return USE_API_TESTING_CREDENTIALS ? ADYEN_PAYMENT_TEST_API_KEY : ADYEN_PAYMENT_LIVE_API_KEY;
    }

    public static void setADYEN_TERMINAL_TEST_URL(String aDYEN_TERMINAL_TEST_URL) {
        ADYEN_TERMINAL_TEST_URL = aDYEN_TERMINAL_TEST_URL;
    }

    public static void setADYEN_CHECKOUT_TEST_URL(String aDYEN_CHECKOUT_TEST_URL) {
        ADYEN_CHECKOUT_TEST_URL = aDYEN_CHECKOUT_TEST_URL;
    }

    public static String createCardNoteString(AdyenPaymentResponse r, boolean maskStart) {
        try {
            String cardData = r.getPaymentResult().getPaymentInstrumentData().getCardData().getMaskedPan();
            if (maskStart) {
                int index = 0;
                while (cardData.charAt(index) != '*') {
                    cardData = cardData.replaceFirst("" + cardData.charAt(index), "*");
                    ++index;
                }
            }
            cardData = cardData.replaceAll(" ", "*");
            int indexStart = 3;
            for (int i = 0; i < cardData.length(); ++i) {
                if (cardData.indexOf(i) == 42 || cardData.indexOf(i) == 32 || i != indexStart) continue;
                cardData = cardData.substring(0, indexStart + 1) + " " + cardData.substring(indexStart + 1);
                indexStart += 5;
            }
            return cardData;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error extracting masked pan", (Throwable)ex);
            return "";
        }
    }

    public static String cleanHTMLCharacters(String s) {
        String toReturn = s.replaceAll("%20", " ");
        toReturn = toReturn.replaceAll("%24", "\\$");
        toReturn = toReturn.replaceAll("%3a", ":");
        toReturn = toReturn.replaceAll("%2a", "*");
        toReturn = toReturn.replaceAll("%2f", "/");
        return toReturn;
    }

    public static String decodeUrl(String encoded) {
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAsReceiptString(AdyenReceipt receipt) {
        String lineData = "";
        try {
            for (AdyenReceiptData obj : receipt.getOutputText()) {
                String[] body;
                String lineName = null;
                String lineValue = null;
                for (String s : body = obj.getText().split("&")) {
                    if (s.split("=")[0].equals("name")) {
                        lineName = AdyenUtils.cleanHTMLCharacters(s.split("=")[1]);
                        continue;
                    }
                    if (!s.split("=")[0].equals("value")) continue;
                    lineValue = AdyenUtils.cleanHTMLCharacters(s.split("=")[1]);
                }
                if (lineName == null) continue;
                lineData = lineData + lineName + (lineValue != null ? ": " + lineValue : "");
                if (!obj.isEndOfLineFlag()) continue;
                lineData = lineData + "\n";
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage());
        }
        return lineData;
    }

    public static AdyenMessageHeader createHeader(String protocolVersion, String messageClass, String messageCategory, String messageType, String saleID, String serviceID, String poiid) {
        AdyenMessageHeader h = new AdyenMessageHeader();
        h.setProtocolVersion(protocolVersion);
        h.setMessageClass(messageClass);
        h.setMessageCategory(messageCategory);
        h.setMessageType(messageType);
        h.setSaleID(saleID);
        h.setServiceID(serviceID);
        h.setPOIID(poiid);
        return h;
    }

    public static AdyenMessageHeader createHeader(String protocolVersion, String messageClass, String messageCategory, String messageType, String saleID, String poiid) {
        AdyenMessageHeader h = new AdyenMessageHeader();
        h.setProtocolVersion(protocolVersion);
        h.setMessageClass(messageClass);
        h.setMessageCategory(messageCategory);
        h.setMessageType(messageType);
        h.setSaleID(saleID);
        h.setPOIID(poiid);
        return h;
    }

    public static String createAdyenTransactionId() {
        Long unixTime = System.currentTimeMillis();
        if (unixTime.toString().length() > 10) {
            return unixTime.toString().substring(unixTime.toString().length() - 10);
        }
        return unixTime.toString();
    }

    public static AdyenPOITxnID createPOITxnID(String t, String Id2) {
        AdyenPOITxnID poi = new AdyenPOITxnID();
        poi.setTransactionID(Id2);
        poi.setTimeStamp(t);
        return poi;
    }

    public static String getReceiptData(AdyenPaymentReceipt receipt) {
        return AdyenUtils.getAsReceiptString(receipt.getOutputContent());
    }

    public static AdyenPaymentReceipt addReceiptData(AdyenPaymentReceipt receipt, String lineTitle, String lineValue, String placeBefore) {
        AdyenReceipt r = receipt.getOutputContent();
        int location = -1;
        if (!StringUtils.isEmpty(placeBefore)) {
            for (int i = 0; i < r.getOutputText().length; ++i) {
                if (location != -1 || !StringUtils.startsWithIgnoreCase(r.getOutputText()[i].getText(), "name=" + placeBefore)) continue;
                location = i;
            }
        }
        if (location == -1) {
            location = r.getOutputText().length;
        }
        AdyenReceiptData[] receiptText = new AdyenReceiptData[r.getOutputText().length + 1];
        int indexBuffer = 0;
        for (int i = 0; i < r.getOutputText().length; ++i) {
            if (i == location) {
                AdyenReceiptData data = new AdyenReceiptData();
                data.setEndOfLineFlag(true);
                data.setCharacterStyle(receiptText[0].getCharacterStyle());
                data.setText("name=" + lineTitle + "&value=" + lineValue + "&key=custom");
                receiptText[location] = data;
                ++indexBuffer;
            }
            receiptText[i + indexBuffer] = r.getOutputText()[i];
        }
        r.setOutputText(receiptText);
        receipt.setOutputContent(r);
        return receipt;
    }

    public static String getDataPropertyValue(String property, String additionalResponse) {
        String[] properties;
        for (String prop : properties = additionalResponse.split("&")) {
            if (!prop.split("=")[0].equals(property)) continue;
            return prop.split("=")[1];
        }
        return null;
    }

    public static boolean containsDataProperty(String property, String additionalResponse) {
        String[] properties;
        if (additionalResponse == null) {
            return false;
        }
        for (String prop : properties = additionalResponse.split("&")) {
            if (!prop.split("=")[0].equals(property)) continue;
            return true;
        }
        return false;
    }

    public static String getDataProperty(AdyenSaleToPOIResponse r, String property) {
        if (r.getPaymentResponse() != null) {
            return AdyenUtils.getDataPropertyValue(property, r.getPaymentResponse().getResponse().getAdditionalResponse());
        }
        if (r.getReversalResponse() != null) {
            return AdyenUtils.getDataPropertyValue(property, r.getReversalResponse().getResponse().getAdditionalResponse());
        }
        if (r.getCardAcquisitionResponse() != null) {
            return AdyenUtils.getDataPropertyValue(property, r.getCardAcquisitionResponse().getResponse().getAdditionalResponse());
        }
        return "";
    }

    public static AdyenSaleToPOIRequest createPaymentPOIRequest(AdyenMessageHeader header, String txnID, Price amount, Price tipAmt, Price cashAmt) {
        return AdyenUtils.createPaymentPOIRequest(header, txnID, amount, tipAmt, cashAmt, null, null);
    }

    public static AdyenSaleToPOIRequest createMOTOPOIRequest(AdyenMessageHeader header, String txnID, Price amount, Price tipAmt, Price cashAmt) {
        return AdyenUtils.createMOTOPOIRequest(header, txnID, amount, tipAmt, cashAmt, null, null);
    }

    public static String createSaleToAcquirerData() {
        return "applicationInfo.externalPlatform.name=" + BusinessInfo.getInstance().getName() + " - " + BusinessInfo.getInstance().getLocation() + "&applicationInfo.externalPlatform.version=" + OrderMate.VERSION + "&applicationInfo.externalPlatform.integrator=OrderMate&applicationInfo.merchantApplication.name=OrderMate POS&applicationInfo.merchantApplication.version=" + OrderMate.VERSION + "&currency=" + AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel();
    }

    public static String createSaleToAcquirerDataMOTO() {
        return "tenderOption=MOTO&applicationInfo.externalPlatform.name=" + BusinessInfo.getInstance().getName() + " - " + BusinessInfo.getInstance().getLocation() + "&applicationInfo.externalPlatform.version=" + OrderMate.VERSION + "&applicationInfo.externalPlatform.integrator=OrderMate&applicationInfo.merchantApplication.name=OrderMate POS&applicationInfo.merchantApplication.version=" + OrderMate.VERSION + "&currency=" + AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel();
    }

    public static String createSaleToAcquirerDataOnlyCurrency() {
        return "currency=" + AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel();
    }

    public static String createSaleToAcquirerData(String acqData) {
        return acqData + "&applicationInfo.externalPlatform.name=" + BusinessInfo.getInstance().getName() + " - " + BusinessInfo.getInstance().getLocation() + "&applicationInfo.externalPlatform.version=" + OrderMate.VERSION + "&applicationInfo.externalPlatform.integrator=OrderMate&applicationInfo.merchantApplication.name=OrderMate POS&applicationInfo.merchantApplication.version=" + OrderMate.VERSION;
    }

    public static AdyenSaleToPOIRequest createPaymentPOIRequest(AdyenMessageHeader header, String txnID, Price amount, Price tipAmt, Price cashAmt, String cardAcqTimeStamp, String cardAcqID) {
        AdyenPaymentRequest req = new AdyenPaymentRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerData());
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        salesData.setSaleTransactionID(transID);
        AdyenPaymentTransaction pTxn = new AdyenPaymentTransaction();
        AdyenAmountReq aReq = new AdyenAmountReq();
        aReq.setCurrency("AUD");
        aReq.setRequestedAmount(amount.toBigDecimal());
        if (cardAcqTimeStamp != null && cardAcqID != null) {
            AdyenPaymentData data = new AdyenPaymentData();
            data.setCardAcquisitionReference(AdyenUtils.createPOITxnID(cardAcqTimeStamp, cardAcqID));
            data.setSplitPaymentFlag(false);
            req.setPaymentData(data);
        }
        if (!Price.ZERO_DOLLAR.equals(tipAmt) && tipAmt != null) {
            aReq.setTipAmount(tipAmt.toBigDecimal());
        }
        if (!Price.ZERO_DOLLAR.equals(cashAmt) && cashAmt != null) {
            aReq.setCashBackAmount(cashAmt.toBigDecimal());
        }
        pTxn.setAmountsReq(aReq);
        req.setSaleData(salesData);
        req.setPaymentTransaction(pTxn);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createMOTOPOIRequest(AdyenMessageHeader header, String txnID, Price amount, Price tipAmt, Price cashAmt, String cardAcqTimeStamp, String cardAcqID) {
        AdyenPaymentRequest req = new AdyenPaymentRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerDataMOTO());
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        salesData.setSaleTransactionID(transID);
        AdyenPaymentTransaction pTxn = new AdyenPaymentTransaction();
        AdyenAmountReq aReq = new AdyenAmountReq();
        aReq.setCurrency("AUD");
        aReq.setRequestedAmount(amount.toBigDecimal());
        if (cardAcqTimeStamp != null && cardAcqID != null) {
            AdyenPaymentData data = new AdyenPaymentData();
            data.setCardAcquisitionReference(AdyenUtils.createPOITxnID(cardAcqTimeStamp, cardAcqID));
            data.setSplitPaymentFlag(false);
            req.setPaymentData(data);
        }
        if (!Price.ZERO_DOLLAR.equals(tipAmt) && tipAmt != null) {
            aReq.setTipAmount(tipAmt.toBigDecimal());
        }
        if (!Price.ZERO_DOLLAR.equals(cashAmt) && cashAmt != null) {
            aReq.setCashBackAmount(cashAmt.toBigDecimal());
        }
        pTxn.setAmountsReq(aReq);
        req.setSaleData(salesData);
        req.setPaymentTransaction(pTxn);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createPreAuthPOIRequest(AdyenMessageHeader header, String txnID, Price amount) {
        AdyenPaymentRequest req = new AdyenPaymentRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData("authorisationType=PreAuth&manualCapture=true&" + AdyenUtils.createSaleToAcquirerData());
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        salesData.setSaleTransactionID(transID);
        AdyenPaymentTransaction pTxn = new AdyenPaymentTransaction();
        AdyenAmountReq aReq = new AdyenAmountReq();
        aReq.setCurrency("AUD");
        aReq.setRequestedAmount(amount.toBigDecimal());
        pTxn.setAmountsReq(aReq);
        req.setSaleData(salesData);
        req.setPaymentTransaction(pTxn);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createCardAcquisitionRequest(AdyenMessageHeader header, String txnID, Price amount) {
        AdyenCardAcquisitionRequest req = new AdyenCardAcquisitionRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerData());
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        salesData.setSaleTransactionID(transID);
        salesData.setTokenRequestedType("Customer");
        req.setSaleData(salesData);
        AdyenCardAcquisitionTransaction txn = new AdyenCardAcquisitionTransaction();
        txn.setTotalAmount(amount.toBigDecimal());
        req.setCardAcquisitionTransaction(txn);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createUnreferencedPOIRequest(AdyenMessageHeader header, String txnID, Price amount) {
        AdyenPaymentRequest req = new AdyenPaymentRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerData());
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        salesData.setSaleTransactionID(transID);
        AdyenPaymentTransaction pTxn = new AdyenPaymentTransaction();
        AdyenAmountReq aReq = new AdyenAmountReq();
        aReq.setCurrency("AUD");
        aReq.setRequestedAmount(amount.toBigDecimal());
        pTxn.setAmountsReq(aReq);
        AdyenPaymentData data = new AdyenPaymentData();
        data.setPaymentType("Refund");
        req.setSaleData(salesData);
        req.setPaymentTransaction(pTxn);
        req.setPaymentData(data);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createReferencedPOIRequest(AdyenMessageHeader header, String txnID) {
        AdyenReversalRequest req = new AdyenReversalRequest();
        AdyenPOITransaction poiTxn = new AdyenPOITransaction();
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        poiTxn.setPOITransactionID(transID);
        req.setOriginalPOITransaction(poiTxn);
        req.setReversalReason("MerchantCancel");
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createPartialReferencedPOIRequest(AdyenMessageHeader header, String txnID, Price priceToRefund) {
        AdyenReversalRequest req = new AdyenReversalRequest();
        AdyenPOITransaction poiTxn = new AdyenPOITransaction();
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat(TIME_FORMAT).format(new Date()));
        poiTxn.setPOITransactionID(transID);
        req.setOriginalPOITransaction(poiTxn);
        req.setReversalReason("MerchantCancel");
        req.setReversedAmount(priceToRefund.toBigDecimal());
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerData());
        salesData.setSaleTransactionID(transID);
        req.setSaleData(salesData);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createDiagnosisPOIRequest(AdyenMessageHeader header) {
        AdyenDiagnosisRequest req = new AdyenDiagnosisRequest();
        req.setHostDiagnosisFlag(false);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createAbortPOIRequest(AdyenMessageHeader header, String txnID, String msgCategory) {
        AdyenAbortRequest req = new AdyenAbortRequest();
        req.setAbortReason("MerchantAbort");
        AdyenMessageReference messageRef = new AdyenMessageReference();
        messageRef.setServiceID(txnID);
        messageRef.setSaleID(header.getSaleID());
        messageRef.setMessageCategory(msgCategory);
        req.setMessageReference(messageRef);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createTxnStatusPOIRequest(AdyenMessageHeader header) {
        AdyenTransactionStatusRequest req = new AdyenTransactionStatusRequest();
        req.setReceiptReprintFlag(true);
        String[] doc = new String[]{"CashierReceipt", "CustomerReceipt"};
        req.setDocumentQualifier(doc);
        AdyenMessageReference messageRef = new AdyenMessageReference();
        messageRef.setSaleID(header.getSaleID());
        req.setMessageReference(messageRef);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createTxnStatusPOIRequest(AdyenMessageHeader header, String serviceID) {
        AdyenTransactionStatusRequest req = new AdyenTransactionStatusRequest();
        req.setReceiptReprintFlag(true);
        String[] doc = new String[]{"CashierReceipt", "CustomerReceipt"};
        req.setDocumentQualifier(doc);
        AdyenMessageReference messageRef = new AdyenMessageReference();
        messageRef.setSaleID(header.getSaleID());
        messageRef.setServiceID(serviceID);
        req.setMessageReference(messageRef);
        return AdyenUtils.createRequest(header, req);
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenPaymentRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setPaymentRequest(req);
        return aReq;
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenDiagnosisRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setDiagnosisRequest(req);
        return aReq;
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenCardAcquisitionRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setCardAcquisitionRequest(req);
        return aReq;
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenReversalRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setReversalRequest(req);
        return aReq;
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenAbortRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setAbortRequest(req);
        return aReq;
    }

    public static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenTransactionStatusRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setTransactionStatusRequest(req);
        return aReq;
    }

    public static AdyenPreauthMessage createRequest(int amt, String merchantID, String reference, String reason) {
        AdyenPreauthMessage r = new AdyenPreauthMessage();
        if (amt > 0) {
            AdyenPreauthAmount a = new AdyenPreauthAmount(AdyenIntegrationConfig.getInstance().getCurrencyCode().getLabel(), amt);
            r.setAmount(a);
        }
        r.setReason(reason);
        r.setReference(reference);
        r.setMerchantAccount(merchantID);
        return r;
    }

    public static FinanceUnit getCardTypeFromBrand(String brand, FinanceUnit defaultBrand) {
        if (brand == null | StringUtils.isEmpty(brand)) {
            if (defaultBrand == null) {
                return FinanceUnit.getActiveDebitUnits().get(0);
            }
            return defaultBrand;
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Visa") || StringUtils.startsWithIgnoreCase(brand, "Electron")) {
            return FinanceUnit.getUnitForName("Visa");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "mc")) {
            return FinanceUnit.getUnitForName("MasterCard");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Amex")) {
            return FinanceUnit.getUnitForName("Amex");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Alipay")) {
            return FinanceUnit.getUnitForName("Alipay");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Discover")) {
            return FinanceUnit.getUnitForName("Discover");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Doku")) {
            return FinanceUnit.getUnitForName("DOKU");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Dragonpay")) {
            return FinanceUnit.getUnitForName("Dragonpay");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Maestro")) {
            return FinanceUnit.getUnitForName("Maestro");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "MOLPay")) {
            return FinanceUnit.getUnitForName("MOLPay");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "WechatPay")) {
            return FinanceUnit.getUnitForName("WeChat");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Afterpay")) {
            return FinanceUnit.getUnitForName("Afterpay");
        }
        if (StringUtils.startsWithIgnoreCase(brand, "Paypal")) {
            return FinanceUnit.getUnitForName("PayPal");
        }
        return FinanceUnit.getActiveDebitUnits().get(0);
    }

    public static FinanceUnit getCardTypeFromBrand(String brand) {
        return AdyenUtils.getCardTypeFromBrand(brand, null);
    }

    public static Price calculateTxnAmount(EftposTransaction e) {
        return e.getPaid().subtract(e.getSurcharge());
    }

    public static void revalidateSurchargeAmounts(double surAmt) {
        List<FinanceUnit> types = PersistenceManager.getObjectList(FinanceUnit.class, Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.USES_EFTPOS, "1").toString());
        for (FinanceUnit t : types) {
            if (t.getType().equals("MOTO")) continue;
            t.setSurcharge(surAmt);
            t.save();
        }
    }

    public static boolean isTerminalSettingsEditAllowed(User currentUser) {
        PermissionGroup permissionGroup = currentUser.getPermissionGroup();
        if (permissionGroup == null) {
            return false;
        }
        return permissionGroup.hasPermission(AllPermissions.GOD_ONLY);
    }

    public static boolean hasAdyenConfigured() {
        List<VirtualEftpos> types = PersistenceManager.getObjectList(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).toString());
        return !types.isEmpty();
    }

    public static String makePercentageString(Double amount) {
        int digits = amount.toString().length();
        String percentage = String.format("%." + digits + "f", amount * 100.0);
        if ((percentage = percentage.replaceAll("^0+", "")).startsWith(".")) {
            percentage = "0" + percentage;
        }
        if ((percentage = percentage.replaceAll("0+$", "")).endsWith(".")) {
            percentage = percentage + "0";
        }
        return percentage + "%";
    }

    public static String addSaleToAcquirerData(AdyenSaleData d, String s) {
        return d.getSaleToAcquirerData().concat(s);
    }
}

