/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly;

import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.EftposResultBuilder;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionHandler;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionHandlerFactory;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionState;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionStatus;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.internationalization.Internationalization;

public class AssemblyEftpos
implements PhysicalEftpos {
    private final AssemblyEftposContext context;

    public AssemblyEftpos(AssemblyEftposContext context) {
        this.context = context;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        if (!this.context.getEftpos().isAlreadyPaired()) {
            OrderMate.LOG.error("AssemblyEftpos is not paired.  Please pair using Officemate");
        } else if (!this.context.getAssemblyEftposSpi().isConnected()) {
            OrderMate.LOG.info("Initiating the AssemblyEftposSpi to connect to the device. with credentials");
            if (!this.context.getAssemblyEftposSpi().isInitialized()) {
                this.context.getAssemblyEftposSpi().initialize();
                this.context.getAssemblyEftposSpi().start();
            }
        } else {
            OrderMate.LOG.info("Assembly Eftpos is already connected");
        }
    }

    private String getStringFor(String key) {
        return Internationalization.getLiteralFor(key);
    }

    @Override
    public void closeOff() {
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        if (request.isTippingAdjustment()) {
            return EftposResult.adjustment(request, EftposStatus.ERROR);
        }
        if (!Price.ZERO_DOLLAR.equals(request.getTransaction().getCashOut()) && !Price.ZERO_DOLLAR.equals(request.getTransaction().getTip())) {
            this.context.getToolkit().getGuiHandler().displayOkDialog("Invalid Transaction", "Tips with cashout is not supported");
            return new EftposResultBuilder(request).setEftposStatus(EftposStatus.DECLINED).setExplicitError("tips with cashout is not supported.").build();
        }
        AssemblyTransactionStatus status = null;
        boolean canceledUnknown = false;
        do {
            AssemblyTransactionHandler transactionHandler = AssemblyTransactionHandlerFactory.createAssemblyTransactionHandler(this.context, request);
            status = transactionHandler.performTransaction();
            canceledUnknown = transactionHandler.wasCanceledUnknown();
        } while (status == null || AssemblyTransactionState.RETRY.equals((Object)status.getState()));
        EftposResult result = this.createEftposResult(request, status);
        if (canceledUnknown) {
            result.setShowError(false);
        }
        return result;
    }

    private EftposResult createEftposResult(EftposRequest request, AssemblyTransactionStatus status) {
        EftposResult result = null;
        if (status == null) {
            result = EftposResult.adjustment(request, EftposStatus.ERROR);
        } else {
            request.getTransaction().setTransactionReference(status.getRefId());
            switch (status.getState()) {
                case SUCCESS: {
                    result = EftposResult.adjustment(request, status.getEftposStatus());
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
                    result = this.buildResult(result, request, status);
                    break;
                }
                case CANCELLED: {
                    result = EftposResult.adjustment(request, EftposStatus.CANCELLED);
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
                    break;
                }
                case FAILED: {
                    result = EftposResult.adjustment(request, EftposStatus.DECLINED);
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
                    break;
                }
                case ERROR: {
                    result = EftposResult.adjustment(request, EftposStatus.ERROR);
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
                    break;
                }
                case UNKNOWN: {
                    result = EftposResult.adjustment(request, EftposStatus.ERROR);
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
                }
            }
        }
        return result;
    }

    private EftposResult buildResult(EftposResult result, EftposRequest request, AssemblyTransactionStatus status) {
        EftposResultBuilder resultBuilder = new EftposResultBuilder(request);
        resultBuilder.setActualPaid(request.getTransaction().getPaid());
        FinanceUnit unit = request.getTransaction().getSubType();
        OrderMate.LOG.info("Default Finance unit from Transaction " + unit);
        OrderMate.LOG.info("Card Type from Transaction " + status.getCardType());
        if (status.getCardType() != null) {
            FinanceUnit resolvedUnit = FinanceUnit.getUnitForName(status.getCardType());
            OrderMate.LOG.info("Resolving Finance unit from card type : " + resolvedUnit);
            if (resolvedUnit != null) {
                unit = resolvedUnit;
            }
        }
        if (unit == null) {
            unit = FinanceUnit.getDefaultUnitFor(FinanceUnit.DEBIT_TYPE);
            OrderMate.LOG.info("Assigning default Finance unit since Finance unit is null : " + unit);
        }
        resultBuilder.setFinanceUnit(unit);
        resultBuilder.setEftposStatus(status.getEftposStatus());
        resultBuilder.setActualTip(status.getTipAmount());
        resultBuilder.setActualCashout(result.getActualCashout());
        resultBuilder.setActualSurcharge(result.getActualSurcharge());
        resultBuilder.setCustomer(result.getCustomer());
        resultBuilder.setTerminalID(result.getTerminalID());
        return resultBuilder.build();
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        if (!this.context.getAssemblyEftposSpi().isConnected() || !this.context.getAssemblyEftposSpi().isReadyForTransaction()) {
            OrderMate.LOG.error("AssemblyEftpos is not ready for transaction");
            return null;
        }
        return this.context.getEftpos().getTerminalId();
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        boolean connected = this.context.getAssemblyEftposSpi().isConnected();
        if (!this.context.getEftpos().isAlreadyPaired()) {
            OrderMate.LOG.error("Eftpos is not paired.  Please pair this EFTPOS from OfficeMate");
            this.context.getToolkit().getGuiHandler().displayOkDialog(this.getStringFor("EFTPOS_UNPAIRED_HEADER"), this.getStringFor("EFTPOS_UNPAIRED_MESSAGE"));
            return false;
        }
        if (!connected) {
            OrderMate.LOG.error("Eftpos is not connected:  Please connect");
            this.context.getToolkit().getGuiHandler().displayOkDialog(this.getStringFor("EFTPOS_DISCONNECTED"), this.getStringFor("EFTPOS_DISCONNECTED_MESSAGE"));
            return false;
        }
        return connected;
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    public final AssemblyEftposContext getContext() {
        return this.context;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

