/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly;

import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpi;
import ordermate.integration.eftpos.manager.EftposToolkit;

public class AssemblyEftposFactory {
    private static AssemblyEftposSpi assemblyEftposSpi = null;
    private static AssemblyEftposContext context;
    private static AssemblyEftpos assemblyEftpos;

    public static void setAssemblyEftposSpi(AssemblyEftposSpi spi) {
        assemblyEftposSpi = spi;
    }

    public static AssemblyEftposSpi createAssemblyEftposSpi(VirtualEftpos eftpos) {
        if (assemblyEftposSpi != null) {
            return assemblyEftposSpi;
        }
        assemblyEftposSpi = new AssemblyEftposSpi(eftpos);
        return assemblyEftposSpi;
    }

    public static AssemblyEftpos getAssemblyEftpos(EftposToolkit toolkit, VirtualEftpos eftpos) {
        if (context == null) {
            context = new AssemblyEftposContext(toolkit, eftpos);
        }
        assemblyEftpos = new AssemblyEftpos(context);
        return assemblyEftpos;
    }

    public static AssemblyEftposContext getContext() {
        return context;
    }

    public static void dropContext() {
        if (context != null && context.getAssemblyEftposSpi().getSpi() != null) {
            try {
                context.getAssemblyEftposSpi().getSpi().dispose();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot dispose of context", (Throwable)ex);
            }
        }
        if (assemblyEftposSpi != null) {
            try {
                if (assemblyEftposSpi.getSpi() != null) {
                    assemblyEftposSpi.getSpi().dispose();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot dispose of assembly spi", (Throwable)ex);
            }
            assemblyEftposSpi = null;
        }
        context = null;
    }
}

