/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.internationalization.Internationalization;

public class AssemblyEftposHelper {
    private VirtualEftpos getAssemblyEftposForCashDrawer(CashDrawer cashDrawer, Terminal terminal) {
        ObjectQuery query;
        List<VirtualEftpos> eftposList = null;
        if (terminal != null && (eftposList = PersistenceManager.getObjectList(VirtualEftpos.class, (query = Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.CASH_DRAWER, cashDrawer).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ASSEMBLY).active(VirtualEftpos.class)).toString(), null)).size() > 0) {
            return eftposList.get(0);
        }
        return null;
    }

    public VirtualEftpos getAssemblyEftposForThisTerminal() {
        List<CashDrawer> drawers = Terminal.getLocalHost().getAvailableLogicallyConnectedCashDrawers();
        VirtualEftpos virtualEftpos = null;
        for (CashDrawer drawer : drawers) {
            OrderMate.LOG.info("getAssemblyEftposForThisTerminal :: " + drawer.getLabel());
            virtualEftpos = this.getAssemblyEftposForCashDrawer(drawer, Terminal.getLocalHostIfAvailable());
            if (virtualEftpos == null) continue;
            break;
        }
        return virtualEftpos;
    }

    public boolean isEnabledForThisTerminal() {
        return this.getAssemblyEftposForThisTerminal() != null;
    }

    private void showErrorMessage(EftposToolkit toolkit, String errorMessage) {
        toolkit.getGuiHandler().displayOkDialog("Error", errorMessage);
    }

    public boolean validate(EftposToolkit toolkit, VirtualEftpos eftpos) {
        String ipAddress = eftpos.getIpAddress();
        if (StringUtils.isEmpty(ipAddress)) {
            this.showErrorMessage(toolkit, Internationalization.getLiteralFor("IPADDRESS_CANT_BE_EMPTY"));
            return false;
        }
        if (StringUtils.isEmpty(eftpos.getLabel())) {
            this.showErrorMessage(toolkit, Internationalization.getLiteralFor("EFTPOS_LABEL_CANT_BE_EMPTY"));
            return false;
        }
        if (IPAddressUtils.hasInvalidHostNameChars(eftpos.getLabel())) {
            this.showErrorMessage(toolkit, Internationalization.getLiteralFor("EFTPOS_LABEL_ALPHA_NUMERIC"));
            return false;
        }
        if (IPAddressUtils.hasInvalidHostNameChars(eftpos.getIpAddress())) {
            this.showErrorMessage(toolkit, Internationalization.getLiteralFor("EFTPOS_IPADDRESS_INVALID_CHARACTERS"));
            return false;
        }
        return true;
    }
}

