/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly;

import au.com.ordermate.util.StringUtils;
import com.assemblypayments.spi.Spi;
import com.assemblypayments.spi.model.InitiateTxResult;
import com.assemblypayments.spi.model.PairingFlowState;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SpiFlow;
import com.assemblypayments.spi.model.SpiStatus;
import com.assemblypayments.spi.model.TransactionFlowState;
import com.assemblypayments.spi.model.TransactionType;
import com.assemblypayments.spi.util.RequestIdHelper;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpiHelper;
import ordermate.integration.eftpos.assembly.AssemblyEvent;
import ordermate.integration.eftpos.assembly.AssemblyEventHandler;
import ordermate.integration.eftpos.assembly.AssemblyEventType;
import ordermate.integration.eftpos.assembly.SpiFactory;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingState;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingStatus;

public class AssemblyEftposSpi {
    private Spi spi;
    private VirtualEftpos eftpos;
    private final AssemblyEftposSpiHelper assemblyEftposSpiHelper;
    private AssemblyEventHandler assemblyEventHandler;
    private boolean initialized = false;

    public AssemblyEftposSpi(VirtualEftpos eftpos) {
        OrderMate.LOG.info("Instantiating an AssemblyEftposSpi");
        this.eftpos = eftpos;
        this.assemblyEftposSpiHelper = new AssemblyEftposSpiHelper(this);
    }

    public AssemblyEftposSpiHelper getAssemblyEftposSpiHelper() {
        return this.assemblyEftposSpiHelper;
    }

    public AssemblyEventHandler getAssemblyEventHandler() {
        return this.assemblyEventHandler;
    }

    public void setAssemblyEventHandler(AssemblyEventHandler assemblyEventHandler) {
        this.assemblyEventHandler = assemblyEventHandler;
    }

    public SpiStatus getSpiStatus() {
        return this.spi.getCurrentStatus();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.spi == null) {
            this.initialized = false;
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String hmacKey = this.eftpos.getHmacKey();
        String encKey = this.eftpos.getEncKey();
        Secrets secrets = null;
        if (!StringUtils.isEmpty(encKey) && !StringUtils.isEmpty(hmacKey)) {
            secrets = new Secrets(encKey, hmacKey);
        }
        try {
            OrderMate.LOG.info("Initializing SPI to POSID " + this.eftpos.getLabel() + " Host : " + this.eftpos.getIpAddress() + " secrets " + (secrets != null));
            this.spi = SpiFactory.createSpi(this.eftpos.getLabel(), this.eftpos.getIpAddress(), secrets);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
        }
        this.initHandlers();
    }

    private void initHandlers() {
        this.spi.setStatusChangedHandler((Spi.EventHandler)new Spi.EventHandler<SpiStatus>(){

            public void onEvent(SpiStatus spiStatus) {
                AssemblyEftposSpi.this.onSpiStatusChanged(spiStatus);
            }
        });
        this.spi.setPairingFlowStateChangedHandler((Spi.EventHandler)new Spi.EventHandler<PairingFlowState>(){

            public void onEvent(PairingFlowState pairingFlowState) {
                AssemblyEftposSpi.this.onPairingFlowStateChanged(pairingFlowState);
            }
        });
        this.spi.setSecretsChangedHandler((Spi.EventHandler)new Spi.EventHandler<Secrets>(){

            public void onEvent(Secrets secrets) {
                AssemblyEftposSpi.this.onSecretsChangedHandler(secrets);
            }
        });
        this.spi.setTxFlowStateChangedHandler((Spi.EventHandler)new Spi.EventHandler<TransactionFlowState>(){

            public void onEvent(TransactionFlowState transactionFlowState) {
                AssemblyEftposSpi.this.onTxFlowStateChangedHandler(transactionFlowState);
            }
        });
    }

    public void start() {
        OrderMate.LOG.info("AssemblyEftposSPI :: start called ");
        this.spi.start();
    }

    public void pair() {
        OrderMate.LOG.info("AssemblyEftposSPI :: pair called ");
        this.spi.pair();
    }

    public void confirmPairing() {
        OrderMate.LOG.info("AssemblyEftposSPI :: confirm Pairing called ");
        this.spi.pairingConfirmCode();
    }

    public void cancelPairing() {
        OrderMate.LOG.info("AssemblyEftposSPI :: cancel Pairing called ");
        this.spi.pairingCancel();
    }

    public void unpair() {
        OrderMate.LOG.info("AssemblyEftposSPI :: UnPair called ");
        this.spi.unpair();
    }

    public boolean startPurchaseTransaction(String posRefId, int purchaseAmount, int cashoutAmount, int tipAmount) {
        OrderMate.LOG.info("AssemblyEftposSpi :: startPurchaseTransaction initiated posRefId " + posRefId + " amount : " + purchaseAmount + " tip Amount : " + tipAmount);
        InitiateTxResult initiateTxResult = null;
        initiateTxResult = purchaseAmount == 0 && cashoutAmount > 0 ? this.spi.initiateCashoutOnlyTx(posRefId, cashoutAmount) : this.spi.initiatePurchaseTx(posRefId, purchaseAmount, tipAmount, cashoutAmount, false);
        if (!initiateTxResult.isInitiated()) {
            OrderMate.LOG.error("Assembly Purchase Transaction not initiated : " + initiateTxResult.getMessage());
        }
        return initiateTxResult.isInitiated();
    }

    public String initiateSettlementTxn() {
        TransactionFlowState state = this.spi.getCurrentTxFlowState();
        if (state != null && TransactionType.SETTLE.equals((Object)state.getType()) && !state.isFinished()) {
            return state.getDisplayMessage();
        }
        InitiateTxResult initiateTxResult = this.spi.initiateSettleTx(RequestIdHelper.id((String)"settle"));
        if (!initiateTxResult.isInitiated()) {
            OrderMate.LOG.error("Assembly Settlement transaction is not initiated : " + initiateTxResult.getMessage());
            return initiateTxResult.getMessage();
        }
        return null;
    }

    public boolean startRefundTransaction(String posRefId, Integer refundAmount) {
        OrderMate.LOG.info("AssemblyEftposSpi :: startRefundTransaction initiated posRefId " + posRefId + " amount : " + refundAmount);
        InitiateTxResult refundTxResult = this.spi.initiateRefundTx(posRefId, refundAmount.intValue());
        if (!refundTxResult.isInitiated()) {
            OrderMate.LOG.error("Assembly Refund Transaction not initiated : " + refundTxResult.getMessage());
        }
        return refundTxResult.isInitiated();
    }

    public void cancelTransaction() {
        OrderMate.LOG.info("AssemblyEftposSpi :: cancelTransaction ");
        this.spi.cancelTransaction();
    }

    public void setOperationComplete() {
        OrderMate.LOG.info("AssemblyEftposSpi :: setOperationComplete called ");
        this.spi.ackFlowEndedAndBackToIdle();
    }

    public SpiFlow getCurrentFlow() {
        return this.spi.getCurrentFlow();
    }

    public void raiseAssemblyEvent(AssemblyEvent assemblyEvent) {
        Secrets newSecrets;
        if (this.assemblyEventHandler != null) {
            this.assemblyEventHandler.onAssemblyEvent(assemblyEvent);
        } else if (AssemblyEventType.SECRETS_EVENT.equals((Object)assemblyEvent.getEventType()) && (newSecrets = (Secrets)assemblyEvent.getEventDetails()) != null && this.assemblyEftposSpiHelper.isSecretsValid(newSecrets)) {
            this.eftpos.setHmacKey(newSecrets.getHmacKey());
            this.eftpos.setEncKey(newSecrets.getEncKey());
            this.eftpos.save();
        }
    }

    private void onTxFlowStateChangedHandler(TransactionFlowState transactionFlowState) {
        AssemblyEvent<TransactionFlowState> transactionEvent = new AssemblyEvent<TransactionFlowState>(AssemblyEventType.TRANSACTION_EVENT, transactionFlowState);
        this.raiseAssemblyEvent(transactionEvent);
    }

    public void onSecretsChangedHandler(Secrets secrets) {
        AssemblyEvent<Secrets> secretsAssemblyEvent = new AssemblyEvent<Secrets>(AssemblyEventType.SECRETS_EVENT, secrets);
        this.raiseAssemblyEvent(secretsAssemblyEvent);
    }

    private void onPairingFlowStateChanged(PairingFlowState pairingFlowState) {
        if (pairingFlowState == null) {
            return;
        }
        AssemblyPairingState assemblyPairingState = this.assemblyEftposSpiHelper.decodePairingState(pairingFlowState);
        AssemblyPairingStatus assemblyPairingStatus = new AssemblyPairingStatus(assemblyPairingState, pairingFlowState);
        AssemblyEvent<AssemblyPairingStatus> pairingAssemblyEvent = new AssemblyEvent<AssemblyPairingStatus>(AssemblyEventType.PAIRING_EVENT, assemblyPairingStatus);
        this.raiseAssemblyEvent(pairingAssemblyEvent);
    }

    private void onSpiStatusChanged(SpiStatus spiStatus) {
        AssemblyEvent<SpiStatus> assemblyEvent = new AssemblyEvent<SpiStatus>(AssemblyEventType.SPI_STATE_CHANGE_EVENT, spiStatus);
        this.raiseAssemblyEvent(assemblyEvent);
    }

    public boolean isConnected() {
        return this.spi != null && this.spi.getCurrentStatus() == SpiStatus.PAIRED_CONNECTED;
    }

    public boolean isReadyForTransaction() {
        OrderMate.LOG.info("isReadyForTransaction :: " + this.spi.getCurrentFlow().name());
        return this.spi.getCurrentFlow().equals((Object)SpiFlow.IDLE);
    }

    public void approveSignature(boolean accept) {
        OrderMate.LOG.info("AssemblyEftposSpi :: approveSignature : invoked with accept " + accept);
        this.spi.acceptSignature(accept);
    }

    public Spi getSpi() {
        return this.spi;
    }

    public VirtualEftpos getEftpos() {
        return this.eftpos;
    }
}

