/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly;

import au.com.ordermate.networkio.ExecuteTaskAsLocalService;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.assemblypayments.spi.model.PairingFlowState;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SpiStatus;
import java.net.InetAddress;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.integration.eftpos.assembly.AssemblyEftposFactory;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpi;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingState;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class AssemblyEftposSpiHelper {
    private final AssemblyEftposSpi spi;

    public AssemblyEftposSpiHelper(AssemblyEftposSpi assemblyEftposSpi) {
        this.spi = assemblyEftposSpi;
    }

    public AssemblyPairingState decodePairingState(PairingFlowState pairingFlowState) {
        AssemblyPairingState assemblyPairingState = null;
        String message = pairingFlowState.getMessage();
        OrderMate.LOG.info("AssemblyPairingState :: decodePairingState : " + message);
        if (message.equals("Connecting...")) {
            assemblyPairingState = AssemblyPairingState.CONNECTING;
        } else if (message.equals("Negotiating pairing...")) {
            assemblyPairingState = AssemblyPairingState.NEGOTIATING_PAIRING;
        } else if (message.equals("Pairing Successful!")) {
            assemblyPairingState = AssemblyPairingState.PAIRING_SUCCESSFUL;
        } else if (message.equals("Pairing Failed")) {
            assemblyPairingState = AssemblyPairingState.PAIRING_FAILED;
        } else if (message.equals("Requesting to pair...")) {
            assemblyPairingState = AssemblyPairingState.PAIRING_REQUEST;
        } else if (message.startsWith("Could not Connect to Pair")) {
            assemblyPairingState = AssemblyPairingState.PAIRING_CONNECTION_FAILED;
        } else if (message.startsWith("Confirm that the following code is showing on the terminal")) {
            assemblyPairingState = AssemblyPairingState.CONFIRM_CODE_ON_TERMINAL;
        } else if (message.equals("Confirm that the following Code is what the EFTPOS showed")) {
            assemblyPairingState = AssemblyPairingState.CONFIRM_CODE_ON_EFTPOS;
        } else if (message.startsWith("Click YES on EFTPOS if code is:")) {
            assemblyPairingState = AssemblyPairingState.CONFIRM_CODE_ON_EFTPOS;
        }
        return assemblyPairingState;
    }

    public boolean isSecretsValid(Secrets secrets) {
        if (secrets == null) {
            OrderMate.LOG.info("AssemblyEftposSpiHelper :: isSecretsValid : false secrets : null ");
            return false;
        }
        if (StringUtils.isEmpty(secrets.getEncKey())) {
            OrderMate.LOG.info("AssemblyEftposSpiHelper :: isSecretsValid : false : enc key is empty ");
            return false;
        }
        if (StringUtils.isEmpty(secrets.getHmacKey())) {
            OrderMate.LOG.info("AssemblyEftposSpiHelper :: isSecretsValid : false : hmac key is empty ");
            return false;
        }
        return true;
    }

    public boolean isSpiStatusConnected(SpiStatus spiStatus) {
        return spiStatus.equals((Object)SpiStatus.PAIRED_CONNECTED);
    }

    public int getAmountAsInt(Price price) {
        return price == null ? 0 : price.getNumCents();
    }

    public void resetRemoteEftpos() {
        AssemblyEftposFactory.dropContext();
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(AssemblyEftposFactory.class.getCanonicalName(), "dropContext");
        this.runOnRemoteWaitermates(exec);
    }

    public void unpairRemoteEftpos() {
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(AssemblyEftposFactory.class.getCanonicalName(), "getContext", "getAssemblyEftposSpi", "unpair");
        this.runOnRemoteWaitermates(exec);
    }

    private void runOnRemoteWaitermates(final CallMethodOnClassExecutable exec) {
        CashDrawer drawer = this.spi.getEftpos().getCashDrawer();
        if (drawer != null) {
            for (final Terminal terminal : drawer.getTerminals()) {
                final Integer port = terminal.getRmiPort();
                if (port == null) continue;
                final InetAddress ipAddress = terminal.getAddress();
                String serviceName = "ExecuteTaskAsLocalService";
                Runnable toRun = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExecuteTaskAsLocalService executeTaskAsLocalService = (ExecuteTaskAsLocalService)SimpleRMI.getObject(ipAddress, "ExecuteTaskAsLocalService", port);
                            executeTaskAsLocalService.executeTask(exec);
                        }
                        catch (Exception ex) {
                            OrderMate.LOG.warn("Cannot call remote SPI for terminal " + terminal.getLabel(), (Throwable)ex);
                        }
                    }
                };
                new Thread(toRun).start();
            }
        }
    }
}

