/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.pairing;

import au.com.ordermate.configuration.Config;
import com.assemblypayments.spi.model.PairingFlowState;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SpiStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpi;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpiHelper;
import ordermate.integration.eftpos.assembly.AssemblyEvent;
import ordermate.integration.eftpos.assembly.AssemblyEventHandler;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingPanel;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingState;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingStatus;
import ordermate.integration.eftpos.assembly.pairing.AssemblyPairingStatusPanel;
import ordermate.internationalization.Internationalization;

public class AssemblyEftposPairingScreen
implements AssemblyEventHandler {
    private final AssemblyEftposContext context;
    private final VirtualEftpos eftpos;
    private AssemblyEftposSpi assemblyEftposSpi;
    private Secrets secrets = null;
    private SpiStatus spiStatus = SpiStatus.UNPAIRED;
    private JPanel guiPanel;
    private AssemblyPairingPanel pairingPanel;
    private AssemblyPairingStatusPanel statusPanel = null;
    private AssemblyPairingState currentStatus;

    public AssemblyEftposPairingScreen(AssemblyEftposContext context) {
        this.context = context;
        this.eftpos = context.getEftpos();
        this.guiPanel = new JPanel(new BorderLayout());
        this.guiPanel.setPreferredSize(new Dimension(600, 250));
        this.guiPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
                AssemblyEftposPairingScreen.this.dropSpi();
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorAdded(AncestorEvent arg0) {
            }
        });
    }

    private String getString(String key) {
        return Internationalization.getLiteralFor(key);
    }

    public void initialize() {
        try {
            this.statusPanel = new AssemblyPairingStatusPanel();
            this.statusPanel.pair.connect(this, "gotPair");
            this.statusPanel.initGUI(this.eftpos);
            this.guiPanel.add((Component)this.statusPanel, "Center");
            this.context.getToolkit().getGuiHandler().displayBlockingDialog(this.guiPanel);
            this.start();
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            this.showErrorMessage(ex);
        }
    }

    private void createSpi() {
        this.dropSpi();
        this.assemblyEftposSpi = this.context.getAssemblyEftposSpi();
        this.assemblyEftposSpi.setAssemblyEventHandler(this);
        this.assemblyEftposSpi.initialize();
    }

    private void dropSpi() {
        if (this.assemblyEftposSpi != null) {
            OrderMate.LOG.info("Dropping SPI");
            try {
                if (this.assemblyEftposSpi.getSpi() != null) {
                    this.assemblyEftposSpi.getSpi().dispose();
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Error while disposing Spi", (Throwable)ex);
            }
        }
        this.assemblyEftposSpi = null;
    }

    private void showErrorMessage(Exception ex) {
        this.context.getToolkit().getGuiHandler().displayOkDialog("Initialization Error", ex.getMessage());
    }

    void gotPair() {
        this.guiPanel.removeAll();
        this.pairingPanel = new AssemblyPairingPanel();
        this.pairingPanel.yesSignal.connect(this, "gotYes");
        this.pairingPanel.noSignal.connect(this, "gotNo");
        this.pairingPanel.cancelSignal.connect(this, "gotCancel");
        this.guiPanel.add((Component)this.pairingPanel, "Center");
        if (this.eftpos.isAlreadyPaired()) {
            this.unpair();
        } else {
            this.startPairing();
        }
    }

    public void start() {
        this.createSpi();
        this.guiPanel.removeAll();
        this.guiPanel.add("Center", this.statusPanel);
        this.statusPanel.initGUI(this.eftpos);
        this.updateUI();
        this.assemblyEftposSpi.start();
    }

    private void startPairing() {
        OrderMate.LOG.info("Start Pairing . . .");
        this.assemblyEftposSpi.pair();
    }

    private void confirmPairing() {
        OrderMate.LOG.info("Confirm pairing . . .");
        this.assemblyEftposSpi.confirmPairing();
    }

    private void cancelPairing() {
        OrderMate.LOG.info("Cancel pairing with Assembly: " + this.eftpos.getLabel());
        this.currentStatus = AssemblyPairingState.PAIRING_CANCELLED;
        this.assemblyEftposSpi.cancelPairing();
        this.context.getToolkit().getGuiHandler().displayOkDialog("Pairing Failed", "Pairing was cancelled by the user");
        this.updateUI();
        this.start();
    }

    private void unpair() {
        if (!this.context.getToolkit().getGuiHandler().displayForcedChoiceDialog("Confirm Unpair", "Are you sure you wish to unpair this terminal?", "Yes", "No")) {
            return;
        }
        OrderMate.LOG.info("UnPairing Assembly Eftpos: " + this.eftpos.getLabel());
        AssemblyEftposSpiHelper helper = new AssemblyEftposSpiHelper(this.assemblyEftposSpi);
        if (this.assemblyEftposSpi.isConnected()) {
            this.assemblyEftposSpi.unpair();
            this.currentStatus = AssemblyPairingState.UNPAIRING;
            this.statusPanel.setStatus(this.currentStatus.name());
            this.updateUI();
        } else {
            helper.unpairRemoteEftpos();
            this.unpairedComplete();
        }
        helper.resetRemoteEftpos();
    }

    private void unpairedComplete() {
        this.statusPanel.setStatus(this.getString("UNPAIRED"));
        this.updateUI();
        this.context.getToolkit().getGuiHandler().displayOkDialog("Unpairing Successful", "Should the EFTPOS terminal remain paired, press Enter + 3 on the EFTPOS terminal to complete unpairing process.");
        this.eftpos.setHmacKey(null);
        this.eftpos.setEncKey(null);
        this.eftpos.save();
        this.context.getToolkit().getGuiHandler().closeBlockingDialog(this.guiPanel);
    }

    @Override
    public void onAssemblyEvent(AssemblyEvent assemblyEvent) {
        switch (assemblyEvent.getEventType()) {
            case PAIRING_EVENT: {
                this.handlePairingStatusChanged((AssemblyPairingStatus)assemblyEvent.getEventDetails());
                break;
            }
            case SECRETS_EVENT: {
                this.handleSecretsChanged((Secrets)assemblyEvent.getEventDetails());
                break;
            }
            case SPI_STATE_CHANGE_EVENT: {
                this.handleSpiStateChanged((SpiStatus)assemblyEvent.getEventDetails());
            }
        }
    }

    protected void handleSpiStateChanged(SpiStatus newStatus) {
        OrderMate.LOG.info("handleSpiStateChanged :: " + newStatus.toString());
        this.spiStatus = newStatus;
        switch (newStatus) {
            case UNPAIRED: {
                this.unpairedComplete();
                break;
            }
            case PAIRED_CONNECTED: {
                this.statusPanel.setStatus(this.getString("PAIRED_AND_CONNECTED"));
                this.statusPanel.setPairButtonText("UNPAIR");
                this.assemblyEftposSpi.setOperationComplete();
                if (this.secrets == null) break;
                this.saveSecrets();
                break;
            }
            case PAIRED_CONNECTING: {
                if (!this.eftpos.isAlreadyPaired()) break;
                this.statusPanel.setStatus(this.getString("PAIRED_TRYING_TO_CONNECT"));
            }
        }
    }

    protected void handleSecretsChanged(Secrets newSecrets) {
        if (newSecrets != null) {
            OrderMate.LOG.info("handleSecretsChanged :: received new secrets : Enc key length " + newSecrets.getEncKey().length());
            OrderMate.LOG.info("handleSecretsChanged :: received new secrets : Hmac key length " + newSecrets.getHmacKey().length());
        }
        this.secrets = newSecrets;
        this.saveSecrets();
    }

    protected void handlePairingStatusChanged(AssemblyPairingStatus assemblyPairingStatus) {
        AssemblyPairingState assemblyPairingState = assemblyPairingStatus.getAssemblyPairingState();
        PairingFlowState pairingFlowState = assemblyPairingStatus.getPairingFlowState();
        OrderMate.LOG.info("handlePairingState : " + pairingFlowState.getMessage());
        if (assemblyPairingState.equals((Object)this.currentStatus)) {
            return;
        }
        this.currentStatus = assemblyPairingState;
        this.switchPairingState(pairingFlowState);
        this.updateUI();
    }

    private void switchPairingState(PairingFlowState pairingFlowState) {
        switch (this.currentStatus) {
            case CONNECTING: {
                this.pairingPanel.setupForConnectingAndNegotiating(this.getString("CONNECTING_TO_EFTPOS"));
                break;
            }
            case NEGOTIATING_PAIRING: {
                this.pairingPanel.setupForConnectingAndNegotiating(this.getString("NEGOTIATING_PAIRING"));
                break;
            }
            case PAIRING_REQUEST: {
                this.pairingPanel.setupForConnectingAndNegotiating(this.getString("REQUEST_FOR_PAIRING"));
                break;
            }
            case PAIRING_SUCCESSFUL: {
                this.pairingPanel.setupForSuccessFailedPanel(this.getString("PAIRING_SUCCESSFUL"));
                break;
            }
            case PAIRING_FAILED: {
                this.pairingPanel.setupForSuccessFailedPanel(this.getString("PAIRING_FAILED"));
                break;
            }
            case PAIRING_CONNECTION_FAILED: {
                this.pairingPanel.setupForSuccessFailedPanel(this.getString("PAIRING_CONNECTION_FAILED"));
                break;
            }
            case CONFIRM_CODE_ON_EFTPOS: {
                this.pairingPanel.setupConfirmPanel(pairingFlowState.getConfirmationCode(), this.getString("ALSO_CONFIRM_ON_EFTPOS"), true);
                break;
            }
            case CONFIRM_CODE_ON_TERMINAL: {
                this.pairingPanel.setupConfirmPanel(pairingFlowState.getConfirmationCode(), this.getString("DOES_THE_CODE_MATCH"), true);
                break;
            }
            default: {
                OrderMate.LOG.error("Assembly Eftpos, unknown state " + (Object)((Object)this.currentStatus));
            }
        }
    }

    private void saveSecrets() {
        AssemblyEftposSpiHelper helper = this.assemblyEftposSpi.getAssemblyEftposSpiHelper();
        if (this.secrets == null) {
            this.statusPanel.setStatus(this.getString("SORRY_CONNECTED_PAIRED"));
        } else if (helper.isSecretsValid(this.secrets) && helper.isSpiStatusConnected(this.spiStatus)) {
            this.eftpos.setHmacKey(this.secrets.getHmacKey());
            this.eftpos.setEncKey(this.secrets.getEncKey());
            this.eftpos.save();
        } else if (!this.spiStatus.equals((Object)SpiStatus.PAIRED_CONNECTED)) {
            this.statusPanel.setStatus(this.getString("SORRY_CONNECTED_PAIRED"));
        }
    }

    void gotYes() {
        if (AssemblyPairingState.PAIRING_FAILED.equals((Object)this.currentStatus)) {
            this.assemblyEftposSpi.setOperationComplete();
            this.start();
        } else if (AssemblyPairingState.CONFIRM_CODE_ON_TERMINAL.equals((Object)this.currentStatus) || AssemblyPairingState.CONFIRM_CODE_ON_EFTPOS.equals((Object)this.currentStatus)) {
            this.confirmPairing();
        } else if (AssemblyPairingState.PAIRING_SUCCESSFUL.equals((Object)this.currentStatus)) {
            this.assemblyEftposSpi.setOperationComplete();
            this.context.getToolkit().getGuiHandler().closeBlockingDialog(this.guiPanel);
            new AssemblyEftposSpiHelper(this.assemblyEftposSpi).resetRemoteEftpos();
            this.start();
        } else {
            this.handleBadChoice("Yes");
        }
    }

    void gotNo() {
        if (AssemblyPairingState.CONFIRM_CODE_ON_EFTPOS.equals((Object)this.currentStatus)) {
            this.cancelPairing();
        }
        if (AssemblyPairingState.CONFIRM_CODE_ON_TERMINAL.equals((Object)this.currentStatus)) {
            this.cancelPairing();
        } else {
            this.handleBadChoice("No");
        }
    }

    void gotCancel() {
        if (AssemblyPairingState.CONNECTING.equals((Object)this.currentStatus) || AssemblyPairingState.PAIRING_REQUEST.equals((Object)this.currentStatus) || AssemblyPairingState.NEGOTIATING_PAIRING.equals((Object)this.currentStatus)) {
            this.cancelPairing();
            this.start();
        } else if (AssemblyPairingState.PAIRING_CANCELLED.equals((Object)this.currentStatus) || AssemblyPairingState.PAIRING_FAILED.equals((Object)this.currentStatus)) {
            this.start();
        } else {
            this.handleBadChoice("Cancel");
        }
    }

    private void handleBadChoice(String choice) {
        if (Config.isDebuging()) {
            throw new IllegalStateException("Unknown " + choice + " condition for : " + (Object)((Object)this.currentStatus));
        }
        OrderMate.LOG.error("Unknown " + choice + " condition for : " + (Object)((Object)this.currentStatus));
    }

    private void updateUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.guiPanel.revalidate();
            this.guiPanel.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AssemblyEftposPairingScreen.this.guiPanel.revalidate();
                    AssemblyEftposPairingScreen.this.guiPanel.repaint();
                }
            });
        }
    }
}

