/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.pairing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class AssemblyPairingPanel
extends JPanel
implements ActionListener {
    Signal yesSignal = Signals.createSignal();
    Signal noSignal = Signals.createSignal();
    Signal cancelSignal = Signals.createSignal();
    private JTextField statusField;
    private JPanel centerPanel;
    private JButton yesButton;
    private JButton noButton;
    private JButton cancelButton;

    AssemblyPairingPanel() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.createThreeBlockPanel();
        this.statusField = new JTextField();
        this.statusField.setName("STATUSTEXT");
        this.statusField.setEditable(false);
        this.yesButton = new JButton(Internationalization.getLiteralFor("YES_IT_MATCHES"));
        this.yesButton.setName("YES_BUTTON");
        this.yesButton.setActionCommand("YES");
        this.noButton = new JButton(Internationalization.getLiteralFor("NO_IT_DOESNT"));
        this.noButton.setActionCommand("NO");
        this.noButton.setName("NO_BUTTON");
        this.cancelButton = new JButton(Internationalization.getLiteralFor("CANCEL"));
        this.cancelButton.setActionCommand("NO");
        this.cancelButton.setName("CANCEL_BUTTON");
        this.yesButton.addActionListener(this);
        this.noButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void createThreeBlockPanel() {
        this.setLayout(new GridBagLayout());
        JPanel eastPanel = new JPanel();
        JPanel westPanel = new JPanel();
        this.centerPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.2, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)eastPanel, gbc);
        gbc = new GridBagConstraints(1, 0, 4, 1, 0.6, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)this.centerPanel, gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.2, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)westPanel, gbc);
    }

    void setupForConnectingAndNegotiating(String statusText) {
        this.centerPanel.setLayout(new GridLayout(3, 1, 100, 0));
        this.centerPanel.add(this.statusField);
        this.statusField.setText(statusText);
        this.centerPanel.add(this.cancelButton);
    }

    void setupForSuccessFailedPanel(String message) {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout(3, 1, 100, 0));
        this.centerPanel.add(this.statusField);
        this.statusField.setText(message);
        JPanel buttonPanel = new JPanel();
        this.yesButton.setText("Ok");
        buttonPanel.add(this.yesButton);
        this.centerPanel.add(buttonPanel);
    }

    void setupConfirmPanel(String code, String confirmText, boolean yesNoOrCancel) {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout(4, 1, 100, 0));
        this.statusField.setText(Internationalization.getLiteralFor("MATCH_CODE_EFTPOS"));
        JLabel codeLabel = new JLabel();
        codeLabel.setText(code);
        this.centerTextInLabel(codeLabel);
        JLabel confirmLabel = new JLabel();
        confirmLabel.setText(confirmText);
        this.centerTextInLabel(confirmLabel);
        this.centerPanel.add(this.statusField);
        this.centerPanel.add(codeLabel);
        this.centerPanel.add(confirmLabel);
        if (yesNoOrCancel) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3, 30, 0));
            buttonPanel.add(this.noButton);
            buttonPanel.add(new JLabel());
            buttonPanel.add(this.yesButton);
            this.centerPanel.add(buttonPanel);
        } else {
            this.centerPanel.add(this.cancelButton);
        }
    }

    private void centerTextInLabel(JLabel label) {
        label.setHorizontalAlignment(0);
        label.setHorizontalTextPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.yesButton) {
            this.yesSignal.emit();
        } else if (source == this.noButton) {
            this.noSignal.emit();
        } else if (source == this.cancelButton) {
            this.cancelSignal.emit();
        }
    }
}

