/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.pairing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class AssemblyPairingStatusPanel
extends JPanel
implements ActionListener {
    private JPanel centerPanel;
    private JTextField posIdText = null;
    private JTextField eftposAddressText = null;
    private JButton pairButton = null;
    private JTextField statusLabel = null;
    Signal<?, ?, ?, ?, ?> pair = Signals.createSignal();

    private String getStringFor(String key) {
        return Internationalization.getLiteralFor(key);
    }

    void initGUI(VirtualEftpos eftpos) {
        this.removeAll();
        this.revalidate();
        this.setLayout(new GridBagLayout());
        JPanel eastPanel = new JPanel();
        JPanel westPanel = new JPanel();
        this.centerPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)eastPanel, gbc);
        gbc = new GridBagConstraints(1, 0, 4, 1, 0.9, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)this.centerPanel, gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.1, 1.0, 17, 1, new Insets(5, 10, 5, 5), 0, 0);
        this.add((Component)westPanel, gbc);
        this.centerPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        JLabel posIdLabel = new JLabel();
        posIdLabel.setText(this.getStringFor("POS_ID"));
        this.centerPanel.add((Component)posIdLabel, gbc);
        gbc = new GridBagConstraints(1, 0, 3, 1, 0.9, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.posIdText = new JTextField();
        this.posIdText.setEditable(false);
        this.centerPanel.add((Component)this.posIdText, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        JLabel eftposAddressLabel = new JLabel();
        eftposAddressLabel.setText(this.getStringFor("EFTPOS_ADDRESS"));
        this.centerPanel.add((Component)eftposAddressLabel, gbc);
        gbc = new GridBagConstraints(1, 1, 3, 1, 0.9, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.eftposAddressText = new JTextField();
        this.eftposAddressText.setEditable(false);
        this.centerPanel.add((Component)this.eftposAddressText, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        JLabel statusTextLabel = new JLabel(this.getStringFor("STATUS"));
        this.centerPanel.add((Component)statusTextLabel, gbc);
        gbc = new GridBagConstraints(1, 2, 3, 1, 0.9, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.statusLabel = new JTextField();
        this.statusLabel.setEditable(false);
        this.centerPanel.add((Component)this.statusLabel, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        JLabel fillLabel2 = new JLabel("");
        this.centerPanel.add((Component)fillLabel2, gbc);
        gbc = new GridBagConstraints(1, 3, 3, 1, 0.9, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.pairButton = new JButton(this.getStringFor("PAIR"));
        this.pairButton.setActionCommand("PAIR");
        this.pairButton.setName("PAIRBUTTON");
        this.statusLabel.setName("STATUSTEXT");
        this.pairButton.addActionListener(this);
        this.centerPanel.add((Component)this.pairButton, gbc);
        this.posIdText.setEditable(false);
        this.eftposAddressText.setEditable(false);
        this.setData(eftpos);
    }

    void setData(VirtualEftpos eftpos) {
        this.posIdText.setText(eftpos.getLabel());
        this.eftposAddressText.setText(eftpos.getIpAddress());
        if (eftpos.isAlreadyPaired()) {
            this.pairButton.setText(this.getStringFor("UNPAIR"));
            this.setStatus(this.getStringFor("PAIRED_TRYING_TO_CONNECT"));
        } else {
            this.pairButton.setText(this.getStringFor("PAIR"));
            this.setStatus(this.getStringFor("NOT_PAIRED"));
        }
    }

    protected void setStatus(String statusMessage) {
        this.statusLabel.setText(statusMessage);
    }

    public void setPairButtonText(String pairText) {
        this.pairButton.setText(this.getStringFor(pairText));
        this.pairButton.setActionCommand(pairText);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pairButton) {
            this.pair.emit();
        }
    }
}

