/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.payment;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import com.assemblypayments.spi.model.CashoutOnlyResponse;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PurchaseResponse;
import com.assemblypayments.spi.model.RefundResponse;
import com.assemblypayments.spi.model.SpiStatus;
import com.assemblypayments.spi.model.TransactionFlowState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingWorker;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpi;
import ordermate.integration.eftpos.assembly.AssemblyEvent;
import ordermate.integration.eftpos.assembly.AssemblyEventHandler;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionState;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionStatus;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.internationalization.Internationalization;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;

public class AssemblyPaymentProcessor
extends SwingWorker<AssemblyTransactionStatus, AssemblyEvent>
implements AssemblyEventHandler {
    private final AssemblyEftposContext context;
    private final EftposRequest request;
    private final CountDownLatch waitForResult;
    private AssemblyTransactionStatus status;
    private final EftposPrintProcessor printProcessor;
    private final IntegratedPaymentUI gui;
    private final String lineSeparator = System.getProperty("line.separator");
    private boolean wasCanceled = false;

    public AssemblyPaymentProcessor(AssemblyEftposContext context, EftposRequest request) {
        this.context = context;
        this.request = request;
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
        this.waitForResult = new CountDownLatch(1);
        this.gui = context.getToolkit().getUI();
    }

    public CountDownLatch getCountDownLatch() {
        return this.waitForResult;
    }

    private String getTransactionReferenceNumber() {
        StringBuilder SB = new StringBuilder();
        if (this.isRefund()) {
            SB.append("REF-");
        } else {
            SB.append("PUR-");
        }
        SB.append(Terminal.getLocalHost().intID()).append("-").append(System.currentTimeMillis() / 1000L);
        return SB.toString();
    }

    void operationCancelled() {
        this.wasCanceled = true;
        this.gui.setCancelEnabled(false);
        this.gui.setHeaderText(this.getStringFor("TRANSACTION_CANCEL_REQUEST"));
        this.gui.setMessage(this.getStringFor("TRANSACTION_CANCEL_ATTEMPT"), IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.context.getAssemblyEftposSpi().cancelTransaction();
        this.gui.refreshBlockingInterface();
    }

    void gotOption(String option) {
        OrderMate.LOG.info("AssemblyPaymentProcessor : gotOption " + option);
        if (option == null || option.length() == 0) {
            return;
        }
        this.context.getAssemblyEftposSpi().approveSignature(option.equals(this.getStringFor("YES")));
    }

    private String getStringFor(String key) {
        return Internationalization.getLiteralFor(key);
    }

    private void setupGUI() {
        this.gui.setQuestion("", new ArrayList<String>());
        this.gui.setCancelEnabled(true);
        this.gui.setButtonsEnabled(true);
        this.gui.getCancelSignal().connect(this, "operationCancelled");
        this.gui.getOptionSignal().connect(this, "gotOption");
        this.gui.setHeaderText(this.getStringFor("TRANSACTION_STARTED"));
        this.gui.setMessage(this.getStringFor("PRESENT_CARD_MESSAGE"), IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.gui.displayBlockingInterface();
    }

    private boolean isRefund() {
        return this.request.getTransaction().getPaid().lessThan(Price.ZERO_DOLLAR) ^ this.request.isReversal();
    }

    @Override
    protected AssemblyTransactionStatus doInBackground() throws Exception {
        this.setupGUI();
        AssemblyEftposSpi eftposSpi = this.context.getAssemblyEftposSpi();
        String posRef = this.getTransactionReferenceNumber();
        int amount = eftposSpi.getAssemblyEftposSpiHelper().getAmountAsInt(this.request.getTransaction().getPaid());
        int cashout = eftposSpi.getAssemblyEftposSpiHelper().getAmountAsInt(this.request.getTransaction().getCashOut());
        int tipAmount = eftposSpi.getAssemblyEftposSpiHelper().getAmountAsInt(this.request.getTransaction().getTip());
        eftposSpi.setAssemblyEventHandler(this);
        OrderMate.LOG.info("AssemblyPaymentProcessor  : Amount : " + amount + " tip: " + tipAmount + " cashout: " + cashout + " Reversal? " + this.request.isReversal());
        OrderMate.LOG.info("The Spi State is " + eftposSpi.getSpiStatus().name());
        boolean successfullyInitiated = this.isRefund() ? eftposSpi.startRefundTransaction(posRef, Math.abs(amount)) : eftposSpi.startPurchaseTransaction(posRef, amount, cashout, tipAmount);
        if (successfullyInitiated) {
            this.status = new AssemblyTransactionStatus(AssemblyTransactionState.INITIATED);
            this.waitForResult.await();
        }
        return this.status;
    }

    AssemblyTransactionStatus getStatus() {
        return this.status;
    }

    @Override
    public void onAssemblyEvent(AssemblyEvent event) {
        this.publish(event);
    }

    private void appendString(StringBuilder sb, String str) {
        sb.append(str);
        sb.append(this.lineSeparator);
    }

    private void logTransaction(TransactionFlowState state) {
        StringBuilder sb = new StringBuilder();
        this.appendString(sb, "TransactionFlowState DisplayMessage : " + state.getDisplayMessage());
        this.appendString(sb, "### TX PROCESS UPDATE ###");
        this.appendString(sb, "# " + state.getDisplayMessage());
        this.appendString(sb, "# Id: " + state.getPosRefId());
        this.appendString(sb, "# Type: " + state.getType());
        this.appendString(sb, "# Amount: " + (double)state.getAmountCents() / 100.0);
        this.appendString(sb, "# Waiting for signature: " + state.isAwaitingSignatureCheck());
        this.appendString(sb, "# Attempting to cancel: " + state.isAttemptingToCancel());
        this.appendString(sb, "# Finished: " + state.isFinished());
        this.appendString(sb, "# Success: " + state.getSuccess());
        OrderMate.LOG.info(sb.toString());
    }

    protected void handleTransactionEvent(AssemblyEvent event) {
        TransactionFlowState state = (TransactionFlowState)event.getEventDetails();
        this.logTransaction(state);
        if (state.isFinished()) {
            this.invokeFinishedState(state);
        } else {
            this.invokeTransactionProgressState(state);
        }
    }

    private void invokeFinishedState(final TransactionFlowState state) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AssemblyPaymentProcessor.this.handleFinishedState(state);
            }
        };
        new Thread(r).start();
    }

    private void invokeTransactionProgressState(final TransactionFlowState state) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AssemblyPaymentProcessor.this.handleTransactionInProgressState(state);
            }
        };
        new Thread(r).start();
    }

    private void handleSignatureRequiredState(TransactionFlowState state) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getStringFor("YES"));
        options.add(this.getStringFor("NO"));
        if (!this.printProcessor.printEftposDocket(state.getSignatureRequiredMessage().getMerchantReceipt(), this.request, true)) {
            OrderMate.LOG.error("Could not print Eftpos Docket for Signature Required");
        }
        this.gui.setHeaderText(this.getStringFor("SIGNATURE_CONFIRMATION"));
        this.gui.setQuestion(this.getStringFor("SIGNATURE_CONFIRMATION_QUESTION"), options);
        this.gui.refreshBlockingInterface();
    }

    private void handleTransactionInProgressState(final TransactionFlowState state) {
        String message = state.getDisplayMessage();
        message = "<html>" + message.replace(";", "<br>") + "</html>";
        this.gui.setMessage(message, IntegratedPaymentUI.FeedbackStatus.PROGRESS);
        this.gui.refreshBlockingInterface();
        if (state.isAwaitingSignatureCheck()) {
            OrderMate.LOG.info("# RECEIPT TO PRINT FOR SIGNATURE");
            OrderMate.LOG.info(state.getSignatureRequiredMessage().getMerchantReceipt().trim());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AssemblyPaymentProcessor.this.handleSignatureRequiredState(state);
                }
            };
            new Thread(runnable).start();
        }
    }

    private void printReceipt(TransactionFlowState state) {
        try {
            PurchaseResponse receiptResponse = null;
            Message responseMessage = state.getResponse();
            if (responseMessage == null) {
                OrderMate.LOG.error("Receipt Response Message From Assembly is Null " + this.getTransactionReferenceNumber());
                return;
            }
            switch (state.getType()) {
                case PURCHASE: {
                    receiptResponse = new PurchaseResponse(responseMessage);
                    break;
                }
                case REFUND: {
                    receiptResponse = new RefundResponse(responseMessage);
                    break;
                }
                case CASHOUT_ONLY: {
                    receiptResponse = new CashoutOnlyResponse(responseMessage);
                }
            }
            if (receiptResponse != null && !receiptResponse.wasCustomerReceiptPrinted()) {
                if (receiptResponse.getCustomerReceipt().trim().length() > 0) {
                    String merchantCopy = receiptResponse.getCustomerReceipt().replace("CUSTOMER COPY", "MERCHANT COPY");
                    this.printProcessor.printEftposDocket(merchantCopy, this.request, true);
                    if (this.context.getEftpos().isPrintReceipts()) {
                        this.printProcessor.printEftposDocket(receiptResponse.getCustomerReceipt(), this.request, true);
                    }
                } else {
                    OrderMate.LOG.info("Empty receipt not printed");
                }
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info("There is a problem with printing Transaction Ref: " + this.request.getTransaction().getTransactionReference());
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void setOperationCompletedStatus(TransactionFlowState state) {
        String hostResponse = null;
        String cardType = null;
        if (state.getResponse() != null) {
            Message response = state.getResponse();
            hostResponse = response.getDataStringValue("host_response_text");
            OrderMate.LOG.info("Assembly host_response:" + hostResponse);
            OrderMate.LOG.info("Scheme:" + response.getDataStringValue("scheme_name") + " of type " + response.getDataStringValue("scheme_app_name"));
            cardType = response.getDataStringValue("scheme_name");
        }
        switch (state.getSuccess()) {
            case SUCCESS: {
                this.status = new AssemblyTransactionStatus(AssemblyTransactionState.SUCCESS, state.getPosRefId());
                this.setTipAmountFromEftpos(state);
                this.status.setCardType(cardType);
                break;
            }
            case FAILED: {
                if (this.wasCanceled || hostResponse != null && hostResponse.toUpperCase().contains("CANCEL")) {
                    this.status = new AssemblyTransactionStatus(AssemblyTransactionState.CANCELLED, state.getPosRefId());
                    break;
                }
                this.status = new AssemblyTransactionStatus(AssemblyTransactionState.FAILED, state.getPosRefId());
                break;
            }
            case UNKNOWN: {
                this.status = new AssemblyTransactionStatus(AssemblyTransactionState.UNKNOWN, state.getPosRefId());
            }
        }
        this.context.getAssemblyEftposSpi().setOperationComplete();
        this.printReceipt(state);
        this.waitForResult.countDown();
    }

    private void setTipAmountFromEftpos(TransactionFlowState state) {
        try {
            PurchaseResponse purchaseResponse = new PurchaseResponse(state.getResponse());
            if (purchaseResponse.getTipAmount() > 0) {
                Price tipFromEftposTerminal = new Price(FinanceUtils.centsToDollarCents(purchaseResponse.getTipAmount()).toString());
                this.status.setTipAmount(tipFromEftposTerminal);
                this.status.setTipRRN(purchaseResponse.getRRN());
            }
            if (purchaseResponse.getCashoutAmount() > 0) {
                this.status.setCashoutAmount(new Price(FinanceUtils.centsToDollarCents(purchaseResponse.getCashoutAmount()), 0.01));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error((Object)ex);
        }
    }

    private void handleFinishedState(TransactionFlowState state) {
        String response;
        if (state.getResponse() != null && (response = state.getResponse().getDataStringValue("host_response_text")) != null && response.toLowerCase().contains("cancel")) {
            this.wasCanceled = true;
        }
        switch (state.getSuccess()) {
            case SUCCESS: {
                this.gui.setMessage(this.getStringFor("TRANSACTION_SUCCESS"), IntegratedPaymentUI.FeedbackStatus.INFO);
                this.setOperationCompletedStatus(state);
                break;
            }
            case FAILED: {
                if (this.wasCanceled) {
                    this.gui.setMessage(this.getStringFor("TRANSACTION_CANCELLED"), IntegratedPaymentUI.FeedbackStatus.ERROR);
                } else {
                    this.gui.setMessage(this.getStringFor("TRANSACTION_FAILED"), IntegratedPaymentUI.FeedbackStatus.ERROR);
                }
                this.setOperationCompletedStatus(state);
                break;
            }
            case UNKNOWN: {
                this.setOperationCompletedStatus(state);
            }
        }
        this.gui.getOptionSignal().disconnectAll();
        this.gui.getCancelSignal().disconnectAll();
        this.gui.closeBlockingInterface();
    }

    @Override
    protected void process(List<AssemblyEvent> chunks) {
        block4: for (AssemblyEvent event : chunks) {
            OrderMate.LOG.info("Received Assembly Event : " + event.getEventType().name());
            OrderMate.LOG.info("Received Assembly Event Details : " + event.getEventDetails());
            switch (event.getEventType()) {
                case TRANSACTION_EVENT: {
                    this.handleTransactionEvent(event);
                    continue block4;
                }
                case SPI_STATE_CHANGE_EVENT: {
                    this.handleSpiStateChangeEvent(event);
                    continue block4;
                }
            }
            OrderMate.LOG.info("UnExpected EventType " + event.getEventType().name());
        }
    }

    private void handleSpiStateChangeEvent(AssemblyEvent<SpiStatus> event) {
        SpiStatus spiStatus = event.getEventDetails();
        OrderMate.LOG.info("handle SpiState Change Event " + spiStatus.name());
        switch (spiStatus) {
            case PAIRED_CONNECTING: {
                OrderMate.LOG.info("Connection Lost to the EFTPOS Terminal in the midst of transaction");
                break;
            }
            case PAIRED_CONNECTED: {
                OrderMate.LOG.info("Connection restored to the EFTPOS Terminal in the midst of a transaction");
            }
        }
    }

    public void closeDialog() {
        this.gui.closeBlockingInterface();
    }
}

