/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.payment;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.payment.AssemblyPaymentProcessor;
import ordermate.integration.eftpos.assembly.payment.AssemblyPaymentProcessorFactory;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionState;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionStatus;
import ordermate.integration.eftpos.assembly.payment.UnknownAssemblyState;

public class AssemblyTransactionHandler {
    private final AssemblyEftposContext context;
    private final EftposRequest request;
    private AssemblyTransactionStatus status;
    private UnknownAssemblyState unknown;
    private boolean canceledUnknown;

    public AssemblyTransactionHandler(AssemblyEftposContext context, EftposRequest request) {
        this.context = context;
        this.request = request;
        this.status = new AssemblyTransactionStatus(AssemblyTransactionState.NOT_INITIATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssemblyTransactionStatus performTransaction() {
        AssemblyPaymentProcessor paymentProcessor = AssemblyPaymentProcessorFactory.createAssemblyPaymentProcessor(this.context, this.request);
        long timeout = this.context.getEftpos().getTimeoutMillis();
        try {
            paymentProcessor.execute();
            this.status = (AssemblyTransactionStatus)paymentProcessor.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeOutEx) {
            OrderMate.LOG.error(timeOutEx.getMessage(), (Throwable)timeOutEx);
            paymentProcessor.closeDialog();
            this.context.getAssemblyEftposSpi().setOperationComplete();
            this.status = new AssemblyTransactionStatus(AssemblyTransactionState.UNKNOWN);
        }
        catch (ExecutionException ee) {
            OrderMate.LOG.error(ee.getMessage(), (Throwable)ee);
            this.status = new AssemblyTransactionStatus(AssemblyTransactionState.ERROR, ee);
        }
        catch (InterruptedException intEx) {
            OrderMate.LOG.error(intEx.getMessage(), (Throwable)intEx);
            this.status = new AssemblyTransactionStatus(AssemblyTransactionState.ERROR, intEx);
        }
        finally {
            paymentProcessor.getCountDownLatch().countDown();
            this.context.getAssemblyEftposSpi().setOperationComplete();
        }
        this.context.getToolkit().getUI().getCancelSignal().disconnectAll();
        this.context.getToolkit().getUI().getOptionSignal().disconnectAll();
        if (AssemblyTransactionState.UNKNOWN.equals((Object)this.status.getState())) {
            this.doUnknown(paymentProcessor);
        }
        return this.status;
    }

    private void doUnknown(AssemblyPaymentProcessor paymentProcessor) {
        this.unknown = new UnknownAssemblyState(this.context);
        this.unknown.showOptions();
        AssemblyTransactionStatus unknownStatus = null;
        while (AssemblyTransactionState.UNKNOWN.equals((Object)this.status.getState()) || unknownStatus == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            this.status = paymentProcessor.getStatus();
            if (!(AssemblyTransactionState.UNKNOWN.equals((Object)this.status.getState()) || AssemblyTransactionState.INITIATED.equals((Object)this.status.getState()) || AssemblyTransactionState.NOT_INITIATED.equals((Object)this.status.getState()))) {
                unknownStatus = this.status;
                this.unknown.stop();
                continue;
            }
            unknownStatus = this.unknown.getSelection();
            if (unknownStatus != null) {
                this.status = unknownStatus;
            }
            this.canceledUnknown = AssemblyTransactionState.CANCELLED.equals((Object)this.status.getState());
        }
    }

    public AssemblyEftposContext getContext() {
        return this.context;
    }

    public EftposRequest getRequest() {
        return this.request;
    }

    public boolean wasCanceledUnknown() {
        return this.canceledUnknown;
    }
}

