/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.payment;

import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionHandler;

public class AssemblyTransactionHandlerFactory {
    private static Strategy strategy = Strategy.PRODUCTION;
    private static AssemblyTransactionHandler testTransactionHandler = null;

    public static void setStrategy(Strategy newStrategy) {
        strategy = newStrategy;
    }

    public static void setTestHandler(AssemblyTransactionHandler handler) {
        testTransactionHandler = handler;
    }

    public static AssemblyTransactionHandler createAssemblyTransactionHandler(AssemblyEftposContext context, EftposRequest request) {
        AssemblyTransactionHandler transactionHandler = null;
        switch (strategy) {
            case TEST: {
                transactionHandler = testTransactionHandler;
                break;
            }
            case PRODUCTION: {
                transactionHandler = new AssemblyTransactionHandler(context, request);
            }
        }
        return transactionHandler;
    }

    public static enum Strategy {
        TEST,
        PRODUCTION;

    }
}

