/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.payment;

import au.com.ordermate.util.Price;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionState;

public class AssemblyTransactionStatus {
    private final AssemblyTransactionState state;
    private final Exception exception;
    private Price tipAmount = Price.ZERO_DOLLAR;
    private Price cashoutAmount = Price.ZERO_DOLLAR;
    private String tipRRN = null;
    private final String refId;
    private String cardType;

    public AssemblyTransactionStatus(AssemblyTransactionState state) {
        this(state, (String)null);
    }

    public AssemblyTransactionStatus(AssemblyTransactionState state, String refId) {
        this.state = state;
        this.exception = null;
        this.refId = refId;
    }

    public AssemblyTransactionStatus(AssemblyTransactionState state, Exception exception) {
        this.state = state;
        this.exception = exception;
        this.refId = null;
    }

    public AssemblyTransactionState getState() {
        return this.state;
    }

    public Exception getException() {
        return this.exception;
    }

    public EftposStatus getEftposStatus() {
        switch (this.state) {
            case FAILED: {
                return EftposStatus.ERROR;
            }
            case SUCCESS: {
                return EftposStatus.APPROVED;
            }
        }
        return EftposStatus.UNKNOWN;
    }

    public void setTipAmount(Price tipAmount) {
        this.tipAmount = tipAmount;
    }

    public Price getTipAmount() {
        return this.tipAmount;
    }

    public String getTipRRN() {
        return this.tipRRN;
    }

    public void setTipRRN(String tipRRN) {
        this.tipRRN = tipRRN;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setCashoutAmount(Price price) {
        this.cashoutAmount = price;
    }

    public Price getCashoutAmount() {
        return this.cashoutAmount;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String value) {
        this.cardType = value;
    }
}

