/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.assembly.payment;

import java.util.ArrayList;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionState;
import ordermate.integration.eftpos.assembly.payment.AssemblyTransactionStatus;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.internationalization.Internationalization;

class UnknownAssemblyState {
    private final IntegratedPaymentUI gui;
    private AssemblyTransactionStatus selection;
    private static final String OVERRIDE = "Override as Paid";

    UnknownAssemblyState(AssemblyEftposContext context) {
        this.gui = context.getToolkit().getUI();
        this.gui.getOptionSignal().connect(this, "gotOption");
    }

    private String getStringFor(String key) {
        return Internationalization.getLiteralFor(key);
    }

    void showOptions() {
        ArrayList<String> options = new ArrayList<String>();
        this.gui.setQuestion("", new ArrayList<String>());
        options.add(OVERRIDE);
        options.add(this.getStringFor("RETRY"));
        options.add("Cancel");
        this.gui.setHeaderText(this.getStringFor("TRANSACTION_CONFIRMATION"));
        this.gui.setMessage("", IntegratedPaymentUI.FeedbackStatus.INFO);
        this.gui.setQuestion(this.getStringFor("TRANSACTION_CONFIRMATION_QUESTION"), options);
        this.gui.setCancelVisible(false);
        this.gui.displayBlockingInterface();
    }

    AssemblyTransactionStatus getSelection() {
        return this.selection;
    }

    void gotOption(String option) {
        this.selection = this.getStringFor("RETRY").equals(option) ? new AssemblyTransactionStatus(AssemblyTransactionState.RETRY) : (OVERRIDE.equals(option) ? new AssemblyTransactionStatus(AssemblyTransactionState.SUCCESS) : new AssemblyTransactionStatus(AssemblyTransactionState.CANCELLED));
        this.stop();
    }

    void stop() {
        this.gui.getOptionSignal().disconnect(this);
        this.gui.setCancelVisible(true);
        this.gui.closeBlockingInterface();
    }
}

