/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.ingenico;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.eftpos.EftposLogger;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.ingenico.IngenicoHelper;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.pceftpos.PCEftposDisplayResponse;
import ordermate.integration.eftpos.pceftpos.PCEftposLogonResponse;
import ordermate.integration.eftpos.pceftpos.PCEftposStatusResponse;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;

public class IngenicoEftpos
implements PhysicalEftpos {
    private static final long TOO_LONG = 15000L;
    private static final int INITIAL_WAIT = 5000;
    private static final int LOGIN_WAIT = 5000;
    private static final int LOGON_ATTEMPT_WAIT = 7000;
    private static final int LOGON_TIMEOUT_WAIT = 35000;
    private static final int RESPONSE_ATTEMPT_WAIT = 30000;
    private static final int LOGON_RETRY_WAIT = 500;
    private boolean tipping;
    private VirtualEftpos vEft;
    private Socket tcpSocket;
    private EftposPrintProcessor printProcessor;
    private final int postStatusDelay;
    private static Boolean ignoreLogon = null;
    private String terminalID;
    private final IntegratedPaymentUI ui;
    private Timer timer;

    public IngenicoEftpos(IntegratedPaymentUI ui) {
        this.ui = ui;
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
        this.postStatusDelay = Math.max(Config.getIntValue("PCEFTPOSDelay"), 0);
        this.timer = new Timer("Ingenico Timer");
    }

    private static boolean isIgnoreLogon() {
        if (ignoreLogon == null) {
            ExperimentalFeature exp = ExperimentalFeature.find("PC-EFT Auto-Assume Logon");
            ignoreLogon = exp != null && exp.getBooleanValue(false) != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return ignoreLogon;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("Ingenico Timer");
        String ipAddress = virtualEftpos.getIpAddress();
        Integer port = virtualEftpos.getPort();
        this.tipping = virtualEftpos.isEnableTip();
        this.terminalID = virtualEftpos.getTerminalId();
        try {
            this.tcpSocket = new Socket();
            this.tcpSocket.setSoTimeout(5000);
            InetSocketAddress address = new InetSocketAddress(ipAddress, (int)port);
            this.tcpSocket.connect(address);
            if (!this.initialise()) {
                this.closeOff();
                return;
            }
            OrderMate.LOG.info("PCEftpos initialised");
            this.tcpSocket.setSoTimeout(virtualEftpos.getTimeoutMillis());
            this.vEft = virtualEftpos;
        }
        catch (Exception e) {
            OrderMateLog.LOG.warn("Couldn't connect to Ingenico adapter:" + this.tcpSocket);
            this.closeOff();
        }
    }

    private boolean initialise() throws SocketException {
        if (IngenicoEftpos.isIgnoreLogon()) {
            return true;
        }
        String statusResponse = this.getStatus();
        PCEftposStatusResponse status = new PCEftposStatusResponse(statusResponse);
        if (status == null || !status.isConversionSuccessful()) {
            OrderMate.LOG.warn("PCEftpos gave no response");
            return false;
        }
        if (!status.isSuccess()) {
            OrderMate.LOG.warn("PCEftpos not ready or in error");
            return false;
        }
        if (!status.isLogonSuccess()) {
            OrderMate.LOG.info("PCEftpos appeared to be not logged in. Will attempt now.");
            boolean loginSuccessful = this.tryLogin();
            if (!(loginSuccessful || (status = new PCEftposStatusResponse(statusResponse = this.getStatus())).isSuccess() && status.isLogonSuccess())) {
                OrderMate.LOG.info("PCEftpos not ready after login, failing.");
                return false;
            }
        }
        OrderMate.LOG.info("PCEftpos online and logged in, proceeding");
        this.sendRequest(IngenicoHelper.createDialogRequest(true));
        String response = this.readResponse();
        if (!IngenicoHelper.isDialogRequestSuccessful(response) && (response == null || response.contains("PINPad"))) {
            OrderMate.LOG.warn("Ingenico response to show header shows the client was not available " + response);
            this.closeOff();
            return false;
        }
        return true;
    }

    @Override
    public void closeOff() {
        if (this.tcpSocket != null && !this.tcpSocket.isClosed()) {
            try {
                this.tcpSocket.close();
            }
            catch (Exception ex) {
                OrderMateLog.LOG.warn("Trouble closing off socket:", (Throwable)ex);
            }
        }
        this.timer.cancel();
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        if (request.isTippingAdjustment() ? !this.sendRequest(IngenicoHelper.createTipAdjustmentRequest((CreditTransaction)request.getTransaction())) : !this.sendRequest(IngenicoHelper.createTransactionRequest(request, this.tipping))) {
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
        }
        boolean txnResult = false;
        String response = null;
        block0: while (!txnResult) {
            response = this.readResponse();
            if (response == null || response.length() == 0) {
                txnResult = true;
                break;
            }
            List<String> responses = StringUtils.splitToList(response, "#");
            responses.remove("");
            for (String r : responses) {
                r = "#" + r;
                OrderMate.LOG.info("Response Message Received from EFTPOS Terminal " + r);
                if (IngenicoHelper.isTransactionResponse(r)) {
                    txnResult = true;
                    continue block0;
                }
                if (IngenicoHelper.isReceiptResponse(r)) {
                    this.printReceipt(r, request);
                    continue;
                }
                EftposLogger.logMessage("transaction received unknown response :" + r);
            }
        }
        return IngenicoHelper.getEftposResult(request, response);
    }

    private void printReceipt(String response, EftposRequest request) {
        String docket = IngenicoHelper.decodeReceipt(response);
        if (docket != null && docket.length() > 0) {
            this.printProcessor.printEftposDocket(docket, request, IngenicoHelper.isCustomerReceipt(response));
        }
        this.sendRequest(IngenicoHelper.createReceiptRequest(response));
    }

    @Override
    public boolean supportsNonBlocking() {
        return true;
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return this.tcpSocket != null && this.tcpSocket.isConnected() && !this.tcpSocket.isClosed();
    }

    private String getStatus() {
        if (this.sendRequest(IngenicoHelper.createStatusRequest())) {
            return this.readResponse();
        }
        this.doDelay();
        return null;
    }

    @Override
    public String getTerminalIDIfReady() {
        if (IngenicoEftpos.isIgnoreLogon()) {
            return this.terminalID;
        }
        String statusResponse = this.getStatus();
        PCEftposStatusResponse status = new PCEftposStatusResponse(statusResponse);
        if (status != null && status.isSuccess()) {
            if (!StringUtils.isEmpty(status.getEftposNetwork()) && this.vEft != null) {
                this.vEft.setLastConnectedBank(status.getEftposNetwork());
                this.vEft.save();
            }
            return IngenicoHelper.getIdIfStatusReady(statusResponse);
        }
        return null;
    }

    private boolean tryLogin() {
        boolean loginSuccessful = false;
        this.ui.displayBlockingInterface();
        this.ui.setCancelVisible(false);
        this.ui.setMessage("<html>Pinpad is not logged in.<br><br>Attempting log in now...", IntegratedPaymentUI.FeedbackStatus.INFO);
        if (this.sendRequest(IngenicoHelper.createLoginRequest())) {
            boolean logonResult = false;
            String response = null;
            int timeWaited = 0;
            while (!logonResult && timeWaited < 35000) {
                String[] responses;
                response = this.readResponse();
                OrderMate.LOG.info("Response Message Received from EFTPOS Terminal " + response);
                for (String r : responses = response.split("#")) {
                    if (PCEftposLogonResponse.isValidLogonResponse(r)) {
                        logonResult = true;
                        response = r;
                        continue;
                    }
                    if (PCEftposDisplayResponse.isValidDisplayResponse(r)) continue;
                    EftposLogger.logMessage("transaction received unknown response :" + response);
                }
                if (logonResult) continue;
                try {
                    timeWaited += 500;
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            if (logonResult) {
                loginSuccessful = IngenicoHelper.isLoginSuccessful(response);
            }
            if (!loginSuccessful) {
                this.ui.displayBlockingInterface();
                this.ui.setCancelVisible(false);
                this.ui.setMessage("<html>Pinpad is not logged in.<br><br>Automatic login attempted, please try again.", IntegratedPaymentUI.FeedbackStatus.INFO);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                loginSuccessful = IngenicoHelper.isLoggedOn(this.getStatus());
            }
            OrderMate.LOG.info("IngenicoEftpos :: tryLogin :: returns loginSuccessful :: " + loginSuccessful);
        }
        this.ui.getCancelSignal().disconnectAll();
        this.ui.closeBlockingInterface();
        return loginSuccessful;
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    private void doDelay() {
        if (this.postStatusDelay > 0) {
            try {
                Thread.sleep(this.postStatusDelay);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Unexpected thread error! ", (Throwable)e);
            }
        }
        OrderMate.LOG.info("DoStatus delayed for " + this.postStatusDelay + " seconds");
    }

    @Override
    public void printInterruptedTransaction(String lastTxn) {
        String lastTxnRef;
        if (this.sendRequest(IngenicoHelper.createGetLastTransactionRequest()) && (lastTxnRef = IngenicoHelper.getLastTransactionReference(this.waitForLastTransactionResponse())) != null && !lastTxnRef.equals(lastTxn)) {
            this.sendRequest(IngenicoHelper.createPrintLastDocketRequest());
            String response = this.readResponse();
            if (IngenicoHelper.isReceiptResponse(response)) {
                this.printReceipt(response, null);
            }
        }
    }

    public String waitForLastTransactionResponse() {
        boolean txnResult = false;
        String response = null;
        while (!txnResult) {
            response = this.readResponse();
            if (response == null || response.length() == 0) {
                txnResult = true;
                return response;
            }
            List<String> responses = StringUtils.splitToList(response, "#");
            responses.remove("");
            for (String r : responses) {
                r = "#" + r;
                OrderMate.LOG.info("Response Message Received from EFTPOS Terminal " + r);
                if (IngenicoHelper.isLastTransactionResponse(r)) {
                    txnResult = true;
                    return r;
                }
                EftposLogger.logMessage("transaction received unknown response :" + r);
            }
        }
        return null;
    }

    @Override
    public String clearInterruptedTransactions() {
        String lastTxnRef = null;
        if (this.sendRequest(IngenicoHelper.createGetLastTransactionRequest())) {
            lastTxnRef = IngenicoHelper.getLastTransactionReference(this.readResponse());
        }
        return lastTxnRef;
    }

    private boolean sendRequest(String request) {
        try {
            this.tcpSocket.getOutputStream().write(request.getBytes());
            this.tcpSocket.getOutputStream().flush();
            return true;
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Couldn't send TCP socket request to ingenico adapter.", (Throwable)ex);
            return false;
        }
    }

    public void setTcpSocket(Socket tcpSocket) {
        this.tcpSocket = tcpSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse() {
        String received = null;
        IngenicoInterrupter interrupter = new IngenicoInterrupter();
        this.timer.schedule((TimerTask)interrupter, 15000L);
        try {
            int length = this.tcpSocket.getReceiveBufferSize();
            if (length != 0) {
                byte[] bytes = new byte[length];
                int read = this.tcpSocket.getInputStream().read(bytes);
                received = new String(bytes, 0, read);
            }
        }
        catch (Exception ex) {
            OrderMateLog.LOG.warn("Error reading response from Ingenico TCP Adapter.", (Throwable)ex);
        }
        finally {
            interrupter.cancel();
        }
        return received;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsTipping() {
        return true;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }

    class IngenicoInterrupter
    extends TimerTask {
        IngenicoInterrupter() {
        }

        @Override
        public void run() {
            OrderMate.LOG.info("PCEftpos taking too long, showing option to close");
            IngenicoEftpos.this.ui.setMessage("<HTML>The PCEftpos transaction appears to be taking too long.<br>Please check the pinpad and cables.<br><br>If you are sure there is an issue, you can cancel the operation</HTML>", IntegratedPaymentUI.FeedbackStatus.WARNING);
            IngenicoEftpos.this.ui.setCancelVisible(true);
            IngenicoEftpos.this.ui.setCancelEnabled(true);
            IngenicoEftpos.this.ui.getCancelSignal().connect(this, "gotCancel");
            IngenicoEftpos.this.ui.displayBlockingInterface();
        }

        public void gotCancel() {
            this.cancel();
            IngenicoEftpos.this.closeOff();
        }

        @Override
        public boolean cancel() {
            boolean result = super.cancel();
            IngenicoEftpos.this.ui.getCancelSignal().disconnectAll();
            IngenicoEftpos.this.ui.closeBlockingInterface();
            return result;
        }
    }
}

