/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.ingenico;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.text.DecimalFormat;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.pceftpos.PCEftposLogonResponse;

class IngenicoHelper {
    static final String REQUEST_STATUS = "K ";
    private static final int STATUS_SUBCODE = 1;
    private static final int STATUS_SUCCESS = 1;
    private static final int STATUS_RESPONSE_CODE = 2;
    private static final int STATUS_RESPONSE_TEXT = 20;
    private static final int STATUS_MERCHANT = 2;
    private static final int STATUS_AIIC = 11;
    private static final int STATUS_NII = 3;
    private static final int STATUS_MERCHANT_ID = 15;
    private static final int STATUS_TERMINAL_ID = 8;
    private static final int STATUS_TIMEOUT = 3;
    private static final int STATUS_LOGGED_ON = 1;
    private static final int STATUS_SERIAL_NUMBER = 16;
    private static final int STATUS_VERSION_NUMBER = 16;
    private static final int STATUS_EFTPOS_NETWORK = 32;
    static final String REQUEST_TXN = "M0";
    static final String REQUEST_LAST_TXN = "N0";
    private static final String TXN_PAYMENT_CODE = "P";
    private static final String TXN_REFUND_CODE = "R";
    private static final String TXN_TIPPING_CODE = "T";
    private static final String TXN_CASHOUT_CODE = "C";
    private static final int TXN_SUBCODE = 1;
    private static final int TXN_SUCCESS = 1;
    private static final int TXN_RESPONSE_CODE = 2;
    private static final int TXN_RESPONSE_TEXT = 20;
    private static final int TXN_MERCHANT = 2;
    private static final int TXN_TYPE = 1;
    private static final int TXN_ACCOUNT_TYPE = 7;
    private static final int TXN_CASHOUT = 9;
    private static final int TXN_PURCHASE = 9;
    private static final int TXN_TIP = 9;
    private static final int TXN_AUTH_CODE = 6;
    private static final int TXN_REFERENCE = 16;
    private static final int TXN_STAN = 6;
    private static final int TXN_MERCHANT_ID = 15;
    private static final int TXN_TERMINAL_ID = 8;
    private static final int TXN_EXP_DATE = 4;
    private static final int TXN_SETTLE_DATE = 4;
    private static final int TXN_DATE = 6;
    private static final int TXN_TIME = 6;
    private static final int TXN_CARD_TYPE = 20;
    private static final int TXN_PAN = 20;
    private static final int TXN_TRACK_2 = 40;
    private static final int TXN_RRN = 12;
    private static final int TXN_CARD_NAME = 2;
    private static final int TXN_CARD_NUMBER = 20;
    private static final int TXN_FLAG_ARRAY = 8;
    private static final int TXN_BALANCE_RECIEVED = 1;
    private static final int TXN_AVAILABLE_BALANCE = 9;
    private static final int TXN_CLEAREDFUNDS_BALANCE = 9;
    static final String LAST_TXN_REQUEST = "N0  ";
    static final String REQUEST_DIALOG = "2 ";
    private static final String REQUEST_DIALOG_HIDDEN = "2";
    private static final String REQUEST_DIALOG_SHOWING = "1";
    private static final int REQUEST_DIALOG_TITLE = 32;
    static final String REQUEST_RECEIPT = "3";
    private static final String RECEIPT_CUSTOMER = "CUSTOMER COPY";
    private static final String RECEIPT_DONT_CARE = " ";
    private static final String CHEQUE_TYPE = "Cheque";
    private static final String SAVINGS_TYPE = "Savings";
    private static final String CREDIT_TYPE = "Credit";
    private static final String CARD_UNKNOWN = "00";
    private static final String CARD_DEBIT = "01";
    private static final String CARD_BANKCARD = "02";
    private static final String CARD_MASTERCARD = "03";
    private static final String CARD_VISA = "04";
    private static final String CARD_AMEX = "05";
    private static final String CARD_DINERS = "06";
    private static final String CARD_JCB = "07";
    private static final String CARD_JCB_2 = "09";
    private static final String CARD_JCB_3 = "11";
    private static final String REQUEST_REPRINT = "C";
    private static final String REQUEST_REPRINT_LAST = "C2000000";
    public static final String LOGON_COMMAND = "G";
    private static final String LOGON_SUBCODE_REQUEST = "0";
    private static final String LOGON_MERCHANT = "00";
    private static final String LOGON_PRINT_RECEIPT_YES = "1";
    private static final String LOGON_CUT_RECEIT_YES = "1";
    private static final String LOGON_APP = "00";
    public static final String LOGON_SUBCODE_RESPONSE = " ";
    public static final String LOGON_SUCCESS = "1";
    public static final String SUCCESS = "1";
    public static final String APPROVED = "approv";
    public static final String ACCEPTED = "accepted";
    public static final String SIGN_RECEIPT_ACCEPTED = "sign receipt";
    public static final String DECLINED = "decline";
    public static final String INCORRECT_PIN = "incorrect pin";
    public static final String PIN_REQUIRED = "pin required";
    public static final String EXPIRED = "expired";
    public static final String INVALID = "invalid";
    public static final String TIMEOUT = "timeout";
    public static final String ABORT = "abort";
    private static final DecimalFormat priceToStringFormat = new DecimalFormat("000000000");

    IngenicoHelper() {
    }

    static final String createStatusRequest() {
        StringBuilder SB = new StringBuilder(REQUEST_STATUS);
        SB.append("00");
        SB.append("00");
        return IngenicoHelper.prependHeader(SB.toString());
    }

    static final String createTipAdjustmentRequest(CreditTransaction txn) {
        StringBuilder SB = new StringBuilder(REQUEST_TXN);
        SB.append("00");
        SB.append(TXN_TIPPING_CODE);
        SB.append(LOGON_SUBCODE_REQUEST);
        SB.append(" ");
        SB.append(IngenicoHelper.priceToString(Price.ZERO_DOLLAR));
        SB.append(IngenicoHelper.priceToString(txn.getTip()));
        SB.append(IngenicoHelper.padString(6, txn.getAuthCode(), ' '));
        SB.append(IngenicoHelper.padString(16, txn.getTransactionReference(), '0'));
        SB.append(LOGON_SUBCODE_REQUEST);
        SB.append(LOGON_SUBCODE_REQUEST);
        SB.append(" ");
        SB.append(IngenicoHelper.padString(20, "", ' '));
        SB.append("    ");
        SB.append(IngenicoHelper.padString(40, "", ' '));
        SB.append(" ");
        SB.append("  ");
        SB.append(IngenicoHelper.padString(12, txn.getTipReference(), ' '));
        return IngenicoHelper.prependHeader(SB.toString());
    }

    static final String createTransactionRequest(EftposRequest request, boolean enableTipping) {
        Price cashout = request.getTransaction().getCashOut();
        Price payment = request.getTransaction().getPaid().add(request.getTransaction().getTip());
        StringBuilder SB = new StringBuilder(REQUEST_TXN);
        SB.append("00");
        if (request.getTransaction().getPaid().lessThan(Price.ZERO_DOLLAR) ^ request.isReversal()) {
            SB.append(TXN_REFUND_CODE);
        } else if (request.getTransaction().getPaid().equals(Price.ZERO_DOLLAR) && request.getTransaction().getCashOut().greaterThan(Price.ZERO_DOLLAR)) {
            SB.append("C");
        } else {
            SB.append(TXN_PAYMENT_CODE);
        }
        SB.append(LOGON_SUBCODE_REQUEST);
        if (enableTipping) {
            SB.append("1");
        } else {
            SB.append(LOGON_SUBCODE_REQUEST);
        }
        if (!request.isReversal()) {
            SB.append(IngenicoHelper.priceToString(cashout));
        } else {
            SB.append(IngenicoHelper.priceToString(Price.ZERO_DOLLAR));
        }
        SB.append(IngenicoHelper.priceToString(payment));
        SB.append("000001");
        SB.append("0000000000000001");
        SB.append(LOGON_SUBCODE_REQUEST);
        SB.append(LOGON_SUBCODE_REQUEST);
        SB.append(" ");
        SB.append(IngenicoHelper.padString(20, "", ' '));
        SB.append("    ");
        SB.append(IngenicoHelper.padString(40, "", ' '));
        SB.append(" ");
        SB.append("  ");
        SB.append(IngenicoHelper.padString(12, "", ' '));
        return IngenicoHelper.prependHeader(SB.toString());
    }

    static final String createDialogRequest(boolean show) {
        StringBuilder SB = new StringBuilder(REQUEST_DIALOG);
        if (show) {
            SB.append("1");
        } else {
            SB.append(REQUEST_DIALOG_HIDDEN);
        }
        SB.append("0000");
        SB.append("0000");
        SB.append("Centre      ");
        SB.append("1");
        SB.append(IngenicoHelper.padString(32, "", ' '));
        String toSend = IngenicoHelper.prependHeader(SB.toString());
        return toSend;
    }

    static final boolean isDialogRequestSuccessful(String response) {
        return response != null && IngenicoHelper.stripHeader(response).substring(1, 2).equals("1");
    }

    static final String createLoginRequest() {
        StringBuilder sb = new StringBuilder(LOGON_COMMAND);
        sb.append(LOGON_SUBCODE_REQUEST);
        sb.append("00");
        sb.append("1");
        sb.append("1");
        sb.append("00");
        return IngenicoHelper.prependHeader(sb.toString());
    }

    static final boolean isLoginSuccessful(String response) {
        String actualResponse = IngenicoHelper.stripHeader(response);
        PCEftposLogonResponse logonResponse = new PCEftposLogonResponse(response);
        OrderMate.LOG.info("IngenicoHelper :: isLoginSuccessful :: " + logonResponse.isLogonSuccess());
        return logonResponse.isLogonSuccess();
    }

    static final Pair<Boolean, String> getStatus(String response) {
        if (StringUtils.isEmpty(response)) {
            return null;
        }
        String strip = IngenicoHelper.stripHeader(response);
        int snippetIndex = 1;
        boolean success = strip.substring(snippetIndex++, snippetIndex).equals("1");
        String statusText = strip.substring(snippetIndex += 2, snippetIndex += 20);
        OrderMateLog.LOG.info("PCEftpos status: " + statusText);
        return new Pair<Boolean, String>(success, statusText);
    }

    static final boolean isLoggedOn(String response) {
        if (StringUtils.isEmpty(response)) {
            return false;
        }
        String strip = IngenicoHelper.stripHeader(response);
        int snippetIndex = 66;
        return strip.substring(snippetIndex++, snippetIndex).equals("1");
    }

    static final String getIdIfStatusReady(String response) {
        if (StringUtils.isEmpty(response)) {
            return null;
        }
        String strip = IngenicoHelper.stripHeader(response);
        int snippetIndex = 1;
        boolean success = strip.substring(snippetIndex++, snippetIndex).equals("1");
        snippetIndex += 2;
        snippetIndex += 20;
        snippetIndex += 2;
        snippetIndex += 11;
        snippetIndex += 3;
        String actualTerminalID = strip.substring(snippetIndex += 15, snippetIndex += 8);
        snippetIndex += 3;
        boolean loggedOn = strip.substring(snippetIndex++, snippetIndex).equals("1");
        if (success && loggedOn) {
            return actualTerminalID.trim();
        }
        return null;
    }

    private static String getSafeSubstring(int index, int end, String subStr) {
        if (end > subStr.length()) {
            return "";
        }
        return subStr.substring(index, end);
    }

    private static String getPadData(String tag, String pad) {
        if (pad == null || !pad.contains(tag)) {
            return null;
        }
        int fullPADLength = pad.length();
        int index = 0;
        if (StringUtils.isNumeric(IngenicoHelper.getSafeSubstring(0, 3, pad))) {
            fullPADLength = Integer.parseInt(IngenicoHelper.getSafeSubstring(0, 3, pad));
            index = 3;
        }
        while (index < fullPADLength) {
            String PADTag = IngenicoHelper.getSafeSubstring(index, index += 3, pad);
            int PADLength = Integer.parseInt(IngenicoHelper.getSafeSubstring(index, index += 3, pad));
            String PADData = IngenicoHelper.getSafeSubstring(index, index += PADLength, pad);
            if (!tag.equals(PADTag)) continue;
            return PADData;
        }
        return null;
    }

    private static Price getAmountPaid(String pad) {
        if (!StringUtils.isEmpty(pad)) {
            while (!StringUtils.isEmpty(pad)) {
                String PADTag = IngenicoHelper.getSafeSubstring(0, 3, pad);
                int PADLength = Integer.parseInt(IngenicoHelper.getSafeSubstring(3, 6, pad));
                String PADData = IngenicoHelper.getSafeSubstring(6, pad.length(), pad);
                pad = pad.length() > 6 + PADLength ? IngenicoHelper.getSafeSubstring(6 + PADLength, pad.length() - 1, pad) : "";
                if (PADTag == null || !PADTag.equals("AMT")) continue;
                return IngenicoHelper.stringToPrice(PADData);
            }
        }
        return null;
    }

    static final EftposResult getEftposResult(EftposRequest request, String response) {
        Price PADPaid;
        EftposStatus eftStatus;
        if (response == null) {
            return null;
        }
        String stripped = IngenicoHelper.stripHeader(response);
        int snippetIndex = 1;
        String success = stripped.substring(snippetIndex++, snippetIndex);
        String resCode = stripped.substring(snippetIndex, snippetIndex += 2);
        String resText = stripped.substring(snippetIndex, snippetIndex += 20).toLowerCase();
        snippetIndex += 2;
        String accountType = stripped.substring(++snippetIndex, snippetIndex += 7);
        String cashout = stripped.substring(snippetIndex, snippetIndex += 9);
        String paid = stripped.substring(snippetIndex, snippetIndex += 9);
        String tip = stripped.substring(snippetIndex, snippetIndex += 9);
        String authCode = stripped.substring(snippetIndex, snippetIndex += 6).trim();
        String STAN = stripped.substring(snippetIndex += 16, snippetIndex += 6);
        String termID = stripped.substring(snippetIndex += 15, snippetIndex += 8);
        snippetIndex += 4;
        snippetIndex += 4;
        snippetIndex += 6;
        String cardUnit = IngenicoHelper.getSafeSubstring(snippetIndex += 6, snippetIndex += 20, stripped);
        String track2 = IngenicoHelper.getSafeSubstring(snippetIndex += 20, snippetIndex += 40, stripped).trim();
        String RRN = IngenicoHelper.getSafeSubstring(snippetIndex, snippetIndex += 12, stripped).trim();
        String cardName = IngenicoHelper.getSafeSubstring(snippetIndex, snippetIndex += 2, stripped);
        snippetIndex += 8;
        ++snippetIndex;
        snippetIndex += 9;
        String purchaseAnalysisData = "";
        if (stripped.length() - 1 > (snippetIndex += 9)) {
            purchaseAnalysisData = IngenicoHelper.getSafeSubstring(snippetIndex, stripped.length(), stripped);
        }
        if (IngenicoHelper.isSuccessful(success, resText)) {
            eftStatus = EftposStatus.APPROVED;
        } else if (resText.contains("cancel")) {
            eftStatus = EftposStatus.CANCELLED;
        } else if (IngenicoHelper.isDeclined(resText)) {
            eftStatus = EftposStatus.DECLINED;
        } else if (resText.contains("error") || resText.contains("pinpad offline")) {
            eftStatus = EftposStatus.ERROR;
        } else {
            if (resText.contains("pinpad busy")) {
                EftposStatus eftStatus2 = EftposStatus.ERROR;
                return new EftposResult(request, eftStatus2, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, termID, resText);
            }
            OrderMate.LOG.warn("Unrecognized response code : " + resText + " setting EftposStatus as unknown.");
            eftStatus = EftposStatus.UNKNOWN;
        }
        EftposTransaction txn = request.getTransaction();
        if (!request.isTippingAdjustment()) {
            txn.setTransactionReference(STAN);
            txn.setAuthCode(authCode.isEmpty() ? null : authCode);
            txn.setTipReference(txn.getAuthCode() == null || RRN.isEmpty() ? null : RRN);
        }
        FinanceUnit cardType = IngenicoHelper.interpretCardType(accountType.trim(), cardName, cardUnit);
        Price actuallySurcharged = txn.getSurcharge();
        Price actuallyPaid = IngenicoHelper.stringToPrice(paid);
        Price actuallyTipped = IngenicoHelper.stringToPrice(tip);
        if (!request.isReversal()) {
            actuallyTipped = actuallyTipped.add(txn.getTip());
        }
        Price actuallyCashedout = IngenicoHelper.stringToPrice(cashout);
        Price PADSurcharged = Price.ZERO_DOLLAR;
        if (!(StringUtils.isEmpty(purchaseAnalysisData) || Price.ZERO_DOLLAR.equals(PADPaid = IngenicoHelper.stringToPrice(IngenicoHelper.getPadData("AMT", purchaseAnalysisData))) || PADPaid.equals(txn.getPaid().add(actuallyTipped)))) {
            if (PADPaid.greaterThan(txn.getPaid().add(actuallyTipped))) {
                PADSurcharged = actuallySurcharged = PADPaid.subtract(txn.getPaid().add(actuallyTipped));
            }
            actuallyPaid = PADPaid.subtract(actuallyTipped);
        }
        if (actuallyPaid.subtract(PADSurcharged).equals(txn.getPaid().add(txn.getTip()))) {
            actuallyPaid = actuallyPaid.subtract(txn.getTip());
        }
        if (request.getTransaction().getPaid().lessThan(Price.ZERO_DOLLAR) ^ request.isReversal()) {
            actuallyPaid = actuallyPaid.negate();
            actuallyTipped = actuallyTipped.negate();
            actuallySurcharged = actuallySurcharged.negate();
        }
        EftposResult result = new EftposResult(request, eftStatus, cardType, actuallyPaid, actuallyTipped, actuallySurcharged, actuallyCashedout, termID, resText);
        return result;
    }

    static boolean isDeclined(String resText) {
        return resText.contains(DECLINED) || resText.contains(INCORRECT_PIN) || resText.contains(PIN_REQUIRED) || resText.contains(EXPIRED) || resText.contains(INVALID) || resText.contains(TIMEOUT) || resText.contains(ABORT);
    }

    static boolean isSuccessful(String success, String resText) {
        if (StringUtils.isEmpty(success) || StringUtils.isEmpty(resText)) {
            return false;
        }
        return success.equals("1") && (resText.contains(APPROVED) || resText.trim().equalsIgnoreCase(ACCEPTED) || resText.contains(SIGN_RECEIPT_ACCEPTED));
    }

    static final String prependHeader(String stringToBuild) {
        DecimalFormat DC = new DecimalFormat("0000");
        StringBuilder SB = new StringBuilder("#");
        SB.append(DC.format(5 + stringToBuild.length()));
        SB.append(stringToBuild);
        return SB.toString();
    }

    static String stripHeader(String toStrip) {
        if (toStrip == null || toStrip.length() < 6) {
            throw new IllegalArgumentException("Cannot strip header from String:" + toStrip);
        }
        return toStrip.substring(6);
    }

    static String getLastResponseInString(String response) {
        String[] responses = response.split("#");
        return responses[responses.length - 1];
    }

    static final String padString(int numSpaces, String value, char padWith) {
        StringBuilder SB = new StringBuilder();
        String toPad = "";
        if (value != null) {
            toPad = value;
        }
        for (int i = 0; i < numSpaces - toPad.length(); ++i) {
            SB.append(padWith);
        }
        SB.append(toPad);
        return SB.toString();
    }

    static final String priceToString(Price price) {
        if (price == null) {
            return priceToStringFormat.format(0L);
        }
        return priceToStringFormat.format(Math.abs(price.getNumCents()));
    }

    static final Price stringToPrice(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Price.ZERO_DOLLAR;
        }
        int cents = Integer.parseInt(value);
        return new Price((double)cents / 100.0, 0.01);
    }

    static boolean isTransactionResponse(String response) {
        return response.substring(5, 7).equals(REQUEST_TXN);
    }

    static boolean isLastTransactionResponse(String response) {
        return response.substring(5, 7).equals(REQUEST_LAST_TXN);
    }

    static boolean isReceiptResponse(String response) {
        if (response == null) {
            return false;
        }
        String code = IngenicoHelper.getCode(response);
        boolean isReceipt = code.equals(REQUEST_RECEIPT) || code.equals("C");
        return isReceipt;
    }

    static String createReceiptRequest(String response) {
        StringBuilder SB = new StringBuilder(REQUEST_RECEIPT);
        SB.append(" ");
        return IngenicoHelper.prependHeader(SB.toString());
    }

    static FinanceUnit interpretCardType(String accountType, String toAnalyse) {
        return IngenicoHelper.interpretCardType(accountType, toAnalyse, null);
    }

    static FinanceUnit interpretCardType(String accountType, String toAnalyse, String cardName) {
        if (toAnalyse == null || toAnalyse.equals("00")) {
            return null;
        }
        if (accountType.equals(CHEQUE_TYPE)) {
            return FinanceUnit.getUnitForName("Cheque Acc");
        }
        if (accountType.equals(SAVINGS_TYPE) || CARD_DEBIT.equals(toAnalyse)) {
            return FinanceUnit.getUnitForName("Savings Acc");
        }
        String nameOfUnit = null;
        if (accountType.equals(CREDIT_TYPE)) {
            if (CARD_VISA.equals(toAnalyse)) {
                nameOfUnit = "Visa";
            } else if (CARD_MASTERCARD.equals(toAnalyse)) {
                nameOfUnit = "Mastercard";
            } else if (CARD_BANKCARD.equals(toAnalyse)) {
                nameOfUnit = "Bankcard";
            } else if (CARD_DINERS.equals(toAnalyse)) {
                nameOfUnit = "Diners";
            } else if (CARD_AMEX.equals(toAnalyse)) {
                nameOfUnit = "Amex";
            } else if (CARD_JCB.equals(toAnalyse) || CARD_JCB_2.equals(toAnalyse) || CARD_JCB_3.equals(toAnalyse)) {
                nameOfUnit = "JCB";
            }
            if (nameOfUnit != null) {
                return FinanceUnit.getUnitForName(nameOfUnit);
            }
            if (cardName != null) {
                return FinanceUnit.getUnitForName(cardName);
            }
        }
        return null;
    }

    static String createPrintLastDocketRequest() {
        return IngenicoHelper.prependHeader(REQUEST_REPRINT_LAST);
    }

    static boolean isLastDocketPrinted(String readResponse) {
        String strip = IngenicoHelper.stripHeader(readResponse);
        return strip.substring(0, 3).equals("C 1");
    }

    static String decodeReceipt(String response) {
        if (!IngenicoHelper.isReceiptResponse(response) && !IngenicoHelper.getSubCode(response).equals(TXN_REFUND_CODE)) {
            return null;
        }
        String docket = null;
        int length = Integer.parseInt(response.substring(1, 5));
        docket = response.substring(7, length).trim();
        return docket;
    }

    static boolean isCustomerReceipt(String response) {
        return response.contains(RECEIPT_CUSTOMER);
    }

    private static String getCode(String response) {
        return response.substring(5, 6);
    }

    private static String getSubCode(String response) {
        return response.substring(6, 7);
    }

    static String createGetLastTransactionRequest() {
        return IngenicoHelper.prependHeader(LAST_TXN_REQUEST);
    }

    static String getLastTransactionReference(String response) {
        if (response != null) {
            try {
                return response.substring(90, 96);
            }
            catch (Exception ex) {
                OrderMateLog.LOG.warn("Bad data for last transaction from Ingenico.", (Throwable)ex);
            }
        }
        return null;
    }
}

