/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.linklycloud;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.linklycloud.LinklyAuthTokenRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyAuthTokenResponse;
import au.com.ordermate.xmlintegration.linklycloud.LinklyReceiptObject;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionResponse;
import java.util.List;
import java.util.UUID;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintReceiptType;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.SystemProperty;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.linklycloud.LinklyCloudHelper;
import ordermate.integration.eftpos.linklycloud.LinklyIntegrationProcessor;
import ordermate.integration.eftpos.linklycloud.LinklyRequestBuilder;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;

public class LinklyCloudEftpos
implements PhysicalEftpos {
    private final long BACKOFF_TIME = 1000L;
    private int BACKOFF_MULTI = 1;
    private final int BACKOFF_MULTI_MAX = 16;
    private VirtualEftpos vEft;
    private GuiHandler handler;

    public LinklyCloudEftpos(GuiHandler handler) {
        this.handler = handler;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.vEft = virtualEftpos;
    }

    @Override
    public void closeOff() {
    }

    public String createSessionKey(Long terminalId) {
        LinklyAuthTokenRequest r = new LinklyAuthTokenRequest();
        r.setSecret(this.vEft.getPairingKeys());
        r.setPosId(LinklyCloudHelper.generateUUIDFromSeed("OrderMate POS"));
        r.setPosName("OrderMate POS");
        r.setPosVendorId(LinklyCloudHelper.generateUUIDFromSeed(SystemProperty.getInstance().getStoreId() + "-" + terminalId.toString()));
        r.setPosVersion(OrderMate.VERSION);
        LinklyAuthTokenResponse res = LinklyIntegrationProcessor.getInstance().getAuthToken(r, this.vEft.isTesting());
        if (res != null) {
            return res.getToken();
        }
        return null;
    }

    private String createUUID() {
        return this.createUUID(false);
    }

    private String createUUID(boolean saveTovEft) {
        UUID uuid = UUID.randomUUID();
        String uuidAsString = uuid.toString();
        if (saveTovEft) {
            this.vEft.setLastTxnReference(uuidAsString);
            this.vEft.save();
        }
        return uuidAsString;
    }

    private boolean doLogon(String sessionToken) {
        LinklyTransactionRequest logonReq = LinklyRequestBuilder.createLogonRequest();
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().doTransaction(logonReq, sessionToken, this.createUUID(), this.vEft.isTesting(), "/logon?");
        return r.getResponse().isSuccess();
    }

    private boolean checkLoggedOn(String sessionToken) {
        LinklyTransactionRequest statusReq = LinklyRequestBuilder.createStatusRequest();
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().doTransaction(statusReq, sessionToken, this.createUUID(), this.vEft.isTesting(), "/status?");
        if (r == null) {
            return false;
        }
        if (!r.getResponse().isSuccess() || !r.getResponse().isLoggedOn()) {
            return this.doLogon(sessionToken);
        }
        return true;
    }

    public EftposResult generateError(EftposRequest request, LinklyTransactionResponse r) {
        if (r == null) {
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "No Response From Oolio, Please Confirm Settings and Connection");
        }
        return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, LinklyCloudHelper.buildResponseError(r));
    }

    public EftposResult generateUnknownError(EftposRequest request) {
        return new EftposResult(request, EftposStatus.UNKNOWN, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "Unknown Error Occured");
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        String sessionToken = this.createSessionKey(request.getTerminalToUse().getID());
        if (!this.checkLoggedOn(sessionToken)) {
            this.generateError(request, "Pinpad could not log in, check settings and that pinpad is online");
        }
        if (request.isReversal() || Price.ZERO_DOLLAR.greaterThan(request.getTransaction().getPaid())) {
            return this.doRefundFlow(request, sessionToken);
        }
        if (Price.ZERO_DOLLAR.equals(request.getTransaction().getPaid()) && !Price.ZERO_DOLLAR.equals(request.getTransaction().getCashOut())) {
            return this.doCashoutFlow(request, sessionToken);
        }
        return this.doPaymentFlow(request, sessionToken);
    }

    private EftposResult doRefundFlow(EftposRequest request, String sessionToken) {
        String session = this.createUUID(true);
        LinklyTransactionRequest txnReq = null;
        txnReq = request.isMoto() ? LinklyRequestBuilder.createRefundMOTORequest(request.getTransaction().getPaid().abs().getNumCents(), LinklyCloudHelper.getPrinting(this.vEft)) : LinklyRequestBuilder.createRefundRequest(request.getTransaction().getPaid().abs().getNumCents(), LinklyCloudHelper.getPrinting(this.vEft));
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().doTransaction(txnReq, sessionToken, session, this.vEft.isTesting(), "/transaction?");
        if (r == null || !r.getResponse().isSuccess()) {
            int status = LinklyCloudHelper.getTransactionStatus(LinklyIntegrationProcessor.getInstance().getLastStatusResponse());
            if (status == 0) {
                this.vEft.setLastTxnReference(null);
                return this.generateError(request, r);
            }
            if (status == 2) {
                this.startErrorHandle();
                r = this.handleErrorRecovery(session, sessionToken);
                if (r == null || !r.getResponse().isSuccess()) {
                    return this.generateError(request, r);
                }
            } else {
                if (status == 3) {
                    this.vEft.setLastTxnReference(null);
                    return this.generateUnknownError(request);
                }
                if (status == 1) {
                    this.vEft.setLastTxnReference(null);
                }
            }
        }
        if (!("00".equals(r.getResponse().getResponseCode()) || "08".equals(r.getResponse().getResponseCode()) || "16".equals(r.getResponse().getResponseCode()))) {
            return this.generateError(request, r);
        }
        this.callLastReceipt(r, request);
        return new EftposResult(request, EftposStatus.APPROVED, LinklyCloudHelper.getCardFromResponse(r), new Price((double)r.getResponse().getAmtPurchase() / 100.0, 0.01).negate(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, null);
    }

    private void startErrorHandle() {
        this.BACKOFF_MULTI = 1;
    }

    private void incrementErrorHandle() {
        this.BACKOFF_MULTI *= 2;
    }

    private void waitForErrorHandle() {
        try {
            Thread.sleep(1000L * (long)this.BACKOFF_MULTI);
        }
        catch (Exception ex) {
            OrderMate.LOG.error((Object)ex);
        }
    }

    private LinklyTransactionResponse handleErrorRecovery(String session, String sessionToken) {
        this.waitForErrorHandle();
        OrderMate.LOG.info("Attempting to recover transaction");
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().getTransaction(sessionToken, session, this.vEft.isTesting(), "/transaction?");
        int status = LinklyCloudHelper.getTransactionStatus(LinklyIntegrationProcessor.getInstance().getLastStatusResponse());
        if (status == 1 && r != null) {
            OrderMate.LOG.info("Transaction Recovered");
            return r;
        }
        if (status == 2 || status == 1 && r == null) {
            OrderMate.LOG.info("Transaction still under recovery");
            this.incrementErrorHandle();
            if (this.BACKOFF_MULTI > 16) {
                return null;
            }
            return this.handleErrorRecovery(session, sessionToken);
        }
        return null;
    }

    private EftposResult doCashoutFlow(EftposRequest request, String sessionToken) {
        String session = this.createUUID(true);
        LinklyTransactionRequest txnReq = LinklyRequestBuilder.createCashoutRequest(request.getTransaction().getCashOut().getNumCents(), LinklyCloudHelper.getPrinting(this.vEft));
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().doTransaction(txnReq, sessionToken, session, this.vEft.isTesting(), "/transaction?");
        if (r == null || !r.getResponse().isSuccess()) {
            int status = LinklyCloudHelper.getTransactionStatus(LinklyIntegrationProcessor.getInstance().getLastStatusResponse());
            if (status == 0) {
                this.vEft.setLastTxnReference(null);
                return this.generateError(request, r);
            }
            if (status == 2) {
                this.startErrorHandle();
                r = this.handleErrorRecovery(session, sessionToken);
                if (r == null || !r.getResponse().isSuccess()) {
                    return this.generateError(request, r);
                }
            } else {
                if (status == 3) {
                    this.vEft.setLastTxnReference(null);
                    return this.generateUnknownError(request);
                }
                if (status == 1) {
                    this.vEft.setLastTxnReference(null);
                }
            }
        }
        if (!("00".equals(r.getResponse().getResponseCode()) || "08".equals(r.getResponse().getResponseCode()) || "16".equals(r.getResponse().getResponseCode()))) {
            return this.generateError(request, r);
        }
        this.callLastReceipt(r, request);
        return new EftposResult(request, EftposStatus.APPROVED, LinklyCloudHelper.getCardFromResponse(r), LinklyCloudHelper.getTotalPaid(r), new Price((double)r.getResponse().getAmtTip() / 100.0, 0.01), LinklyCloudHelper.getSurchargeAmount(r), new Price((double)r.getResponse().getAmtCash() / 100.0, 0.01), null, null);
    }

    private LinklyTransactionResponse getTransactionStatus(String session, String sessionToken) {
        return LinklyIntegrationProcessor.getInstance().getTransaction(sessionToken, session, this.vEft.isTesting(), "/transaction?");
    }

    private void callLastReceipt(LinklyTransactionResponse res, EftposRequest req) {
        final LinklyReceiptObject[] receipts = res.getResponse().getReceipts();
        final EftposRequest request = req;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinklyCloudEftpos.this.doPrintLastReceipt(receipts, request, true, "Would you like to print the Eftpos Receipt?");
            }
        });
    }

    private void callInterruptedReceipt(LinklyTransactionResponse res, EftposRequest req) {
        final LinklyReceiptObject[] receipts = res.getResponse().getReceipts();
        final EftposRequest request = req;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinklyCloudEftpos.this.doPrintLastReceipt(receipts, request, false, "Last transaction not recorded in WaiterMate, would you like to reprint the receipt?");
            }
        });
    }

    private void doPrintLastReceipt(LinklyReceiptObject[] receipts, EftposRequest request, boolean allowNeverPrint, String displayMessage) {
        if (allowNeverPrint && EftposPrintReceiptType.NEVER_PRINT.equals(this.vEft.getPrintReceiptType())) {
            return;
        }
        if ((EftposPrintReceiptType.ASK_BEFORE_PRINTING.equals(this.vEft.getPrintReceiptType()) || EftposPrintReceiptType.NEVER_PRINT.equals(this.vEft.getPrintReceiptType()) && !allowNeverPrint) && !this.handler.displayForcedChoiceDialog(displayMessage, "Print Receipts", "Yes", "No")) {
            return;
        }
        final EftposTransaction txn = request != null ? request.getTransaction() : null;
        final LinklyReceiptObject[] rObjList = receipts;
        try {
            Thread getReceiptThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (LinklyReceiptObject rObj : rObjList) {
                            String receiptData = null;
                            if (rObj == null || rObj.getReceiptText() == null) continue;
                            receiptData = LinklyCloudHelper.getReceiptAsString(rObj.getReceiptText());
                            DocketProcessor.printEftposDocket(receiptData, Terminal.getLocalHost().getAvailableReceiptPrinters(), txn, false);
                        }
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Error printing linkly cloud receipt", (Throwable)ex);
                    }
                }
            });
            getReceiptThread.start();
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage());
        }
    }

    private EftposResult doPaymentFlow(EftposRequest request, String sessionToken) {
        String session = this.createUUID(true);
        LinklyTransactionRequest txnReq = request.isMoto() ? LinklyRequestBuilder.createPurchaseMOTORequest(request.getTransaction().getPaid().getNumCents(), request.getTransaction().getTip().getNumCents(), request.getTransaction().getCashOut().getNumCents(), this.vEft.isEnableTip(), LinklyCloudHelper.getPrinting(this.vEft)) : LinklyRequestBuilder.createPurchaseRequest(request.getTransaction().getPaid().getNumCents(), request.getTransaction().getTip().getNumCents(), request.getTransaction().getCashOut().getNumCents(), this.vEft.isEnableTip(), LinklyCloudHelper.getPrinting(this.vEft));
        LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().doTransaction(txnReq, sessionToken, session, this.vEft.isTesting(), "/transaction?");
        if (r == null || !r.getResponse().isSuccess()) {
            int status = LinklyCloudHelper.getTransactionStatus(LinklyIntegrationProcessor.getInstance().getLastStatusResponse());
            if (status == 0) {
                this.vEft.setLastTxnReference(null);
                return this.generateError(request, r);
            }
            if (status == 2) {
                this.startErrorHandle();
                r = this.handleErrorRecovery(session, sessionToken);
                if (r == null || !r.getResponse().isSuccess()) {
                    return this.generateError(request, r);
                }
            } else {
                if (status == 3) {
                    this.vEft.setLastTxnReference(null);
                    return this.generateUnknownError(request);
                }
                if (status == 1) {
                    this.vEft.setLastTxnReference(null);
                }
            }
        }
        if (!("00".equals(r.getResponse().getResponseCode()) || "08".equals(r.getResponse().getResponseCode()) || "16".equals(r.getResponse().getResponseCode()))) {
            return this.generateError(request, r);
        }
        request.getTransaction().setTransactionReference(r.getResponse().getTxnRef());
        this.callLastReceipt(r, request);
        return new EftposResult(request, EftposStatus.APPROVED, LinklyCloudHelper.getCardFromResponse(r), LinklyCloudHelper.getTotalPaid(r), new Price((double)r.getResponse().getAmtTip() / 100.0, 0.01), LinklyCloudHelper.getSurchargeAmount(r), new Price((double)r.getResponse().getAmtCash() / 100.0, 0.01), null, null);
    }

    public EftposResult generateError(EftposRequest request, String errorMsg) {
        return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, errorMsg);
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        return this.vEft.getTerminalId();
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public boolean supportsBlocking() {
        return false;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public boolean supportsMOTO() {
        return true;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
        if (this.vEft.getLastTxnReference() != null) {
            FinanceTransaction txn;
            String sessionToken = this.createSessionKey(this.vEft.getID());
            LinklyTransactionResponse r = LinklyIntegrationProcessor.getInstance().getTransaction(sessionToken, this.vEft.getLastTxnReference(), this.vEft.isTesting(), "/transaction?");
            int status = LinklyCloudHelper.getTransactionStatus(LinklyIntegrationProcessor.getInstance().getLastStatusResponse());
            if (status == 1 && r != null && r.getResponse() != null && (txn = PersistenceManager.getObject(FinanceTransaction.class, Query.select(FinanceTransaction.class).equals(FinanceTransaction.Properties.TRANSACTION_REFERENCE, r.getResponse().getTxnRef()).toString())) == null) {
                this.callInterruptedReceipt(r, null);
            }
        }
    }

    @Override
    public String clearInterruptedTransactions() {
        this.vEft.setLastTxnReference(null);
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }
}

