/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.linklycloud;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairResponse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.eftpos.linklycloud.LinklyIntegrationProcessor;
import ordermate.integration.eftpos.linklycloud.LinklyRequestBuilder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class LinklyCloudEftposPairingPanel
extends JPanel
implements ActionListener {
    private JTextField pairCodeField;
    private final VirtualEftpos eftpos;
    private JButton pairButton;
    private GuiHandler ui;
    Signal cancelSignal = Signals.createSignal();

    LinklyCloudEftposPairingPanel(VirtualEftpos context, GuiHandler ui) {
        this.ui = ui;
        this.setupComponents();
        this.eftpos = context;
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.pairCodeField = new JTextField(10);
        this.pairCodeField.setName("");
        this.pairCodeField.setEditable(true);
        builder.addRow("Pairing Code", (Component)this.pairCodeField);
        this.pairButton = new JButton("Perform Pair");
        this.pairButton.setVisible(true);
        this.pairButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.pairButton);
        buttonPanel.setAlignmentX(1.0f);
        builder.addRow(buttonPanel);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.pairButton) {
            if (this.eftpos.getPairUsername() == null || this.eftpos.getPairPassword() == null) {
                this.ui.displayErrorDialog("Pairing Not Allowed", "Please Confirm User + Pwd Settings In EFTPOS Settings", "");
            }
            LinklyPairRequest pReq = LinklyRequestBuilder.createPairRequest(this.eftpos.getPairUsername(), this.eftpos.getPairPassword(), this.pairCodeField.getText());
            LinklyPairResponse res = LinklyIntegrationProcessor.getInstance().doPair(pReq, this.eftpos.isTesting());
            if (res != null && !StringUtils.isEmpty(res.getSecret())) {
                this.eftpos.setPairingKeys(res.getSecret());
                this.eftpos.save();
            } else {
                this.ui.displayErrorDialog("Pairing Failed", "Pairing Failed, please confirm all details are correct", "");
            }
            JComponent comp = (JComponent)event.getSource();
            Window win = SwingUtilities.getWindowAncestor(comp);
            win.dispose();
        }
    }
}

