/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.linklycloud;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPADObject;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionResponse;
import java.util.UUID;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.VirtualEftpos;

public class LinklyCloudHelper {
    public static final String RC_APPROVED = "00";
    public static final String RC_APPROVED_SIGNATURE = "08";
    public static final String RC_APPROVED_TRACK_3 = "16";
    public static final String RC_SYSTEM_ERROR_1 = "78";
    public static final String RC_SYSTEM_ERROR_2 = "79";
    public static final String RC_SYSTEM_ERROR_3 = "X2";
    public static final String RC_ALREADY_SETTLED = "97";
    public static final String RC_PRINTER_ERROR = "B1";
    public static final String RC_PINPAD_BUSY_1 = "BB";
    public static final String RC_PINPAD_BUSY_2 = "BY";
    public static final String RC_PINPAD_BUSY_ANZ = "ZB";
    public static final String RC_SERVER_ERROR = "N8";
    public static final String RC_COMMS_ERROR = "P7";
    public static final String RC_PINPAD_OFFLINE = "PF";
    public static final String RC_MODEM_ERROR_1 = "S0";
    public static final String RC_MODEM_ERROR_2 = "Z0";
    public static final String RC_NO_EFT_SERVER_1 = "S7";
    public static final String RC_NO_EFT_SERVER_2 = "S8";
    public static final String RC_TMS_REQUIRED = "TB";
    public static final String RC_INIT_REQUIRED = "TF";
    public static final String RC_OPERATOR_TIMEOUT = "TI";
    public static final String RC_OPERATOR_CANCELLED = "TM";
    public static final String RC_UNABLE_TO_PROCESS = "TX";
    public static final String RC_NO_RESPONSE_1 = "X0";
    public static final String RC_NO_RESPONSE_2 = "X0J";
    public static final String RC_TXN_NOT_SUPPORTED = "XG";
    public static final String RC_CONFIG_REQUIRED = "XT";
    public static final String RC_POWER_FAIL = "ZF";
    public static final int HTTP_RC_APPROVED = 200;
    public static final int HTTP_RC_TRANSACTION_IN_PROGRESS = 202;
    public static final int HTTP_RC_INVALID_REQUEST = 400;
    public static final int HTTP_RC_UNAUTHORISED = 401;
    public static final int HTTP_RC_URI_NOT_FOUND = 404;
    public static final int HTTP_RC_TRANSIENT_ERROR = 408;
    public static final int HTTP_RC_SERVER_ERROR_MIN = 500;
    public static final int HTTP_RC_SERVER_ERROR_MAX = 500;
    public static final int STATUS_RESPONSE_FAILED = 0;
    public static final int STATUS_RESPONSE_SUCCESS = 1;
    public static final int STATUS_RESPONSE_RECOVERY = 2;
    public static final int STATUS_RESPONSE_UNKNOWN = 3;

    public static String buildResponseError(LinklyTransactionResponse r) {
        return "Message from Oolio: " + r.getResponse().getResponseCode() + " - " + r.getResponse().getResponseText();
    }

    public static String generateUUIDFromSeed(String seed) {
        String result = UUID.nameUUIDFromBytes(seed.getBytes()).toString();
        return result;
    }

    public static LinklyPADObject addSurchargeData(long amt) {
        return LinklyCloudHelper.addSurchargeData(amt, null);
    }

    public static LinklyPADObject addSurchargeData(long amt, LinklyPADObject d) {
        if (d == null) {
            d = new LinklyPADObject();
        }
        if (amt != 0L) {
            d.setSur(String.valueOf(amt));
        }
        return d;
    }

    public static int getTransactionStatus(int status) {
        if (status == 200 || status == 202 || status / 100 == 2) {
            return 1;
        }
        if (status == 401 || status == 400 || status == 404) {
            return 0;
        }
        if (status == 408 || status >= 500 && status <= 500) {
            return 2;
        }
        return 3;
    }

    public static String getReceiptAsString(String[] r) {
        String lineData = "";
        for (String i : r) {
            lineData = lineData + i + "\n";
        }
        return lineData;
    }

    public static LinklyPADObject addTippingData(long amt, boolean enableTip) {
        return LinklyCloudHelper.addTippingData(amt, null, enableTip);
    }

    public static LinklyPADObject addTippingData(long amt, LinklyPADObject d, boolean enableTip) {
        if (d == null) {
            d = new LinklyPADObject();
        }
        if (amt != 0L || enableTip) {
            d.setTip(String.valueOf(amt));
        }
        return d;
    }

    private static boolean hasPad(LinklyTransactionResponse r) {
        return r.getResponse().getPurchaseAnalysisData() != null;
    }

    public static Price getSurchargeAmount(LinklyTransactionResponse r) {
        if (r == null) {
            return Price.ZERO_DOLLAR;
        }
        if (!LinklyCloudHelper.hasPad(r) || StringUtils.isEmpty(r.getResponse().getPurchaseAnalysisData().getSur())) {
            return Price.ZERO_DOLLAR;
        }
        return new Price((double)Long.valueOf(r.getResponse().getPurchaseAnalysisData().getSur()).longValue() / 100.0, 0.01);
    }

    public static Price getTotalPaid(LinklyTransactionResponse r) {
        if (r == null) {
            return Price.ZERO_DOLLAR;
        }
        if (!LinklyCloudHelper.hasPad(r) || StringUtils.isEmpty(r.getResponse().getPurchaseAnalysisData().getAmt())) {
            return new Price((double)r.getResponse().getAmtPurchase() / 100.0, 0.01);
        }
        Long amtPur = Long.valueOf(r.getResponse().getPurchaseAnalysisData().getAmt()) - r.getResponse().getAmtTip() - r.getResponse().getAmtCash();
        return new Price((double)amtPur.longValue() / 100.0, 0.01);
    }

    public static FinanceUnit getCardFromResponse(LinklyTransactionResponse r) {
        if (r == null || r.getResponse() == null) {
            return null;
        }
        String cardBin = r.getResponse().getCardName();
        if (cardBin == null) {
            return null;
        }
        if (cardBin.equals("01")) {
            return FinanceUnit.getUnitForName("Savings Acc");
        }
        if (cardBin.equals("02")) {
            return FinanceUnit.getUnitForName("Bankcard");
        }
        if (cardBin.equals("03")) {
            return FinanceUnit.getUnitForName("Mastercard");
        }
        if (cardBin.equals("04")) {
            return FinanceUnit.getUnitForName("Visa");
        }
        if (cardBin.equals("05")) {
            return FinanceUnit.getUnitForName("Amex");
        }
        if (cardBin.equals("06")) {
            return FinanceUnit.getUnitForName("Diners");
        }
        if (cardBin.equals("07") || cardBin.equals("09") || cardBin.equals("11")) {
            return FinanceUnit.getUnitForName("JCB");
        }
        return FinanceUnit.getActiveDebitUnits().get(0);
    }

    public static String getPrinting(VirtualEftpos vEft) {
        if (vEft.isPrintReceipts()) {
            return "9";
        }
        return "0";
    }
}

