/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.linklycloud;

import au.com.ordermate.xmlintegration.linklycloud.LinklyAuthTokenRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyAuthTokenResponse;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairResponse;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.integration.eftpos.adyen.AdyenMarshaller;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class LinklyIntegrationProcessor {
    private static LinklyIntegrationProcessor instance;
    private int lastStatusResponse = 0;
    private final String LINKLY_ENDPOINT = "https://rest.pos.cloud.pceftpos.com/v1/sessions";
    private final String LINKLY_ENDPOINT_SANDBOX = "https://rest.pos.sandbox.cloud.pceftpos.com/v1/sessions";
    private final String LINKLY_AUTH_ENDPOINT = "https://auth.cloud.pceftpos.com/v1";
    private final String LINKLY_AUTH_ENDPOINT_SANDBOX = "https://auth.sandbox.cloud.pceftpos.com/v1";
    private static final String AUTH_ENDPOINT = "/tokens/cloudpos";
    private static final String PAIR_ENDPOINT = "/pairing/cloudpos";
    private static final String ASYNC = "async=false";
    public static final String TRANSACTION_TYPE = "/transaction?";
    public static final String LOGON_TYPE = "/logon?";
    public static final String SETTLEMENT_TYPE = "/settlement?";
    public static final String STATUS_TYPE = "/status?";
    public static final String QUERYCARD_TYPE = "/querycard?";
    public static final String CONFIGUREMERCHANT_TYPE = "/configuremerchant?";
    public static final String REPRINTRECEIPT_TYPE = "/reprintreceipt?";
    public static final String SENDKEYN_TYPE = "/sendkey?";
    public static final Integer TIMEOUT_LENGTH;

    public static LinklyIntegrationProcessor getInstance() {
        if (instance == null) {
            instance = new LinklyIntegrationProcessor();
        }
        return instance;
    }

    public static void setInstance(LinklyIntegrationProcessor newInstance) {
        instance = newInstance;
    }

    private static WebResource.Builder createBuilder(String uri) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT_LENGTH, TIMEOUT_LENGTH, "TLSv1.2");
        return (WebResource.Builder)resource.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json");
    }

    private static WebResource.Builder createBuilderWithAuth(String uri, String token) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT_LENGTH, TIMEOUT_LENGTH, "TLSv1.2");
        return (WebResource.Builder)((WebResource.Builder)resource.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).header("Authorization", (Object)("Bearer " + token));
    }

    private static WebResource.Builder createBuilderWithAuthShortTimeout(String uri, String token) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), 9000, 9000, "TLSv1.2");
        return (WebResource.Builder)((WebResource.Builder)resource.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json")).header("Authorization", (Object)("Bearer " + token));
    }

    public LinklyPairResponse doPair(LinklyPairRequest req, boolean isTesting) {
        try {
            WebResource.Builder builder = LinklyIntegrationProcessor.createBuilder(this.getLinklyAuthEndpoint(isTesting) + PAIR_ENDPOINT);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Oolio Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            this.lastStatusResponse = response.getStatus();
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Pair Response From Linkly Cloud:\n" + r);
            ObjectMapper mapper = new ObjectMapper();
            return (LinklyPairResponse)mapper.readValue(r, (TypeReference)new TypeReference<LinklyPairResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public LinklyAuthTokenResponse getAuthToken(LinklyAuthTokenRequest req, boolean isTesting) {
        try {
            WebResource.Builder builder = LinklyIntegrationProcessor.createBuilder(this.getLinklyAuthEndpoint(isTesting) + AUTH_ENDPOINT);
            String request = new AdyenMarshaller().marshal(req);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            this.lastStatusResponse = response.getStatus();
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Auth Response From Linkly Cloud:\n" + r);
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (LinklyAuthTokenResponse)mapper.readValue(r, (TypeReference)new TypeReference<LinklyAuthTokenResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public LinklyTransactionResponse doTransaction(LinklyTransactionRequest req, String secret, String session, boolean isTesting, String TxnType) {
        try {
            WebResource.Builder builder = LinklyIntegrationProcessor.createBuilderWithAuth(this.getLinklyEndpoint(isTesting) + "/" + session + TxnType + ASYNC, secret);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Linkly Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            this.lastStatusResponse = response.getStatus();
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Transaction Response From Linkly Cloud:\n" + r);
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (LinklyTransactionResponse)mapper.readValue(r, (TypeReference)new TypeReference<LinklyTransactionResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public LinklyTransactionResponse doTransactionFail(LinklyTransactionRequest req, String secret, String session, boolean isTesting, String TxnType) {
        try {
            WebResource.Builder builder = LinklyIntegrationProcessor.createBuilderWithAuthShortTimeout(this.getLinklyEndpoint(isTesting) + "/" + session + TxnType + ASYNC, secret);
            String request = new AdyenMarshaller().marshal(req);
            OrderMate.LOG.info("Sending Linkly Request:\n" + request);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)request);
            this.lastStatusResponse = response.getStatus();
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Transaction Response From Linkly Cloud:\n" + r);
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (LinklyTransactionResponse)mapper.readValue(r, (TypeReference)new TypeReference<LinklyTransactionResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            this.lastStatusResponse = 408;
            return null;
        }
    }

    public LinklyTransactionResponse getTransaction(String secret, String session, boolean isTesting, String TxnType) {
        try {
            WebResource.Builder builder = LinklyIntegrationProcessor.createBuilderWithAuth(this.getLinklyEndpoint(isTesting) + "/" + session + TxnType + ASYNC, secret);
            OrderMate.LOG.info("Sending Request To Get Transaction Status:\n");
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            this.lastStatusResponse = response.getStatus();
            if (response.getStatus() / 100 != 2) {
                OrderMate.LOG.error("Did not return 200 from Oolio, error was " + response.getStatus());
            }
            String r = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Transaction Response From Linkly Cloud:\n" + r);
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (LinklyTransactionResponse)mapper.readValue(r, (TypeReference)new TypeReference<LinklyTransactionResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Oolio Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public int getLastStatusResponse() {
        return this.lastStatusResponse;
    }

    public String getLinklyEndpoint(boolean isTesting) {
        return isTesting ? "https://rest.pos.sandbox.cloud.pceftpos.com/v1/sessions" : "https://rest.pos.cloud.pceftpos.com/v1/sessions";
    }

    public String getLinklyAuthEndpoint(boolean isTesting) {
        return isTesting ? "https://auth.sandbox.cloud.pceftpos.com/v1" : "https://auth.cloud.pceftpos.com/v1";
    }

    static {
        TIMEOUT_LENGTH = 90000;
    }
}

