/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.linklycloud;

import au.com.ordermate.xmlintegration.linklycloud.LinklyPADObject;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyTransactionRequestObject;
import ordermate.integration.eftpos.linklycloud.LinklyCloudHelper;

public class LinklyRequestBuilder {
    private static String CARD_APPLICATION = "00";

    private static String createTxnRef() {
        Long unixTime = System.currentTimeMillis();
        if (unixTime.toString().length() > 10) {
            return unixTime.toString().substring(unixTime.toString().length() - 10);
        }
        return unixTime.toString();
    }

    public static LinklyTransactionRequest createPurchaseRequest(long amtPurchase) {
        return LinklyRequestBuilder.createPurchaseRequest(amtPurchase, 0L, 0L, false, "0");
    }

    public static LinklyTransactionRequest createCashoutRequest(long amtCash, String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setTxnType("C");
        reqObj.setTxnRef(LinklyRequestBuilder.createTxnRef());
        reqObj.setAmtCash(amtCash);
        reqObj.setReceiptAutoPrint(receiptType);
        reqObj.setApplication(CARD_APPLICATION);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createPurchaseRequest(long amtPurchase, long amtTip, long amtCash, boolean tipEnabled, String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setTxnType("P");
        reqObj.setAmtPurchase(amtPurchase);
        reqObj.setTxnRef(LinklyRequestBuilder.createTxnRef());
        reqObj.setEnableTip(tipEnabled || amtTip > 0L);
        reqObj.setAmtCash(amtCash);
        reqObj.setApplication(CARD_APPLICATION);
        reqObj.setReceiptAutoPrint(receiptType);
        LinklyPADObject padObj = LinklyCloudHelper.addTippingData(amtTip, tipEnabled);
        reqObj.setPurchaseAnalysisData(padObj);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createPurchaseMOTORequest(long amtPurchase, long amtTip, long amtCash, boolean tipEnabled, String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setTxnType("P");
        reqObj.setAmtPurchase(amtPurchase);
        reqObj.setTxnRef(LinklyRequestBuilder.createTxnRef());
        reqObj.setEnableTip(tipEnabled || amtTip > 0L);
        reqObj.setAmtCash(amtCash);
        reqObj.setApplication(CARD_APPLICATION);
        reqObj.setReceiptAutoPrint(receiptType);
        reqObj.setPanSource("K");
        LinklyPADObject padObj = LinklyCloudHelper.addTippingData(amtTip, tipEnabled);
        reqObj.setPurchaseAnalysisData(padObj);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createRefundRequest(long amtRefunded, String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setTxnType("R");
        reqObj.setReceiptAutoPrint(receiptType);
        reqObj.setAmtPurchase(amtRefunded);
        reqObj.setTxnRef(LinklyRequestBuilder.createTxnRef());
        reqObj.setApplication(CARD_APPLICATION);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createRefundMOTORequest(long amtRefunded, String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setTxnType("R");
        reqObj.setReceiptAutoPrint(receiptType);
        reqObj.setPanSource("K");
        reqObj.setAmtPurchase(amtRefunded);
        reqObj.setTxnRef(LinklyRequestBuilder.createTxnRef());
        reqObj.setApplication(CARD_APPLICATION);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createStatusRequest() {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setStatusType("0");
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createStatusRequest(String receiptType) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setStatusType("0");
        reqObj.setReceiptAutoPrint(receiptType);
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createReprintReceiptRequest(String txnRef) {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setReceiptAutoPrint("0");
        reqObj.setReprintType("2");
        reqObj.setSubCode("2");
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyTransactionRequest createLogonRequest() {
        LinklyTransactionRequest txnReq = new LinklyTransactionRequest();
        LinklyTransactionRequestObject reqObj = new LinklyTransactionRequestObject();
        reqObj.setLogonType(" ");
        txnReq.setRequest(reqObj);
        return txnReq;
    }

    public static LinklyPairRequest createPairRequest(String username, String password, String paircode) {
        LinklyPairRequest pReq = new LinklyPairRequest();
        pReq.setPaircode(paircode);
        pReq.setUsername(username);
        pReq.setPassword(password);
        return pReq;
    }
}

