/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.manager;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DefaultIntegratedPaymentUI
implements IntegratedPaymentUI {
    private Signal<String, ?, ?, ?, ?> option = Signals.createSignal(String.class, "option");
    private Signal<?, ?, ?, ?, ?> cancel = Signals.createSignal();
    private IntegratedPaymentUI.FeedbackStatus currentStatus = IntegratedPaymentUI.FeedbackStatus.PROGRESS;
    private GuiHandler handler;
    private boolean isDark = false;
    private PaymentSwingPanel myPanel;

    public DefaultIntegratedPaymentUI(final GuiHandler handler) {
        this.handler = handler;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultIntegratedPaymentUI.this.myPanel = new PaymentSwingPanel(handler.isDarkLaf());
            }
        });
    }

    @Override
    public void setHeaderText(String value) {
        this.myPanel.setHeaderText(value);
    }

    @Override
    public void setMessage(String value, IntegratedPaymentUI.FeedbackStatus status) {
        String icon = null;
        icon = this.isDark ? status.iconDarkLoc : status.iconLoc;
        this.myPanel.setMessage(value, icon);
    }

    @Override
    public void setQuestion(String question, List<String> availOptions) {
        this.myPanel.setOptions(question, availOptions);
        this.setMessage(question, IntegratedPaymentUI.FeedbackStatus.WARNING);
    }

    @Override
    public void setButtonsEnabled(final boolean value) {
        this.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                DefaultIntegratedPaymentUI.this.myPanel.enableButtons(value);
            }
        });
    }

    @Override
    public void setCancelEnabled(final boolean value) {
        this.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                DefaultIntegratedPaymentUI.this.myPanel.enableCancel(value);
            }
        });
    }

    @Override
    public void setCancelVisible(final boolean value) {
        this.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                DefaultIntegratedPaymentUI.this.myPanel.visibleCancel(value);
            }
        });
    }

    private void invokeOnEdt(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public Signal<String, ?, ?, ?, ?> getOptionSignal() {
        return this.option;
    }

    @Override
    public Signal<?, ?, ?, ?, ?> getCancelSignal() {
        return this.cancel;
    }

    @Override
    public void displayBlockingInterface() {
        this.handler.displayBlockingDialog(this.myPanel);
    }

    @Override
    public void refreshBlockingInterface() {
        this.handler.refreshBlockingDialog(this.myPanel);
    }

    @Override
    public void closeBlockingInterface() {
        this.handler.closeBlockingDialog(this.myPanel);
    }

    class PaymentSwingPanel
    extends JPanel
    implements ActionListener {
        private JLabel headerLabel;
        private JLabel messageLabel;
        private JPanel buttonPanel;
        private JPanel bottomHolder;
        private JButton cancelButton;
        private List<String> options;
        private List<JButton> optionButtons;
        private boolean isDark;

        PaymentSwingPanel(boolean dark) {
            super(new BorderLayout());
            this.isDark = dark;
            this.setPreferredSize(new Dimension(720, 260));
            if (SwingUtilities.isEventDispatchThread()) {
                this.setupComponents();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaymentSwingPanel.this.setupComponents();
                    }
                });
            }
        }

        public void setHeaderText(String value) {
            this.headerLabel.setText(value);
        }

        private void setupComponents() {
            this.headerLabel = new JLabel();
            this.headerLabel.setIcon(IconLoader.get(this.isDark ? IntegratedPaymentUI.FeedbackStatus.PROGRESS.iconDarkLoc : IntegratedPaymentUI.FeedbackStatus.PROGRESS.iconLoc));
            this.messageLabel = new JLabel();
            JPanel middleHolder = new JPanel(new FlowLayout());
            middleHolder.add(this.messageLabel);
            this.messageLabel.setFont(OrderMateTheme.getLargeFont());
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bottomHolder = new JPanel(new BorderLayout());
            this.cancelButton = new JButton("Cancel");
            this.bottomHolder.add((Component)this.cancelButton, "West");
            this.cancelButton.setIcon(IconLoader.get("/ordermate/images/delete_icon32.png"));
            this.cancelButton.setPreferredSize(new Dimension(120, 60));
            this.bottomHolder.add((Component)this.buttonPanel, "Center");
            this.cancelButton.addActionListener(this);
            this.add((Component)this.headerLabel, "North");
            this.add((Component)middleHolder, "Center");
            this.add((Component)this.bottomHolder, "South");
        }

        void setMessage(String text, String headerIcon) {
            this.messageLabel.setText(text);
            if (headerIcon != null) {
                this.headerLabel.setIcon(IconLoader.get(headerIcon));
                this.headerLabel.validate();
            } else {
                this.headerLabel.setIcon(null);
                this.headerLabel.validate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOptions(final String question, final List<String> availOptions) {
            if (this.optionButtons != null) {
                List<JButton> list = this.optionButtons;
                synchronized (list) {
                    for (JButton button : this.optionButtons) {
                        button.removeActionListener(this);
                        this.buttonPanel.remove(button);
                    }
                    this.optionButtons.clear();
                }
            }
            this.options = availOptions;
            if (question != null && this.options != null) {
                this.optionButtons = new ArrayList<JButton>(this.options.size());
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            PaymentSwingPanel.this.buttonPanel.removeAll();
                            for (String nextOption : PaymentSwingPanel.this.options) {
                                JButton button = new JButton(nextOption);
                                OrderMateTheme.setupTouchScreenButton(button);
                                button.addActionListener(PaymentSwingPanel.this);
                                button.setPreferredSize(new Dimension(120, 60));
                                PaymentSwingPanel.this.optionButtons.add(button);
                                PaymentSwingPanel.this.buttonPanel.add(button);
                            }
                            PaymentSwingPanel.this.buttonPanel.validate();
                            PaymentSwingPanel.this.bottomHolder.validate();
                            PaymentSwingPanel.this.validate();
                            PaymentSwingPanel.this.repaint();
                            if (question != null && availOptions != null) {
                                DefaultIntegratedPaymentUI.this.setButtonsEnabled(true);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    OrderMate.LOG.error("Error on Payments Panel", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    OrderMate.LOG.error("Error on Payments Panel", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enableButtons(boolean value) {
            this.cancelButton.setEnabled(value);
            if (this.optionButtons != null) {
                ArrayList<JButton> ops;
                List<JButton> list = this.optionButtons;
                synchronized (list) {
                    ops = new ArrayList<JButton>(this.optionButtons);
                }
                for (JButton button : ops) {
                    button.setEnabled(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enableButtons(boolean value, boolean cancelValue) {
            this.cancelButton.setEnabled(cancelValue);
            if (this.optionButtons != null) {
                ArrayList<JButton> ops;
                List<JButton> list = this.optionButtons;
                synchronized (list) {
                    ops = new ArrayList<JButton>(this.optionButtons);
                }
                for (JButton button : ops) {
                    button.setEnabled(value);
                }
            }
        }

        void enableCancel(boolean value) {
            this.cancelButton.setEnabled(value);
        }

        void visibleCancel(boolean value) {
            this.cancelButton.setVisible(value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.cancelButton) {
                this.enableButtons(false);
                DefaultIntegratedPaymentUI.this.cancel.emit();
            } else if (this.optionButtons != null && this.optionButtons.size() > 0) {
                String theOption = null;
                for (int i = 0; i < this.optionButtons.size(); ++i) {
                    if (source != this.optionButtons.get(i)) continue;
                    this.optionButtons.get(i).setEnabled(false);
                    theOption = this.options.get(i);
                }
                if (DefaultIntegratedPaymentUI.this.option != null) {
                    OrderMate.LOG.info("actionPerformed - " + DefaultIntegratedPaymentUI.this.option);
                    this.enableButtons(false, true);
                    DefaultIntegratedPaymentUI.this.option.emit(theOption);
                }
            }
        }
    }
}

