/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.manager;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.MOTOTransaction;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.PreauthTransactionHelper;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.eftpos.WebPaymentRequest;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.users.User;
import ordermate.integration.eftpos.EftposLogger;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.PhysicalEftposFactory;
import ordermate.integration.eftpos.manager.EftposResolver;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.EftposUnknownResponseHandler;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.internationalization.Internationalization;

public class EftposManager {
    private static EftposManager instance;
    private final EftposToolkit toolkit;
    private EftposResolver resolver;

    public EftposManager(EftposToolkit yourToolkit) {
        this.toolkit = yourToolkit;
        this.resolver = new EftposResolver();
    }

    public static final synchronized void init(EftposToolkit toolkit) {
        instance = new EftposManager(toolkit);
    }

    public static final synchronized EftposManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Cannot call getInstance before init has been called");
        }
        return instance;
    }

    public EftposToolkit getToolkit() {
        return this.toolkit;
    }

    public final EftposResult performTransaction(EftposRequest request) {
        EftposResult result = null;
        VirtualEftpos vEft = this.resolver.getEftposForRequest(request);
        if (vEft == null && !StringUtils.isEmpty(request.getTransaction().getTransactionReference())) {
            vEft = request.getTransaction().getVirtualEftpos();
        }
        request.getTransaction().setVirtualEftpos(vEft);
        this.resolver.getEftposForRequest(request);
        if (vEft != null && !PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled) && !(request instanceof WebPaymentRequest)) {
            OrderMateLog.LOG.warn("Virtual Eftpos has been created, but it's not licensed. Performing offline eftpos.");
            vEft = null;
        }
        if (vEft != null && request.isReversal() && request.getTransaction().getTransactionReference() == null) {
            OrderMateLog.LOG.info("Original Transaction was offline. Reverse cannot be performed online.");
            if (this.toolkit != null && this.toolkit.getGuiHandler() != null) {
                this.toolkit.getGuiHandler().displayOkDialog("Refunding Offline", "The original transaction was performed offline. The refund will also be performed offline");
            }
            vEft = null;
        }
        if (vEft != null && !SystemState.ACTIVE_STATE.equals(vEft.getSystemState())) {
            OrderMate.LOG.warn("Virtual Eftpos " + vEft + " is not active, will not use");
            vEft = null;
        }
        if (vEft != null && vEft.isOnline()) {
            PhysicalEftpos pEft = this.getPhysicalEftpos(vEft);
            if (this.canProcess(pEft, request, vEft)) {
                try {
                    result = this.processTransactionRequest(pEft, vEft, request);
                    OrderMateLog.LOG.info("Transaction Result: " + result);
                }
                catch (Exception ex) {
                    OrderMateLog.LOG.error("Problem while Processing Eftpos Transaction.", (Throwable)ex);
                }
                if (result != null && EftposStatus.UNKNOWN.equals(result.getEftposStatus())) {
                    String responseCode = result.getExplicitError();
                    if (responseCode == null) {
                        responseCode = "<No Response>";
                    }
                    EftposUnknownResponseHandler handler = new EftposUnknownResponseHandler(this.toolkit, responseCode);
                    boolean shouldAccept = handler.warnAndPromptForUserInstruction();
                    User user = result.getRequest().getTransaction().getUser();
                    Terminal terminal = result.getRequest().getTransaction().getTerminal();
                    String toLog = "";
                    if (shouldAccept) {
                        result = new EftposResult(request, EftposStatus.APPROVED, result.getCardType(), result.getActualPaid(), result.getActualTip(), result.getActualSurcharge(), result.getActualCashout(), result.getTerminalID(), result.getExplicitError());
                        toLog = "User " + user + " accepted the payment in response to the unknown PC-EFTPOS response of \"" + result.getExplicitError() + "\"";
                    } else {
                        result = new EftposResult(request, EftposStatus.ERROR, request.getTransaction().getSubType(), null, null, null, null, null);
                        toLog = "User " + user + " rejected the payment in response to the unknown PC-EFTPOS response of \"" + responseCode + "\"";
                    }
                    TerminalEventLog.logEftposEvent(user, terminal, toLog);
                }
                if (result != null && !EftposStatus.ERROR.equals(result.getEftposStatus()) && EftposTransaction.TransactionStatus.PROCESSED.equals((Object)result.getTransactionStatus()) && !request.isTippingAdjustment()) {
                    this.hotSwapCashoutTransaction(result);
                    this.modifyTransaction(result);
                    if (!vEft.isEnableTip()) {
                        result.getRequest().getTransaction().setTipReference(null);
                    }
                    pEft.doLastProcessesWithEftposResult(result);
                }
            }
            pEft.closeOff();
        } else if (request.getTransaction().getSubType() == null || request.getTransaction().getType() == null) {
            OrderMateLog.LOG.warn("Cannot offline-process a null-type eftpos transaction.");
            result = new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
        } else if (!request.isTippingAdjustment()) {
            result = this.performOfflineTransaction(request);
        }
        if (result == null) {
            result = new EftposResult(request, EftposStatus.ERROR, request.getTransaction().getSubType(), null, null, null, null, null);
        }
        OrderMateLog.LOG.info("Got Eftpos result:" + (Object)((Object)result.getTransactionStatus()) + " status:" + result.getEftposStatus() + " ref:" + result.getRequest().getTransaction().getTransactionReference());
        return result;
    }

    public final EftposResult performOfflineTransaction(EftposRequest request) {
        if (request.getTransaction() instanceof MOTOTransaction) {
            return new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "CANNOT PERFORM MOTO TRANSACTION OFFLINE");
        }
        OrderMate.LOG.info("Performing offline eftpos transaction" + request.getTransaction());
        EftposTransaction txn = request.getTransaction();
        txn.setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
        User user = request.getTransaction().getUser();
        Terminal terminal = request.getTransaction().getTerminal();
        ItemGroup account = null;
        if (request.getPayable() != null && request.getPayable() instanceof ItemGroup) {
            account = (ItemGroup)request.getPayable();
        }
        TerminalEventLog.logOfflineEftpos(new EventContext(terminal, user), txn, account);
        return new EftposResult(request, EftposStatus.APPROVED, request.getTransaction().getSubType(), txn.getPaid(), txn.getTip(), txn.getSurcharge(), txn.getCashOut(), null);
    }

    private void hotSwapCashoutTransaction(EftposResult result) {
        EftposTransaction txn = result.getRequest().getTransaction();
        if (result.getRequest().isReversal() && !txn.getCashOut().equals(Price.ZERO_DOLLAR)) {
            User user = result.getRequest().getTransaction().getUser();
            Terminal terminal = result.getRequest().getTransaction().getTerminal();
            TakeawayAccount dummyAccount = new TakeawayAccount(user, terminal);
            dummyAccount.lock(user);
            DebitTransaction cashoutTxn = new DebitTransaction(txn.getUser(), txn.getTerminal(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, txn.getCashOut(), txn.getCashDrawer(), txn.getSubType(), txn.getShift());
            dummyAccount.addFinanceTransaction(cashoutTxn);
            this.toolkit.getSaveAccount().closeAccount(dummyAccount, true, true, new EventContext(terminal, user));
            dummyAccount.unlock();
        }
    }

    private void modifyTransaction(EftposResult result) {
        StringBuilder SB;
        EftposRequest request = result.getRequest();
        if (request.getTransaction().isPersistent()) {
            return;
        }
        EftposTransaction txn = request.getTransaction();
        boolean shouldModify = !result.isApproved();
        Price actualTotalPaid = result.getTotalActualPayment();
        Price expectedTotalPaid = txn.getPaid().add(txn.getTip());
        if (request.isReversal()) {
            expectedTotalPaid = expectedTotalPaid.negate();
        }
        OrderMate.LOG.info("Actual total paid: " + actualTotalPaid + ", Expected total paid: " + expectedTotalPaid);
        if (!actualTotalPaid.equals(expectedTotalPaid)) {
            if (!expectedTotalPaid.subtract(txn.getTip()).equals(txn.getPaid())) {
                SB = new StringBuilder("<html>Total value expected paid in eftpos is different to actual amount paid:<br>");
                SB.append(actualTotalPaid.toString(true));
                SB.append("</b> was transferred but expected <b>");
                SB.append(expectedTotalPaid.toString(true));
                SB.append("</b></html>");
                this.logAndShow(SB.toString(), "Eftpos Paid Different Amount");
            }
            shouldModify = true;
        } else if (!(result.getActualCashout().equals(txn.getCashOut()) || result.getRequest().isReversal() && result.getActualCashout().equals(Price.ZERO_DOLLAR))) {
            SB = new StringBuilder("<html>Cashout amount processed by eftpos was not as expected:<br><b>");
            SB.append(txn.getCashOut().toString(true));
            SB.append("</b> was cashed out but expected <b>");
            SB.append(result.getActualCashout().toString(true));
            SB.append("</b></html>");
            this.logAndShow(SB.toString(), "Eftpos Cashout Different Amount");
            shouldModify = true;
        }
        FinanceUnit expectedType = txn.getSubType();
        FinanceUnit actualType = result.getCardType();
        if (expectedType == null && actualType == null) {
            actualType = FinanceUnit.getDefaultUnitFor(FinanceUnit.DEBIT_TYPE);
            OrderMate.LOG.warn("Null actual and expected finance units, defaulting to savings.");
            this.toolkit.getGuiHandler().displayOkDialog("<html>" + Internationalization.getLiteralFor("FINANCE_UNIT_COULD_NOT_BE_DETERMINED_DEFAULT_TO_SAVINGS") + "<br>" + Internationalization.getLiteralFor("PLEASE_REPORT_THIS_TO_ORDERMATE") + "</html>", Internationalization.getLiteralFor("CANNOT_DETERMINE_PAYMENT_UNIT"));
        }
        if (actualType != null && !actualType.equals(expectedType)) {
            shouldModify = true;
        }
        FinanceTransaction newTxn = null;
        if (shouldModify) {
            if (actualType == null) {
                if (expectedType == null) {
                    expectedType = FinanceUnit.getDefaultUnitFor(FinanceUnit.DEBIT_TYPE);
                }
                actualType = expectedType;
            }
            newTxn = this.createDefaultTransaction(actualType, txn.getTerminal(), result.getActualPaid(), result.getActualTip(), result.getActualCashout(), txn.getUser(), txn.getCashDrawer(), Terminal.getLocalHost().getShift());
            newTxn.applyAccount(txn.getAccount());
            newTxn.setSurcharge(result.getActualSurcharge());
            newTxn.setSource(txn.getSource());
        }
        if (newTxn != null) {
            newTxn.setTransactionReference(txn.getTransactionReference());
            ((EftposTransaction)newTxn).setTransactionStatus(txn.getTransactionStatus());
            newTxn.setReversedTransactionId(txn.getReversedTransactionId());
            ((EftposTransaction)newTxn).setTipReference(txn.getTipReference());
            ((EftposTransaction)newTxn).setAuthCode(txn.getAuthCode());
            ((EftposTransaction)newTxn).setVirtualEftpos(txn.getVirtualEftpos());
            newTxn.setNote(txn.getNote());
            for (FinanceTransactionDocket docket : txn.getDockets()) {
                ((EftposTransaction)newTxn).addDocket(docket);
            }
            if (!result.isApproved()) {
                newTxn.setSystemState("DELETED");
            } else {
                newTxn.setSystemState(txn.getSystemState());
            }
            if (newTxn.getReversedTransactionId() != null) {
                ((EftposTransaction)newTxn).saveChild();
            }
            request.setEftposTransaction((EftposTransaction)newTxn);
        }
    }

    private EftposTransaction createDefaultTransaction(FinanceUnit actualType, Terminal terminal, Price paid, Price tip, Price cashout, User user, CashDrawer cashdrawer, Shift shift) {
        EftposTransaction newTxn = null;
        if (FinanceUnit.DEBIT_TYPE.toString().equals(actualType.getType())) {
            newTxn = new DebitTransaction(user, terminal, paid, tip, cashout, cashdrawer, actualType, shift);
        } else if (FinanceUnit.CREDIT_TYPE.toString().equals(actualType.getType())) {
            newTxn = new CreditTransaction(user, terminal, paid, tip, cashdrawer, actualType, shift);
        } else if (FinanceUnit.WEB_TYPE.toString().equals(actualType.getType())) {
            newTxn = new WebTransaction(user, terminal, paid, tip, cashdrawer, actualType, shift);
        } else {
            OrderMateLog.LOG.warn("Type is not an Eftpos type:" + actualType.getType());
        }
        return newTxn;
    }

    private void logAndShow(String message, String title) {
        OrderMateLog.LOG.warn(message);
        if (this.toolkit.getGuiHandler() != null) {
            this.toolkit.getGuiHandler().displayOkDialog(title, message);
        }
    }

    public void performStartupTasks() {
        List<CashDrawer> drawers = Terminal.getLocalHost().getAvailableLogicallyConnectedCashDrawers();
        for (CashDrawer drawer : drawers) {
            VirtualEftpos vEft;
            if (!drawer.isUserPayable() || (vEft = this.resolver.getEftposForCashDrawer(drawer, Terminal.getLocalHostIfAvailable())) == null || Terminal.getLocalHost().getAvailableReceiptPrinters().size() <= 0) continue;
            this.printInterruptedTransactions(vEft);
            this.clearInterruptedTransactions(vEft);
        }
    }

    private boolean canProcess(PhysicalEftpos pEft, EftposRequest request, VirtualEftpos virtualEftpos) {
        EftposTransaction eftposTxn = request.getTransaction();
        if (!request.isReversal() && eftposTxn.getPaid().lessThan(Price.ZERO_DOLLAR) && eftposTxn.getCashOut().greaterThan(Price.ZERO_DOLLAR) && !pEft.supportsCashoutWithRefunds()) {
            this.logAndShow(HtmlUtils.html("Cannot perform a cashout with a refund for this eftpos"), "No cashout on refund.");
            return false;
        }
        if (virtualEftpos != null && virtualEftpos.isAutoSurcharge()) {
            if (!request.isReversal() && Price.ZERO_DOLLAR.lessThan(eftposTxn.getPaid()) && !Price.ZERO_DOLLAR.equals(eftposTxn.getSurcharge())) {
                this.logAndShow(HtmlUtils.html("Cannot double surcharge, this Eftpos is configured to allow auto surcharge."), "Pre-surcharge set with auto surcharge");
                return false;
            }
            if (Price.ZERO_DOLLAR.greaterThan(eftposTxn.getPaid()) && Price.ZERO_DOLLAR.lessThan(eftposTxn.getSurcharge())) {
                this.logAndShow(HtmlUtils.html("Cannot pre-surcharge a refund."), "Pre-surcharge set with auto surcharge");
                return false;
            }
        }
        if (request.isTippingAdjustment()) {
            if (!pEft.supportsTipping()) {
                this.logAndShow(HtmlUtils.html("Cannot set a tip post-transaction on this Eftpos installation"), "No tip adjutments");
                return false;
            }
            Price tip = eftposTxn.getTip();
            if (tip == null || tip.lessThan(Price.ZERO_DOLLAR)) {
                this.logAndShow(HtmlUtils.html("The Tip amount is invalid: " + tip), "Invalid Tip Amount");
                return false;
            }
            if (tip.greaterThan(eftposTxn.getPaid())) {
                this.logAndShow(HtmlUtils.html("The Tip amount, " + tip + " should not be greater than the paid amount, " + eftposTxn.getPaid()), "Invalid Tip Amount");
                return false;
            }
            if (!CreditTransaction.getCreditUnitTypes().contains(request.getTransaction().getSubType())) {
                this.logAndShow(HtmlUtils.html("Cannot perform a tip adjustment on a non-credit transaction."), "Tip Adjustment on Credit Only");
                return false;
            }
        }
        return true;
    }

    public String getEftposTerminalID(EftposRequest request) {
        VirtualEftpos eft = this.resolver.getEftposForRequest(request);
        if (eft != null) {
            return eft.getTerminalId();
        }
        return null;
    }

    private EftposResult processTransactionRequest(PhysicalEftpos pEft, final VirtualEftpos vEft, final EftposRequest request) {
        EftposResult result;
        if (request.getTransaction() instanceof MOTOTransaction) {
            if (!pEft.supportsMOTO()) {
                pEft.closeOff();
                request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.NOT_CONNECTED);
                EftposResult result2 = new EftposResult(request, EftposStatus.ERROR, null, null, null, null, null, null);
                return result2;
            }
            request.setMoto(true);
        }
        if (!pEft.isConnected(request.getTerminalToUse())) {
            pEft.closeOff();
            request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.NOT_CONNECTED);
            EftposResult result3 = new EftposResult(request, EftposStatus.ERROR, null, null, null, null, null, null);
            return result3;
        }
        String actualID = pEft.getTerminalIDIfReady();
        String terminalID = vEft.getTerminalId();
        EftposLogger.logMessage("EftposManager. obtained terminal ID " + actualID + " terminal ID " + terminalID);
        if (actualID == null) {
            request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.BUSY);
            result = new EftposResult(request, EftposStatus.ERROR, null, null, null, null, null, actualID);
        } else if (terminalID != null && terminalID.trim().length() > 0 && actualID.length() > 0 && !actualID.equals(terminalID)) {
            request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
            result = new EftposResult(request, EftposStatus.ERROR, null, null, null, null, null, actualID);
        } else {
            EftposLogger.logMessage("EftposManager before performTransaction ");
            result = pEft.performTransaction(request);
            if (result != null) {
                EftposLogger.logMessage("EftposManager after performTransaction with result : " + result.getEftposStatus());
                if (request.getTransaction().getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.NOT_PROCESSED)) {
                    request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.PROCESSED);
                }
                if (result.getCardType() == null) {
                    OrderMate.LOG.warn("Could not determine card type from response! Check logs for response.");
                }
                if (!StringUtils.isEmpty(vEft.getLastConnectedBank())) {
                    request.getTransaction().setBankDesc(vEft.getLastConnectedBank());
                }
            } else {
                EftposLogger.logMessage("EftposManager after performTransaction with no result");
                request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
            }
            if (request.isUpdateOriginalDetails()) {
                request.getTransaction().setVirtualEftpos(vEft);
            }
            if (EftposType.getRegister().containsKey(vEft.getEftposType().getLabel())) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vEft.setLastTxnReference(request.getTransaction().getTransactionReference());
                        vEft.save();
                    }
                }).start();
            }
        }
        pEft.closeOff();
        return result;
    }

    public void printInterruptedTransactions(VirtualEftpos vEft) {
        PhysicalEftpos pEft = this.getPhysicalEftpos(vEft);
        pEft.printInterruptedTransaction(vEft.getLastTxnReference());
        pEft.closeOff();
    }

    public void clearInterruptedTransactions(VirtualEftpos vEft) {
        PhysicalEftpos pEft = this.getPhysicalEftpos(vEft);
        pEft.clearInterruptedTransactions();
        pEft.closeOff();
    }

    private PhysicalEftpos getPhysicalEftpos(VirtualEftpos vEft) {
        PhysicalEftpos pEft = PhysicalEftposFactory.getInstance().createPhysicalEftpos(vEft, this.toolkit);
        pEft.configureEftpos(vEft);
        return pEft;
    }

    public VirtualEftpos getEftposForCashDrawer(CashDrawer drawer, Terminal terminal) {
        return this.resolver.getEftposForCashDrawer(drawer, terminal);
    }

    public List<String> getSupportedPreAuthTransactions(PreauthTransaction txn) {
        VirtualEftpos vEft = this.resolver.getEftposForCashDrawer(txn.getCashDrawer(), txn.getTerminal());
        if (vEft != null && vEft.isOnline()) {
            PhysicalEftpos pEft = this.getPhysicalEftpos(vEft);
            return pEft.supportedPreAuth();
        }
        return null;
    }

    public final PreauthResult performPreauthorisation(PreauthRequest request) {
        VirtualEftpos vEft = this.resolver.getEftposForCashDrawer(request.getTxn().getCashDrawer(), request.getTxn().getTerminal());
        PreauthResult result = null;
        if (vEft != null && vEft.isOnline()) {
            PhysicalEftpos pEft = this.getPhysicalEftpos(vEft);
            if (pEft != null && pEft.supportsPreAuth()) {
                if (!this.precheckPreauth(pEft, vEft, request)) {
                    result = new PreauthResult(request, EftposStatus.UNKNOWN, "Pre-auth checks failed", null);
                    return result;
                }
                try {
                    result = this.doPreauth(pEft, vEft, request);
                }
                catch (Exception ex) {
                    OrderMateLog.LOG.error("Problem while Processing Eftpos Transaction.", (Throwable)ex);
                }
            } else {
                this.toolkit.getGuiHandler().displayOkDialog("Preauth Not Supported", "Preauthorisation is not supported for this eftpos");
                OrderMate.LOG.warn("Cannot perform preauth on " + pEft);
            }
        }
        return result;
    }

    private boolean precheckPreauth(PhysicalEftpos pEft, VirtualEftpos vEft, PreauthRequest request) {
        if (!pEft.isConnected(request.getTxn().getTerminal())) {
            pEft.closeOff();
            this.getToolkit().getGuiHandler().displayOkDialog("Not Connected", "The physical eftpos is not connected.");
            return false;
        }
        String actualID = pEft.getTerminalIDIfReady();
        String terminalID = vEft.getTerminalId();
        if (actualID == null) {
            this.getToolkit().getGuiHandler().displayOkDialog("Eftpos Busy", "The physical eftpos appears to be currently busy.");
            return false;
        }
        if (terminalID != null && terminalID.trim().length() > 0 && actualID.length() > 0 && !actualID.equals(terminalID)) {
            this.getToolkit().getGuiHandler().displayOkDialog("Eftpos Not Configured", "The eftpos has not been configured correctly.");
            return false;
        }
        if (PreauthType.CONSUMPTION.equals((Object)request.getTxn().getType())) {
            if (request.getTxn().getReferredTxn() == null) {
                this.getToolkit().getGuiHandler().displayOkDialog("Cannot Close null Transaction", "A null transaction cannot be closed");
                return false;
            }
            if (request.getTxn().getAmount().greaterThan(PreauthTransactionHelper.getInstance().getTotalPreAuth(request.getTxn().getReferredTxn()))) {
                this.getToolkit().getGuiHandler().displayOkDialog("Cannot Consume Larger Amount", "The preauthorised amount is less than " + request.getTxn().getAmount());
                return false;
            }
        }
        return true;
    }

    private PreauthResult doPreauth(PhysicalEftpos pEft, VirtualEftpos vEft, PreauthRequest request) {
        PreauthResult result = pEft.performPreauth(request);
        PreauthTransaction txn = request.getTxn();
        if (result != null) {
            request.getTxn().setStatus(result.getEftposStatus());
            if (EftposStatus.APPROVED.equals(result.getEftposStatus())) {
                if (PreauthType.ALLOCATION.equals((Object)txn.getType())) {
                    txn.setSystemState(SystemState.ACTIVE_STATE);
                } else if (PreauthType.CONSUMPTION.equals((Object)txn.getType())) {
                    PreauthTransaction consumedTxn = txn.getReferredTxn();
                    consumedTxn.setSystemState(SystemState.INACTIVE_STATE);
                    PreauthTransactionHelper.getInstance().setAllTxnsAsInactive(txn.getReferredTxn());
                    FinanceUnit unit = FinanceUnit.getUnitForName(consumedTxn.getCardType());
                    if (unit == null) {
                        unit = FinanceUnit.getDefaultUnitFor(FinanceUnit.CREDIT_TYPE);
                    }
                    EftposTransaction realTxn = this.createDefaultTransaction(unit, txn.getTerminal(), txn.getAmount(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, txn.getUser(), txn.getCashDrawer(), txn.getShift());
                    realTxn.setTransactionReference(consumedTxn.getTxnReference());
                    realTxn.setAuthCode(consumedTxn.getAuthCode());
                    txn.setRealTxn(realTxn);
                    request.getItemGroup().addFinanceTransaction(realTxn);
                    EventContext context = new EventContext(txn.getTerminal(), txn.getUser(), txn.getShift().getTradingDay(), txn.getShift());
                    this.toolkit.getSaveAccount().saveAccount(request.getItemGroup().getAccount(), context);
                    txn.setSystemState(SystemState.INACTIVE_STATE);
                } else if (PreauthType.VOID.equals((Object)txn.getType())) {
                    txn.getReferredTxn().setSystemState(SystemState.INACTIVE_STATE);
                    PreauthTransactionHelper.getInstance().setAllTxnsAsInactive(txn.getReferredTxn());
                    txn.setSystemState(SystemState.INACTIVE_STATE);
                } else if (PreauthType.TOPUP.equals((Object)txn.getType())) {
                    txn.setSystemState(SystemState.ACTIVE_STATE);
                } else if (PreauthType.PART_VOID.equals((Object)txn.getType())) {
                    txn.setSystemState(SystemState.ACTIVE_STATE);
                }
            } else {
                txn.setSystemState(SystemState.DELETED_STATE);
            }
        } else {
            txn.setStatus(EftposStatus.ERROR);
            txn.setSystemState(SystemState.DELETED_STATE);
        }
        txn.save();
        if (txn.getReferredTxn() != null) {
            txn.getReferredTxn().save();
        }
        pEft.closeOff();
        return result;
    }
}

