/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.manager;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.eftpos.WebPaymentRequest;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;

class EftposResolver {
    EftposResolver() {
    }

    VirtualEftpos getEftposForRequest(EftposRequest request) {
        if (request instanceof WebPaymentRequest) {
            return this.makeEftposForWebPayment((WebPaymentRequest)request);
        }
        return this.getEftposForCashDrawer(request.getCashDrawerToUse(), request.getTerminalToUse());
    }

    private VirtualEftpos makeEftposForWebPayment(WebPaymentRequest request) {
        VirtualEftpos eftpos = new VirtualEftpos();
        eftpos.setCashDrawer(request.getCashDrawerToUse());
        eftpos.setEftposType(null);
        eftpos.setLabel("Web Eftpos " + request.getWebIntegration().getLabel());
        eftpos.setOnline(true);
        eftpos.setEftposType(new EftposType(request.getWebIntegration()));
        return eftpos;
    }

    VirtualEftpos getEftposForCashDrawer(CashDrawer drawer, Terminal terminal) {
        ObjectQuery query = Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.CASH_DRAWER, drawer).not().equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.TYROMOBILE).active(VirtualEftpos.class);
        List<VirtualEftpos> efts = PersistenceManager.getObjectList(VirtualEftpos.class, query.toString(), null);
        if (terminal != null) {
            for (VirtualEftpos nextPos : efts) {
                if (!EftposType.TYROWEB.equals(nextPos.getEftposType()) || !nextPos.getPairingMap().containsKey(terminal.getID())) continue;
                return nextPos;
            }
        }
        if (efts.size() > 0) {
            for (VirtualEftpos e : efts) {
                if (!terminal.equals(e.getPreferredTerminal())) continue;
                return e;
            }
            return efts.get(0);
        }
        return null;
    }
}

