/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.manager;

import au.com.ordermate.OrderMateLog;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import ordermate.gui.dialogs.ForcedChoiceOptionDialog;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.EftposUnknownResponseConstants;

public class EftposUnknownResponseHandler {
    private ForcedChoiceOptionDialog dog;
    private final EftposToolkit toolkit;
    private final String response;
    private String approved;
    private String declined;

    EftposUnknownResponseHandler(EftposToolkit yourKit, String responseCode) {
        this.toolkit = yourKit;
        this.response = responseCode;
    }

    public boolean warnAndPromptForUserInstruction() {
        final String message = EftposUnknownResponseConstants.getPromptMessage(this.response);
        this.declined = EftposUnknownResponseConstants.getDeclinedButtonText();
        this.approved = EftposUnknownResponseConstants.getApprovedButtonText();
        this.doOnEDTAndWait(new Runnable(){

            @Override
            public void run() {
                EftposUnknownResponseHandler.this.dog = EftposUnknownResponseHandler.this.toolkit.getGuiHandler().createForcedChoiceDialog(message, EftposUnknownResponseConstants.getDialogTitle(), "OK", null, Arrays.asList(EftposUnknownResponseHandler.this.declined, EftposUnknownResponseHandler.this.approved), true);
                EftposUnknownResponseHandler.this.dog.getSignal().connect(EftposUnknownResponseHandler.this, "gotOption");
                EftposUnknownResponseHandler.this.toolkit.getGuiHandler().displayBlockingDialog(EftposUnknownResponseHandler.this.dog.getDisplayablePanel());
            }
        });
        return this.approved.equals(this.dog.getChoice());
    }

    public void gotOption(String option) {
        String confMessage = "";
        if (this.approved != null && this.approved.equals(option)) {
            confMessage = EftposUnknownResponseConstants.getConfirmationToApproveText();
        } else if (this.declined != null && this.declined.equals(option)) {
            confMessage = EftposUnknownResponseConstants.getConfirmationToDeclineText();
        }
        this.dog.enableConfirmation(confMessage, "", "Yes", "No");
        this.dog.doConfirmation();
    }

    private void doOnEDTAndWait(Runnable toRun) {
        if (SwingUtilities.isEventDispatchThread()) {
            toRun.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(toRun);
            }
            catch (Exception ex) {
                OrderMateLog.LOG.warn("Exception while displaying dialog.", (Throwable)ex);
            }
        }
    }
}

