/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.manager;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;

public class PreauthRequest {
    private final PreauthTransaction txn;
    private final ItemGroup itemGroup;

    public static PreauthRequest makeAllocationRequest(FinanceTransactionContext context, Price amount, Account account) {
        if (account == null || !account.isPersistent()) {
            throw new IllegalStateException("The account must be saved before allocating a preauth amount");
        }
        PreauthTransaction txn = new PreauthTransaction(account.toString() + " " + DateFormat.getTimeInstance().format(new Date()), amount, PreauthType.ALLOCATION, context);
        txn.setAccount(account);
        return new PreauthRequest(txn, account);
    }

    public static PreauthRequest makeAllocationRequest(FinanceTransactionContext context, Price amount, String identifier) {
        PreauthTransaction txn = new PreauthTransaction(identifier, amount, PreauthType.ALLOCATION, context);
        return new PreauthRequest(txn, null);
    }

    public static PreauthRequest makeConsumptionRequest(FinanceTransactionContext context, Price amount, PreauthTransaction toConsume, ItemGroup itemGroup) {
        if (toConsume == null) {
            throw new IllegalStateException("Cannot close a null transaction");
        }
        if (StringUtils.isEmpty(toConsume.getCompletionRef())) {
            throw new IllegalStateException("Cannot close a request without a confirmation id - it was never allocated");
        }
        PreauthTransaction txn = new PreauthTransaction(toConsume.getIdentifier(), amount, PreauthType.CONSUMPTION, context);
        txn.setAccount(itemGroup.getAccount());
        txn.setReferredTxn(toConsume);
        return new PreauthRequest(txn, itemGroup);
    }

    public static PreauthRequest makeVoidRequest(FinanceTransactionContext context, PreauthTransaction toVoid) {
        if (toVoid == null) {
            throw new IllegalStateException("Cannot void a null request");
        }
        if (StringUtils.isEmpty(toVoid.getCompletionRef())) {
            throw new IllegalStateException("Cannot void a request without a confirmation id - it was never allocated");
        }
        PreauthTransaction txn = new PreauthTransaction(toVoid.getIdentifier(), Price.ZERO_DOLLAR, PreauthType.VOID, context);
        txn.setReferredTxn(toVoid);
        return new PreauthRequest(txn, null);
    }

    public static PreauthRequest makeTopupRequest(FinanceTransactionContext context, Price amount, PreauthTransaction toTopup, ItemGroup itemGroup) {
        PreauthTransaction txn = new PreauthTransaction(toTopup.getIdentifier(), amount, PreauthType.TOPUP, context);
        txn.setReferredTxn(toTopup);
        txn.setAccount(itemGroup.getAccount());
        return new PreauthRequest(txn, itemGroup);
    }

    public static PreauthRequest makePartVoidRequest(FinanceTransactionContext context, Price amount, PreauthTransaction toPartCncl, ItemGroup itemGroup) {
        PreauthTransaction txn = new PreauthTransaction(toPartCncl.getIdentifier(), amount, PreauthType.PART_VOID, context);
        txn.setReferredTxn(toPartCncl);
        return new PreauthRequest(txn, itemGroup);
    }

    public static PreauthRequest makeExtendRequest(FinanceTransactionContext context, PreauthTransaction toExtend) {
        PreauthTransaction txn = new PreauthTransaction(toExtend.getIdentifier(), Price.ZERO_DOLLAR, PreauthType.EXTEND, context);
        txn.setReferredTxn(toExtend);
        return new PreauthRequest(txn, null);
    }

    public static PreauthRequest makeVerifyRequest(FinanceTransactionContext context, PreauthTransaction toVerify) {
        PreauthTransaction txn = new PreauthTransaction(toVerify.getIdentifier(), Price.ZERO_DOLLAR, PreauthType.VERIFY, context);
        txn.setReferredTxn(toVerify);
        return new PreauthRequest(txn, null);
    }

    private PreauthRequest(PreauthTransaction txn, ItemGroup itemGroup) {
        this.txn = txn;
        this.itemGroup = itemGroup;
    }

    public final PreauthTransaction getTxn() {
        return this.txn;
    }

    public final ItemGroup getItemGroup() {
        return this.itemGroup;
    }
}

