/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.mx51;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.mx51.SpiceIntegrationProcessor;
import ordermate.integration.eftpos.mx51.request.SpicePreAuthRequest;
import ordermate.integration.eftpos.mx51.request.SpicePreAuthType;
import ordermate.integration.eftpos.mx51.request.SpicePurchaseRequest;
import ordermate.integration.eftpos.mx51.request.SpiceRefundRequest;
import ordermate.integration.eftpos.mx51.response.AbstractSpiceTransactionResponse;
import ordermate.integration.eftpos.mx51.response.SpicePingResponse;
import ordermate.integration.eftpos.mx51.response.SpicePreAuthResponse;
import ordermate.integration.eftpos.mx51.response.SpicePurchaseResponse;
import ordermate.integration.eftpos.mx51.response.SpiceRefundResponse;
import ordermate.integration.eftpos.mx51.response.SpiceTerminalsResponse;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;

public class SpiceEftpos
implements PhysicalEftpos {
    private String location;
    private String terminalID;
    private String posID;
    private int port;
    private VirtualEftpos vEft;
    private EftposPrintProcessor printProcessor;
    private final String CLOSE = "Settle";
    private final String TOPUP = "Topup";
    private final String VOID = "Void";

    public String getLocation() {
        return this.location;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
        this.location = virtualEftpos.getIpAddress();
        this.terminalID = virtualEftpos.getTerminalId();
        this.posID = virtualEftpos.getLabel();
        this.port = virtualEftpos.getPort();
        this.vEft = virtualEftpos;
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
    }

    @Override
    public void closeOff() {
    }

    private Price centsToPrice(int cents) {
        return new Price((double)cents / 100.0, 0.01);
    }

    private <T> T handleSignature(AbstractSpiceTransactionResponse resp, EftposRequest request) {
        if (resp == null) {
            return null;
        }
        try {
            ExperimentalFeature spiceReceipts = ExperimentalFeature.find("Spice Receipts");
            boolean merchant = true;
            boolean customer = true;
            if (spiceReceipts != null) {
                String value = spiceReceipts.getValue();
                customer = value == null || value.contains("customer");
                boolean bl = merchant = value == null || value.contains("merchant");
            }
            if (resp.isSignatureRequired()) {
                Object req;
                DocketProcessor.printEftposDocket(resp.getSignature().getReceiptToSign(), Terminal.getLocalHost().getAvailableReceiptPrinters(), request.getTransaction(), false);
                if (resp instanceof SpiceRefundResponse) {
                    req = new SpiceRefundRequest(resp.getSignature().getPosRefId());
                    resp = SpiceIntegrationProcessor.getRefundTransaction(this.location, this.port, (SpiceRefundRequest)req);
                } else if (resp instanceof SpicePurchaseResponse) {
                    req = new SpicePurchaseRequest(resp.getSignature().getPosRefId());
                    resp = SpiceIntegrationProcessor.getPurchaseTransaction(this.location, this.port, (SpicePurchaseRequest)req);
                }
            } else if (!StringUtils.isEmpty(resp.getMerchant_receipt()) && !resp.isMerchant_receipt_printed() && merchant) {
                DocketProcessor.printEftposDocket(resp.getMerchant_receipt(), Terminal.getLocalHost().getAvailableReceiptPrinters(), request.getTransaction(), false);
            }
            if (!StringUtils.isEmpty(resp.getCustomer_receipt()) && !resp.isCustomer_receipt_printed() && customer) {
                DocketProcessor.printEftposDocket(resp.getCustomer_receipt(), Terminal.getLocalHost().getAvailableReceiptPrinters(), request.getTransaction(), true);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            return null;
        }
        return (T)resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EftposResult performTransaction(EftposRequest request) {
        Price amountPaid = request.getTransaction().getPaid().subtract(request.getTransaction().getSurcharge());
        this.vEft.setLastTxnReference(this.createTransactionId());
        this.vEft.save();
        String posRefId = this.vEft.getLastTxnReference();
        try {
            if (Price.ZERO.greaterThan(request.getTransaction().getPaid()) || request.isReversal()) {
                if (request.isReversal()) {
                    if (Price.ZERO.greaterThan(request.getTransaction().getPaid())) {
                        EftposResult eftposResult = new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null);
                        return eftposResult;
                    }
                    posRefId = posRefId + "Reversal";
                }
                SpiceRefundRequest req = new SpiceRefundRequest(posRefId, Math.abs(request.getTransaction().getPaid().getNumCents()), true);
                SpiceRefundResponse resp = SpiceIntegrationProcessor.postRefundTransaction(this.location, this.port, req);
                if ((resp = (SpiceRefundResponse)this.handleSignature(resp, request)) == null) {
                    EftposResult eftposResult = new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "Error with response from Spice, check connection");
                    return eftposResult;
                }
                request.getTransaction().setTransactionReference(resp.getStan());
                request.getTransaction().setAuthCode(resp.getAuth_code());
                EftposResult eftposResult = new EftposResult(request, resp.isSuccess() ? EftposStatus.APPROVED : EftposStatus.ERROR, FinanceUnit.getUnitForName(resp.getScheme_name()), this.centsToPrice(-resp.getRefund_amount()), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, resp.isSuccess() ? null : resp.getHost_response_text());
                return eftposResult;
            }
            SpicePurchaseRequest req = new SpicePurchaseRequest(posRefId, Math.abs(amountPaid.getNumCents()), Math.abs(request.getTransaction().getTip().getNumCents()), Math.abs(request.getTransaction().getCashOut().getNumCents()), Math.abs(request.getTransaction().getSurcharge().getNumCents()), false);
            SpicePurchaseResponse resp = SpiceIntegrationProcessor.postPurchaseTransaction(this.location, this.port, req);
            if ((resp = (SpicePurchaseResponse)this.handleSignature(resp, request)) == null) {
                EftposResult eftposResult = new EftposResult(request, EftposStatus.ERROR, null, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, null, "Error with response from Spice, check connection");
                return eftposResult;
            }
            request.getTransaction().setTransactionReference(resp.getStan());
            request.getTransaction().setAuthCode(resp.getAuth_code());
            EftposResult eftposResult = new EftposResult(request, resp.isSuccess() ? EftposStatus.APPROVED : EftposStatus.ERROR, FinanceUnit.getUnitForName(resp.getScheme_name()), this.centsToPrice(resp.getPurchase_amount() + resp.getSurcharge_amount()), this.centsToPrice(resp.getTip_amount()), this.centsToPrice(resp.getSurcharge_amount()), this.centsToPrice(resp.getCash_amount()), null, resp.isSuccess() ? null : resp.getHost_response_text());
            return eftposResult;
        }
        finally {
            this.vEft.setLastTxnReference(null);
            this.vEft.save();
        }
    }

    private String createTransactionId() {
        Long unixTime = System.currentTimeMillis();
        return unixTime.toString();
    }

    String getPreExistingPosRefId(PreauthRequest request) {
        if (request.getTxn().getReferredTxn() != null) {
            return request.getTxn().getReferredTxn().getCompletionRef();
        }
        return null;
    }

    private void printSimpleDocket(SpicePreAuthResponse resp) {
        try {
            if (!StringUtils.isEmpty(resp.getMerchant_receipt()) && !resp.isMerchant_receipt_printed()) {
                DocketProcessor.printSimpleDocket(resp.getMerchant_receipt(), Terminal.getLocalHost().getAvailableReceiptPrinters());
            }
            if (!StringUtils.isEmpty(resp.getCustomer_receipt()) && !resp.isCustomer_receipt_printed()) {
                DocketProcessor.printSimpleDocket(resp.getCustomer_receipt(), Terminal.getLocalHost().getAvailableReceiptPrinters());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage());
        }
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        SpicePreAuthRequest req = new SpicePreAuthRequest(this.createTransactionId(), this.getPreExistingPosRefId(request), request.getTxn().getAmount().getNumCents(), 0);
        SpicePreAuthResponse resp = SpiceIntegrationProcessor.performPreAuthTransaction(this.location, this.port, req, SpicePreAuthType.convert(request.getTxn().getType()));
        if (resp == null) {
            return new PreauthResult(request, EftposStatus.ERROR, "Error with response from Spice, check connection", null);
        }
        this.printSimpleDocket(resp);
        request.getTxn().setCompletionRef(resp.getPreauth_id());
        return new PreauthResult(request, resp.isSuccess() ? EftposStatus.APPROVED : EftposStatus.ERROR, resp.isSuccess() ? null : resp.getHost_response_text(), FinanceUnit.getUnitForName(resp.getScheme_name()));
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        List<SpiceTerminalsResponse> terminals = SpiceIntegrationProcessor.getTerminals(this.location, this.port);
        if (terminals == null) {
            return null;
        }
        for (SpiceTerminalsResponse resp : terminals) {
            if (!this.posID.equals(resp.getPosId()) || !resp.getStatus().equals("PairedConnected") || !resp.getFlow().equals("Idle")) continue;
            return this.terminalID;
        }
        return null;
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        SpicePingResponse ping = SpiceIntegrationProcessor.performPing(this.location, this.port);
        if (ping == null) {
            return false;
        }
        return ping.getStatus().equals("PairedConnected");
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    private void printReceipts(String merchantReciept, String customerReciept) {
        try {
            if (!StringUtils.isEmpty(merchantReciept)) {
                this.printProcessor.printEftposDocket(merchantReciept, null, false);
            }
            if (!StringUtils.isEmpty(customerReciept)) {
                this.printProcessor.printEftposDocket(customerReciept, null, true);
            }
            this.vEft.setLastTxnReference(null);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
        }
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
        AbstractSpiceTransactionResponse resp;
        if (this.vEft.getLastTxnReference() != null && (resp = SpiceIntegrationProcessor.getTransaction(this.location, this.port, this.vEft.getLastTxnReference())) != null) {
            this.printReceipts(!resp.isMerchant_receipt_printed() ? resp.getMerchant_receipt() : null, !resp.isCustomer_receipt_printed() ? resp.getCustomer_receipt() : null);
        }
        this.vEft.save();
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return true;
    }

    @Override
    public List<String> supportedPreAuth() {
        return Arrays.asList("Settle", "Void", "Topup");
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

