/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.mx51;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.eftpos.mx51.request.SpicePayAtTableRequest;
import ordermate.integration.eftpos.mx51.request.SpicePreAuthRequest;
import ordermate.integration.eftpos.mx51.request.SpicePreAuthType;
import ordermate.integration.eftpos.mx51.request.SpicePurchaseRequest;
import ordermate.integration.eftpos.mx51.request.SpiceRefundRequest;
import ordermate.integration.eftpos.mx51.response.AbstractSpiceTransactionResponse;
import ordermate.integration.eftpos.mx51.response.SpicePayAtTableBillResponse;
import ordermate.integration.eftpos.mx51.response.SpicePingResponse;
import ordermate.integration.eftpos.mx51.response.SpicePreAuthResponse;
import ordermate.integration.eftpos.mx51.response.SpicePurchaseResponse;
import ordermate.integration.eftpos.mx51.response.SpiceRefundResponse;
import ordermate.integration.eftpos.mx51.response.SpiceTerminalsResponse;
import ordermate.integration.eftpos.mx51.response.SpiceTransactionResponse;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class SpiceIntegrationProcessor {
    private static final Integer TIMEOUT = 90000;
    private static final String PING_REQUEST = "/v1/ping";
    private static final String TERMINALS_REQUEST = "/v1/terminals";
    private static final String PURCHASE_REQUEST = "/v1/purchase";
    private static final String REFUND_REQUEST = "/v1/refund";
    private static final String PRE_AUTH_REQUEST = "/v1/pre_auth";
    private static final String PAT_TABLE_REQUEST = "/v1/tables";
    private static final String PAT_BILL_REQUEST = "/v1/bills";
    private static final String MOTO_REQUEST = "/v1/moto";

    private static WebResource.Builder createBuilder(String uri) {
        RestHelper rest = new RestHelper();
        WebResource resource = rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        return (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("POS-NAME", (Object)"OrderMate").header("POS-VERSION", (Object)SystemCurrentInfo.getInstance().getCurrentVersion())).type("application/json")).accept(new String[]{"application/json"});
    }

    private static String getUri(String location, int port) {
        return location + ":" + port;
    }

    public static SpicePingResponse performPing(String location, int port) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PING_REQUEST;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            return (SpicePingResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpicePingResponse>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Ping Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static List<SpiceTerminalsResponse> getTerminals(String location, int port) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + TERMINALS_REQUEST;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            return (List)mapper.readValue(responseJSON, (TypeReference)new TypeReference<List<SpiceTerminalsResponse>>(){});
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Terminals Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePurchaseResponse postPurchaseTransaction(String location, int port, SpicePurchaseRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PURCHASE_REQUEST;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            String responseJSON = (String)response.getEntity(String.class);
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePurchaseResponse>>(){});
            if (resp.getResponse() == null && resp.getSignature() != null) {
                resp.setResponse(new SpicePurchaseResponse(resp.getSignature()));
            }
            return (SpicePurchaseResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Post Purchase Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePurchaseResponse postMOTOTransaction(String location, int port, SpicePurchaseRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + MOTO_REQUEST;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePurchaseResponse>>(){});
            return (SpicePurchaseResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Post MOTO Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePurchaseResponse getPurchaseTransaction(String location, int port, SpicePurchaseRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PURCHASE_REQUEST + "?posRefId=" + req.getPosRefId();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePurchaseResponse>>(){});
            return (SpicePurchaseResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Get Purchase Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static AbstractSpiceTransactionResponse getTransaction(String location, int port, String ref) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PURCHASE_REQUEST + "?posRefId=" + ref;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<AbstractSpiceTransactionResponse>>(){});
            return (AbstractSpiceTransactionResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Get Txn Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePurchaseResponse getMOTOTransaction(String location, int port, SpicePurchaseRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + MOTO_REQUEST + "?posRefId=" + req.getPosRefId();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePurchaseResponse>>(){});
            return (SpicePurchaseResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Get MOTO Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpiceRefundResponse postRefundTransaction(String location, int port, SpiceRefundRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + REFUND_REQUEST;
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            String responseJSON = (String)response.getEntity(String.class);
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpiceRefundResponse>>(){});
            if (resp.getResponse() == null && resp.getSignature() != null) {
                resp.setResponse(new SpiceRefundResponse(resp.getSignature()));
            }
            return (SpiceRefundResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Post Refund Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpiceRefundResponse getRefundTransaction(String location, int port, SpiceRefundRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + REFUND_REQUEST + "?posRefId=" + req.getPosRefId();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpiceRefundResponse>>(){});
            return (SpiceRefundResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Get Refund Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePreAuthResponse getPreAuthTransaction(String location, int port, SpicePreAuthRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PRE_AUTH_REQUEST + "?posRefId=" + req.getPosRefId();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePreAuthResponse>>(){});
            return (SpicePreAuthResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Get PreAuth Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePreAuthResponse performPreAuthTransaction(String location, int port, SpicePreAuthRequest req, SpicePreAuthType type) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PRE_AUTH_REQUEST + type.toString();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpiceTransactionResponse resp = (SpiceTransactionResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpiceTransactionResponse<SpicePreAuthResponse>>(){});
            return (SpicePreAuthResponse)resp.getResponse();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Perform PreAuth Request Failed: ", (Throwable)ex);
            return null;
        }
    }

    public static SpicePayAtTableBillResponse performPayAtTableTransaction(String location, int port, SpicePayAtTableRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PAT_BILL_REQUEST + "/" + req.getBillId().toString();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)req);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpicePayAtTableBillResponse resp = (SpicePayAtTableBillResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpicePayAtTableBillResponse>(){});
            return resp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static SpicePayAtTableBillResponse getTablesByBill(String location, int port, SpicePayAtTableRequest req) {
        String uri = SpiceIntegrationProcessor.getUri(location, port) + PAT_BILL_REQUEST + "/" + req.getBillId().toString();
        try {
            WebResource.Builder builder = SpiceIntegrationProcessor.createBuilder(uri);
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            if (response.getStatus() / 100 != 2) {
                return null;
            }
            String responseJSON = (String)response.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            SpicePayAtTableBillResponse resp = (SpicePayAtTableBillResponse)mapper.readValue(responseJSON, (TypeReference)new TypeReference<SpicePayAtTableBillResponse>(){});
            return resp;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

