/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.mx51.request;

import ordermate.database.finance.PreauthType;

public enum SpicePreAuthType {
    OPEN("/open"),
    TOPUP("/topup"),
    EXTEND("/extend"),
    PART_CANCEL("/partial_cancellation"),
    CANCEL("/cancellation"),
    VERIFY("/account_verify"),
    COMPLETE("/complete");

    private final String path;

    private SpicePreAuthType(String path) {
        this.path = path;
    }

    public String toString() {
        return this.path;
    }

    public static SpicePreAuthType convert(PreauthType pType) {
        if (pType.equals((Object)PreauthType.ALLOCATION)) {
            return OPEN;
        }
        if (pType.equals((Object)PreauthType.VOID)) {
            return CANCEL;
        }
        if (pType.equals((Object)PreauthType.CONSUMPTION)) {
            return COMPLETE;
        }
        if (pType.equals((Object)PreauthType.EXTEND)) {
            return EXTEND;
        }
        if (pType.equals((Object)PreauthType.PART_VOID)) {
            return PART_CANCEL;
        }
        if (pType.equals((Object)PreauthType.TOPUP)) {
            return TOPUP;
        }
        if (pType.equals((Object)PreauthType.VERIFY)) {
            return VERIFY;
        }
        return null;
    }
}

