/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.nitroskyzer;

import au.com.ordermate.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.VirtualEftpos;

public class NitroSkyzerUtil {
    private final String controlPanelRequest = "#001050110";
    private static final int PORT = 2011;
    private int port = 2011;
    private final int MESSAGE_LENGTH = 8;
    private final int RESULT_START_INDEX = 7;
    private final int RESULT_END_INDEX = 8;
    private final String SUCCESS = "1";

    public NitroSkyzerUtil() {
        this(2011);
    }

    NitroSkyzerUtil(int port) {
        this.port = port;
    }

    public boolean showControlPanel(VirtualEftpos virtualEftpos) {
        boolean result = false;
        try {
            Socket socket = new Socket();
            String ipAddress = virtualEftpos.getIpAddress();
            socket.setSoTimeout(virtualEftpos.getTimeoutMillis());
            OrderMate.LOG.info("Socket connecting to host " + ipAddress + " Port : " + this.port + " :: " + Thread.currentThread().getName());
            InetSocketAddress address = new InetSocketAddress(ipAddress, this.port);
            socket.connect(address);
            if (!socket.isConnected()) {
                return false;
            }
            if (!this.sendRequest(socket)) {
                OrderMate.LOG.info("Unable to to show Control Panel ");
                return false;
            }
            result = this.isControlPanelShowing(socket);
            OrderMate.LOG.info("Closing socket after successful response read ");
            socket.close();
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private boolean sendRequest(Socket socket) {
        try {
            socket.getOutputStream().write("#001050110".getBytes());
            socket.getOutputStream().flush();
            return true;
        }
        catch (IOException ex) {
            OrderMate.LOG.info(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean isControlPanelShowing(Socket socket) {
        OrderMate.LOG.info("isControlPanelShowing " + Thread.currentThread().getName());
        String response = null;
        boolean result = false;
        try {
            int length = socket.getReceiveBufferSize();
            if (length != 0) {
                byte[] bytes = new byte[length];
                socket.getInputStream().read(bytes);
                response = new String(bytes).trim();
                OrderMate.LOG.info("Response from NitroSkyzer for showControlPanel Request :: " + response);
                if (StringUtils.isEmpty(response) || response.length() < 8) {
                    OrderMate.LOG.info("Returning false because response string length is zero or expected length : 8");
                    return false;
                }
                result = response.substring(7, 8).equals("1");
                OrderMate.LOG.info("NitroSkyzer :: showControlPanel returning " + result);
                return result;
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.info(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }
}

