/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.online;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.EftposResultBuilder;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.onlinepayment.OnlinePaymentRequest;
import ordermate.integration.onlinepayment.OnlinePaymentRequestor;
import ordermate.integration.onlinepayment.OnlinePaymentResponse;
import ordermate.integration.onlinesales.notifier.OnlineUpdateInterceptor;
import ordermate.internationalization.Internationalization;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class OnlineEftpos
implements PhysicalEftpos {
    private final VirtualEftpos vEft;
    private final EftposToolkit toolkit;
    private OnlinePaymentRequestor requestor;
    private OnlinePaymentRequest onlineRequest;

    public OnlineEftpos(EftposToolkit toolkit, VirtualEftpos eftpos) {
        this.vEft = eftpos;
        this.toolkit = toolkit;
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
    }

    @Override
    public void closeOff() {
    }

    private EftposResult createErrorResult(EftposRequest request, String errMessage) {
        if (request == null) {
            return null;
        }
        request.getTransaction().setTransactionStatus(EftposTransaction.TransactionStatus.FAILED);
        FinanceUnit financeUnit = request.getTransaction().getSubType();
        if (financeUnit == null) {
            financeUnit = FinanceUnit.getDefaultUnitFor(FinanceUnit.CREDIT_TYPE);
        }
        return new EftposResultBuilder(request).setEftposStatus(EftposStatus.ERROR).setFinanceUnit(financeUnit).setActualPaid(Price.ZERO_DOLLAR).setExplicitError(errMessage).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EftposResult performTransaction(EftposRequest request) {
        block24: {
            EftposResult eftposResult;
            this.requestor = null;
            try {
                this.requestor = (OnlinePaymentRequestor)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "Online Payment Requestor", 11100);
            }
            catch (NotBoundException ex) {
                OrderMate.LOG.error("Can't get Online Payment Requestor", (Throwable)ex);
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Can't get Online Payment Requestor", (Throwable)ex);
            }
            if (this.requestor == null) {
                OrderMate.LOG.error("No Payment Requestor");
                return this.createErrorResult(request, "Cannot Contact Online Payment Processor");
            }
            try {
                Long payableId = null;
                payableId = this.ensureAccountIsUpToDate(request);
                OrderMate.LOG.info("OnlineEftpos:performTransaction() payableId = " + payableId);
                ExperimentalFeature exp = ExperimentalFeature.find("Online Eftpos Presave");
                if ((exp == null || exp.getBooleanValue(Boolean.TRUE).booleanValue()) && payableId == null) {
                    OrderMate.LOG.error("Account id is null for " + request.getPayable());
                    EftposResult eftposResult2 = this.createErrorResult(request, "Cannot Online-Pay to an unsaved account");
                    return eftposResult2;
                }
                List<OnlinePaymentRequest> reqs = this.requestor.getPaymentRequests();
                if (reqs == null) {
                    reqs = Collections.emptyList();
                }
                this.onlineRequest = null;
                for (OnlinePaymentRequest nextReq : reqs) {
                    if (!this.vEft.getTerminalId().equals(nextReq.getAppId())) continue;
                    this.onlineRequest = nextReq;
                    break;
                }
                if (this.onlineRequest != null) {
                    this.onlineRequest.setAmount(request.getTransaction().getPaid());
                    String paymentId = this.getText(this.onlineRequest.isPaymentIdRequired(), "Payment / Account ID:");
                    String authId = this.getText(this.onlineRequest.isAuthCodeRequired(), "Auth Code:");
                    Date expId = this.getDate(this.onlineRequest.isExpiryDateRequired(), "Expiry Date ");
                    Date issueId = this.getDate(this.onlineRequest.isIssueDateRequired(), "Issue Date ");
                    IntegratedPaymentUI ui = this.toolkit.getUI();
                    ui.getCancelSignal().connect(this, "gotCancel");
                    ui.setHeaderText("Requesting Online Payment");
                    ui.setMessage("Please follow prompts on your " + this.onlineRequest.getLabel() + " Device", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
                    ui.displayBlockingInterface();
                    OnlinePaymentResponse response = this.requestor.requestPayment(this.onlineRequest, request.getTerminalToUse().getID(), payableId, paymentId, authId, expId, issueId);
                    if (response != null) {
                        EftposResult result;
                        if (response.isSuccess()) {
                            String unitName;
                            FinanceUnit unit;
                            Price amount = new Price(response.getAmount(), 0.01);
                            Price tip = response.getTip() == null ? null : new Price(response.getTip(), 0.01);
                            Price cashout = response.getCashout() == null ? null : new Price(response.getCashout(), 0.01);
                            Price surcharge = request.getTransaction().getSurcharge();
                            if (surcharge == null || surcharge.isZero()) {
                                Price price = surcharge = response.getSurcharge() == null ? null : new Price(response.getSurcharge(), 0.01);
                                if (surcharge != null) {
                                    request.getTransaction().setSurcharge(surcharge);
                                    amount = amount.add(surcharge);
                                } else {
                                    surcharge = Price.ZERO_DOLLAR;
                                }
                            }
                            if ((unit = FinanceUnit.getUnitForName(unitName = response.getUnit())) == null) {
                                unit = FinanceUnit.createUnit(FinanceUnit.CREDIT_TYPE, unitName, true);
                            }
                            result = new EftposResultBuilder(request).setEftposStatus(EftposStatus.APPROVED).setActualPaid(amount).setActualTip(tip).setActualCashout(cashout).setActualSurcharge(surcharge).source(response.getSource()).setFinanceUnit(unit).build();
                        } else {
                            result = new EftposResultBuilder(request).setActualPaid(request.getTransaction().getPaid()).setFinanceUnit(FinanceUnit.getDefaultUnitFor(FinanceUnit.CREDIT_TYPE)).setEftposStatus(EftposStatus.CANCELLED).setExplicitError(response.getReason()).build();
                        }
                        request.getTransaction().setSource(response.getSource());
                        request.getTransaction().setTransactionReference(response.getTxnReference());
                        result.setSource(response.getSource());
                        EftposResult eftposResult3 = result;
                        return eftposResult3;
                    }
                    break block24;
                }
                OrderMate.LOG.error("No Online Payment Apps have been detected.");
                EftposResult eftposResult4 = this.createErrorResult(request, "No Online Payment Apps have been detected.");
                return eftposResult4;
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Problem making online payment request:", (Throwable)ex);
                eftposResult = this.createErrorResult(request, "Onlie payment failed.");
                return eftposResult;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error when making payment request:", (Throwable)ex);
                eftposResult = null;
                return eftposResult;
            }
            finally {
                this.toolkit.getUI().getCancelSignal().disconnect(this);
                this.toolkit.getUI().closeBlockingInterface();
                this.toolkit.getUI().setCancelEnabled(true);
                this.requestor = null;
                this.onlineRequest = null;
            }
        }
        return null;
    }

    private Long ensureAccountIsUpToDate(EftposRequest request) {
        Payable payable = request.getPayable();
        Account account = null;
        if (payable instanceof ItemGroup) {
            account = ((ItemGroup)payable).getAccount();
        } else if (payable instanceof AccountPercentagePayable) {
            account = ((AccountPercentagePayable)payable).getItemGroup().getAccount();
        } else if (payable instanceof DebtorPaymentAgent) {
            OrderMate.LOG.info("Online Eftpos using DebtorPaymentAgent of ID = " + ((DebtorPaymentAgent)payable).getID());
            return ((DebtorPaymentAgent)payable).getID();
        }
        if (account == null) {
            return null;
        }
        ExperimentalFeature exp = ExperimentalFeature.find("Online Eftpos Presave");
        if (exp == null || exp.getBooleanValue(Boolean.TRUE).booleanValue()) {
            EventContext context = new EventContext(request.getTerminalToUse(), request.getTransaction().getUser());
            this.toolkit.getSaveAccount().saveAccount(account, context);
            CallMethodOnClassExecutable callIt = new CallMethodOnClassExecutable(OnlineUpdateInterceptor.class.getCanonicalName(), "getInstance", "getDiamondBackInterceptorHandler", "sendNow");
            Object returned = PersistenceManager.getServerConnection().runSync(callIt);
            OrderMate.LOG.warn("Pushed current account state to Online service for payment:", returned);
        }
        return account.getID();
    }

    public void gotCancel() {
        try {
            boolean isSuccessful = this.requestor.requestCancel(this.onlineRequest);
            if (!isSuccessful) {
                this.toolkit.getGuiHandler().displayOkDialog(HtmlUtils.html(Internationalization.getLiteralFor("FAILED_TO_CANCEL_THE_EFTPOS_TRANSACTION")), Internationalization.getLiteralFor("EFTPOS_CANCEL_FAILED"));
            }
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot cancel online payment request", (Throwable)ex);
        }
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        return this.vEft.getTerminalId();
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    private String getText(boolean required, final String title) {
        if (required) {
            final AtomicReference ref = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ref.set(OnlineEftpos.this.toolkit.getGuiHandler().getStringInput(title, ""));
                    }
                });
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot get Text for online payment", (Throwable)ex);
            }
            return (String)ref.get();
        }
        return null;
    }

    private Date getDate(boolean required, String title) {
        String dateText = this.getText(required, title);
        if (!StringUtils.isEmpty(dateText)) {
            try {
                return new SimpleDateFormat("dd-MM-yyyy").parse(dateText);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot parse date: " + dateText, (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

