/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.paypal;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Arrays;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.paypal.EftposTask;
import ordermate.integration.eftpos.paypal.EftposTaskContext;
import ordermate.integration.jaxb.paypal.PayPalInvoice;

public class AbsorbPayPalCustomerDetailsTask
extends EftposTask {
    @Override
    protected void doTask(EftposTaskContext taskContext) {
        EftposResult result = taskContext.getEftposResult();
        Payable payable = result.getRequest().getPayable();
        if (EftposStatus.APPROVED.equals(result.getEftposStatus()) && payable instanceof Account) {
            Account acc = (Account)payable;
            Customer customer = acc.getCustomer();
            String extCustomerID = taskContext.getWebPaymentCustomer().getExtCustId();
            if (customer == null && extCustomerID != null) {
                customer = PersistenceManager.getObject(Customer.class, Query.select(Customer.class).equals(Customer.Properties.EXT_WEB_ID, extCustomerID).toString());
            }
            if (customer == null) {
                customer = this.createNewCustomer(taskContext.getWebPaymentCustomer());
            }
            if (customer != null) {
                this.updateCustomer(customer, taskContext.getWebPaymentCustomer().getImage(), extCustomerID);
                User user = result.getRequest().getTransaction().getUser();
                Terminal terminal = result.getRequest().getTransaction().getTerminal();
                acc.setCustomer(customer, new EventContext(terminal, user));
            }
        }
        this.emitProgress();
    }

    private Customer createNewCustomer(WebPaymentCustomer webCustomer) {
        Customer newCustomer = new Customer();
        String fullName = webCustomer.getLabel();
        String[] split = fullName.split(" ");
        if (split.length != 2) {
            return null;
        }
        String first = split[0];
        String initial = split[1];
        newCustomer.setFirstName(first);
        newCustomer.setLastName(initial);
        newCustomer.setExtWebId(webCustomer.getExtCustId());
        newCustomer.save();
        return newCustomer;
    }

    private void updateCustomer(Customer customer, ConfigSmallImage configImage, String extCustomerId) {
        if (customer.getExtWebId() == null || customer.getExtWebId().equals(extCustomerId)) {
            ConfigSmallImage image = customer.getImage();
            if (configImage != null) {
                if (image == null) {
                    image = new ConfigSmallImage(configImage);
                    image.save();
                } else if (configImage.getImage() != null) {
                    image.setImage(configImage.getImage());
                    image.save();
                }
            }
            if (customer.getImage() == null || !Arrays.equals(customer.getImage().getImageData(), image.getImageData())) {
                customer.setImage(image);
            }
            if (customer.getExtWebId() == null) {
                customer.setExtWebId(extCustomerId);
            }
            customer.save();
        }
    }

    private String getEmailFromInvoice(EftposTaskContext taskContext) {
        String invoiceId = taskContext.getPayPalPaymentResponse().getInvoiceId();
        PayPalInvoice invoice = taskContext.getPayPalComms().getInvoice(invoiceId);
        if (invoice != null) {
            return invoice.getPayerEmail();
        }
        return null;
    }

    @Override
    public String getName() {
        return "Updating Customer Details";
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }
}

