/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.paypal;

import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.integration.eftpos.paypal.EftposTask;
import ordermate.integration.eftpos.paypal.EftposTaskContext;

public class EftposPaymentTaskFactory {
    private List<EftposTask> prePaymentTasks = new ArrayList<EftposTask>();
    private List<EftposTask> postPaymentTasks = new ArrayList<EftposTask>();

    public EftposPaymentTaskFactory(Class<? extends PhysicalEftpos> eftposClass) {
        this.constructTasksForEftpos(eftposClass);
    }

    public void performPrePaymentTasks(EftposTaskContext context) {
        this.performTasks(context, this.prePaymentTasks);
    }

    public void performPostPaymentTasks(EftposTaskContext context) {
        this.performTasks(context, this.prePaymentTasks);
    }

    private void performTasks(EftposTaskContext context, List<? extends EftposTask> tasks) {
        for (EftposTask eftposTask : tasks) {
            try {
                eftposTask.setEftposTaskContext(context).performTask();
            }
            catch (Exception e) {
                OrderMate.LOG.warn(eftposTask.getName() + " encountered an error in performTask", (Throwable)e);
            }
        }
    }

    private void constructTasksForEftpos(Class<? extends PhysicalEftpos> eftposClass) {
    }
}

