/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.paypal;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.finance.AccountPercentagePayable;
import ordermate.database.finance.CustomerPerSeatItemGroup;
import ordermate.database.finance.SplitItemGroup;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.PhysicalEftpos;
import ordermate.database.hardware.eftpos.WebPaymentRequest;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.sales.Account;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.EftposResultBuilder;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.integration.eftpos.paypal.EftposPaymentTaskFactory;
import ordermate.integration.eftpos.paypal.EftposTaskContext;
import ordermate.integration.jaxb.paypal.PayPalInvoice;
import ordermate.integration.jaxb.paypal.PayPalItem;
import ordermate.integration.jaxb.paypal.PayPalPayment;
import ordermate.integration.jaxb.paypal.PayPalPaymentResponse;
import ordermate.integration.jaxb.paypal.PayPalRefundResponse;
import ordermate.integration.paypal.PayPalComms;
import ordermate.integration.paypal.invoice.PayPalInvoiceHelper;

public class PayPalEftpos
implements PhysicalEftpos {
    private final long DEFAULT_SLEEP = 1000L;
    private final FinanceUnit unit;
    private final EftposToolkit toolkit;

    public PayPalEftpos(EftposToolkit toolkit) {
        this.toolkit = toolkit;
        this.unit = FinanceUnit.getPayPalUnit();
    }

    @Override
    public void configureEftpos(VirtualEftpos virtualEftpos) {
    }

    @Override
    public void closeOff() {
    }

    @Override
    public EftposResult performTransaction(EftposRequest request) {
        this.toolkit.getUI().displayBlockingInterface();
        if (!request.isReversal()) {
            this.toolkit.getUI().setMessage("Requesting invoice from PayPal", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
            WebPaymentRequest webRequest = (WebPaymentRequest)request;
            WebPaymentCustomer customer = webRequest.getWebCustomer();
            PayPalComms comms = this.createComms(webRequest.getWebIntegration());
            PayPalInvoice invoice = this.doInvoice(comms, request);
            if (invoice != null) {
                this.toolkit.getUI().setMessage("Requesting payment from PayPal", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
                EftposResultBuilder resultBuilder = new EftposResultBuilder(request);
                EftposResult result = resultBuilder.configureForIncompleteResult().build();
                this.performPrePaymentTasks(new EftposTaskContext(result).setPayPalComms(comms).setWebPaymentCustomer(customer));
                PayPalPaymentResponse paymentResponse = this.doPayment(comms, customer, invoice);
                result = this.handleResponse(paymentResponse, invoice, request);
                this.performPostPaymentTasks(new EftposTaskContext(result).setPayPalComms(comms).setPayPalPaymentResponse(paymentResponse).setWebPaymentCustomer(customer));
                return result;
            }
        } else {
            this.toolkit.getUI().setMessage("Performing Refund from PayPal", IntegratedPaymentUI.FeedbackStatus.PROGRESS);
            WebPaymentRequest webRequest = (WebPaymentRequest)request;
            PayPalComms comms = this.createComms(webRequest.getWebIntegration());
            PayPalRefundResponse refund = this.doRefund(comms, request.getTransaction().getTransactionReference());
            return this.handleRefundResponse(refund, request);
        }
        this.toolkit.getUI().closeBlockingInterface();
        return new EftposResultBuilder(request).configureForIncompleteResult().build();
    }

    protected PayPalComms createComms(WebPaymentIntegration integration) {
        return new PayPalComms(integration);
    }

    private EftposResult handleResponse(PayPalPaymentResponse response, PayPalInvoice invoice, EftposRequest request) {
        EftposResult result;
        if (response == null) {
            OrderMate.LOG.error("No response from PayPal");
            result = new EftposResultBuilder(request).configureForIncompleteResult().build();
            this.toolkit.getUI().setMessage("PayPal is not responsive", IntegratedPaymentUI.FeedbackStatus.ERROR);
        } else if (response.getTransactionNumber() == null) {
            OrderMate.LOG.warn("PayPal rejected the payment request ");
            EftposResultBuilder eftBuilder = new EftposResultBuilder(request);
            eftBuilder.setFinanceUnit(this.unit).setEftposStatus(EftposStatus.DECLINED).setActualPaid(request.getTransaction().getPaid()).setActualTip(request.getTransaction().getTip()).setExplicitError("Error in PayPal Communication or Payment Rejected");
            result = eftBuilder.build();
            this.toolkit.getUI().setMessage("PayPal Rejected the ", IntegratedPaymentUI.FeedbackStatus.WARNING);
        } else {
            OrderMate.LOG.info("PayPal Payment Received: " + response.getTransactionNumber());
            request.getTransaction().setTransactionReference(response.getTransactionNumber());
            EftposResultBuilder eftBuilder = new EftposResultBuilder(request);
            eftBuilder.setFinanceUnit(this.unit).setEftposStatus(EftposStatus.APPROVED).setActualPaid(this.calculateTotal(invoice));
            if (invoice.getGratuityAmount() != null) {
                eftBuilder.setActualTip(new Price(invoice.getGratuityAmount(), 0.01));
            }
            result = eftBuilder.build();
            this.toolkit.getUI().setMessage("PayPal Payment Received", IntegratedPaymentUI.FeedbackStatus.INFO);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.toolkit.getUI().closeBlockingInterface();
        return result;
    }

    private Price calculateTotal(PayPalInvoice invoice) {
        for (PayPalItem item : invoice.getItems()) {
            if (item.getName() != null && !item.getName().contains("TENDERED BY OTHER MEANS")) continue;
        }
        BigDecimal total = invoice.getTotal();
        BigDecimal tip = invoice.getGratuityAmount();
        if (tip != null) {
            total = total.subtract(tip);
        }
        return new Price(total, 0.01);
    }

    private EftposResult handleRefundResponse(PayPalRefundResponse refund, EftposRequest request) {
        EftposResult result;
        if (refund == null) {
            OrderMate.LOG.error("No response from PayPal");
            result = new EftposResultBuilder(request).configureForIncompleteResult().build();
            this.toolkit.getUI().setMessage("PayPal is not responsive", IntegratedPaymentUI.FeedbackStatus.ERROR);
        } else if (!refund.getState().equals("complete")) {
            OrderMate.LOG.warn("PayPal rejected the payment request ");
            EftposResultBuilder eftBuilder = new EftposResultBuilder(request);
            eftBuilder.setFinanceUnit(this.unit).setEftposStatus(EftposStatus.DECLINED).setActualPaid(request.getTransaction().getPaid()).setActualTip(request.getTransaction().getTip()).setExplicitError("Error in PayPal Communication or Payment Rejected");
            result = eftBuilder.build();
            this.toolkit.getUI().setMessage("PayPal Rejected the ", IntegratedPaymentUI.FeedbackStatus.WARNING);
        } else {
            OrderMate.LOG.info("PayPal Refund Received: " + refund.getId() + " for payment: " + refund.getParentPayment() + " for sale: " + refund.getSaleId());
            request.getTransaction().setTransactionReference(refund.getId());
            EftposResultBuilder eftBuilder = new EftposResultBuilder(request);
            eftBuilder.setFinanceUnit(this.unit).setEftposStatus(EftposStatus.APPROVED).setActualPaid(new Price(request.getTransaction().getTendered().negate(), 0.01)).setActualTip(request.getTransaction().getTip());
            result = eftBuilder.build();
            this.toolkit.getUI().setMessage("PayPal Refund Received", IntegratedPaymentUI.FeedbackStatus.INFO);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.toolkit.getUI().closeBlockingInterface();
        return result;
    }

    protected void performPrePaymentTasks(EftposTaskContext context) {
        EftposPaymentTaskFactory taskFactory = new EftposPaymentTaskFactory(this.getClass());
        taskFactory.performPrePaymentTasks(context);
    }

    protected void performPostPaymentTasks(EftposTaskContext context) {
        EftposPaymentTaskFactory taskFactory = new EftposPaymentTaskFactory(this.getClass());
        taskFactory.performPostPaymentTasks(context);
    }

    private PayPalInvoice doInvoice(PayPalComms comms, EftposRequest request) {
        PayPalInvoice invoice = PayPalInvoiceHelper.createInvoice();
        Payable payable = request.getPayable();
        Price toPay = request.getTransaction().getPaid();
        Price toTip = request.getTransaction().getTip();
        if (payable instanceof Account) {
            comms.getPayPalTool().applyItemsToInvoice(invoice, ((Account)payable).getItems(), toPay, toTip);
        } else if (payable instanceof AccountPercentagePayable) {
            comms.getPayPalTool().applyItemsToInvoice(invoice, ((AccountPercentagePayable)payable).getItemGroup().getItems(), toPay, toTip);
        } else if (payable instanceof SplitItemGroup) {
            comms.getPayPalTool().applyItemsToInvoice(invoice, ((SplitItemGroup)payable).getItems(), toPay, toTip);
        } else if (payable instanceof CustomerPerSeatItemGroup) {
            comms.getPayPalTool().applyItemsToInvoice(invoice, ((CustomerPerSeatItemGroup)payable).getItems(), toPay, toTip);
        } else {
            throw new IllegalArgumentException("Cannot process a paypal payment for non-accounts");
        }
        invoice = comms.postInvoice(invoice);
        return invoice;
    }

    private PayPalPaymentResponse doPayment(PayPalComms comms, WebPaymentCustomer customer, PayPalInvoice invoice) {
        PayPalPayment payment = new PayPalPayment();
        payment.setInvoiceId(invoice.getInvoiceID());
        payment.setPaymentType("tab");
        payment.setTabId(customer.getExtId());
        PayPalPaymentResponse response = comms.postPayment(payment);
        return response;
    }

    private PayPalRefundResponse doRefund(PayPalComms comms, String paymentTransactionNumber) {
        if (paymentTransactionNumber == null || paymentTransactionNumber.isEmpty()) {
            OrderMate.LOG.error("No Payment Transaction Id to perform a refund on!!");
        }
        PayPalRefundResponse response = comms.postRefund(paymentTransactionNumber);
        return response;
    }

    @Override
    public boolean supportsNonBlocking() {
        return false;
    }

    @Override
    public String getTerminalIDIfReady() {
        return "";
    }

    @Override
    public boolean isConnected(Terminal fromThisTerminal) {
        return true;
    }

    @Override
    public boolean supportsBlocking() {
        return true;
    }

    @Override
    public boolean supportsTipping() {
        return false;
    }

    @Override
    public void printInterruptedTransaction(String txnReference) {
    }

    @Override
    public String clearInterruptedTransactions() {
        return null;
    }

    @Override
    public boolean supportsCashoutWithRefunds() {
        return false;
    }

    @Override
    public boolean supportsPreAuth() {
        return false;
    }

    @Override
    public PreauthResult performPreauth(PreauthRequest request) {
        return null;
    }

    @Override
    public List<String> supportedPreAuth() {
        return null;
    }

    @Override
    public void doLastProcessesWithEftposResult(EftposResult result) {
    }

    @Override
    public boolean supportsMOTO() {
        return false;
    }
}

