/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.eftpos.pceftpos;

import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;

public class PCEftposDisplayResponse {
    private char inputType;
    private char graphicsCode;
    private int numberOfLines;
    private int lineLength;
    private List<String> displayText;
    private boolean cancelKeyFlag;
    private boolean acceptYesKeyFlag;
    private boolean declineNoKeyFlag;
    private boolean authoriseKeyFlag;
    private boolean okKeyFlag;
    private String purchaseAnalysisData;
    private boolean conversionSuccessful = false;

    public String getDisplayTextAsSingle() {
        String displayString = "";
        for (String display : this.displayText) {
            displayString = displayString + display;
        }
        return displayString;
    }

    public PCEftposDisplayResponse(String responseString) {
        if (!PCEftposDisplayResponse.isValidDisplayResponse(responseString)) {
            return;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        try {
            int index = startPosition + 6;
            this.numberOfLines = Integer.parseInt(responseString.substring(index, index + 2));
            this.lineLength = Integer.parseInt(responseString.substring(index += 2, index + 2));
            index += 2;
            this.displayText = new ArrayList<String>();
            for (int i = 0; i < this.numberOfLines; ++i) {
                this.displayText.add(responseString.substring(index, index + this.lineLength));
                index += this.lineLength;
            }
            this.setCancelKeyFlag(responseString.substring(index, index + 1).equals("1"));
            this.setAcceptYesKeyFlag(responseString.substring(++index, index + 1).equals("1"));
            this.setDeclineNoKeyFlag(responseString.substring(++index, index + 1).equals("1"));
            this.setAuthoriseKeyFlag(responseString.substring(++index, index + 1).equals("1"));
            this.setInputType(responseString.charAt(++index));
            this.setGraphicsCode(responseString.charAt(++index));
            int padLength = Integer.parseInt(responseString.substring(++index, index + 3));
            index += 3;
            if (padLength > 0) {
                this.setPurchaseAnalysisData(responseString.substring(index, index + padLength));
            }
            this.setConversionSuccessful(true);
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Error converting string to display response", (Throwable)ex);
            this.setConversionSuccessful(false);
        }
    }

    public static boolean isValidDisplayResponse(String responseString) {
        if (responseString == null || responseString.length() == 0) {
            return false;
        }
        int startPosition = 0;
        if (responseString.contains("#")) {
            startPosition = responseString.indexOf("#") + 1;
        }
        if (responseString.length() < startPosition + 5) {
            return false;
        }
        return responseString.substring(startPosition + 4, startPosition + 5).equals("S");
    }

    public char getInputType() {
        return this.inputType;
    }

    private void setInputType(char InputType) {
        this.inputType = InputType;
    }

    public char getGraphicsCode() {
        return this.graphicsCode;
    }

    private void setGraphicsCode(char GraphicsCode) {
        this.graphicsCode = GraphicsCode;
    }

    public boolean isCancelKeyFlag() {
        return this.cancelKeyFlag;
    }

    private void setCancelKeyFlag(boolean CancelKeyFlag) {
        this.cancelKeyFlag = CancelKeyFlag;
    }

    public boolean isAcceptYesKeyFlag() {
        return this.acceptYesKeyFlag;
    }

    private void setAcceptYesKeyFlag(boolean AcceptYesKeyFlag) {
        this.acceptYesKeyFlag = AcceptYesKeyFlag;
    }

    public boolean isDeclineNoKeyFlag() {
        return this.declineNoKeyFlag;
    }

    private void setDeclineNoKeyFlag(boolean DeclineNoKeyFlag) {
        this.declineNoKeyFlag = DeclineNoKeyFlag;
    }

    public boolean isAuthoriseKeyFlag() {
        return this.authoriseKeyFlag;
    }

    private void setAuthoriseKeyFlag(boolean AuthoriseKeyFlag) {
        this.authoriseKeyFlag = AuthoriseKeyFlag;
    }

    public boolean isOKKeyFlag() {
        return this.okKeyFlag;
    }

    private void setOKKeyFlag(boolean OKKeyFlag) {
        this.okKeyFlag = OKKeyFlag;
    }

    public String getPurchaseAnalysisData() {
        return this.purchaseAnalysisData;
    }

    private void setPurchaseAnalysisData(String PurchaseAnalysisData) {
        this.purchaseAnalysisData = PurchaseAnalysisData;
    }

    public boolean isConversionSuccessful() {
        return this.conversionSuccessful;
    }

    private void setConversionSuccessful(boolean conversionSuccessful) {
        this.conversionSuccessful = conversionSuccessful;
    }
}

